/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.roaringbitmap.buffer;

import com.clickhouse.client.internal.org.roaringbitmap.ContainerBatchIterator;
import com.clickhouse.client.internal.org.roaringbitmap.buffer.MappeableRunContainer;

public final class RunBatchIterator
implements ContainerBatchIterator {
    private MappeableRunContainer runs;
    private int run = 0;
    private int cursor = 0;

    public RunBatchIterator(MappeableRunContainer runs) {
        this.wrap(runs);
    }

    @Override
    public int next(int key, int[] buffer, int offset) {
        int consumed = 0;
        do {
            char runStart = this.runs.getValue(this.run);
            char runLength = this.runs.getLength(this.run);
            int chunkStart = runStart + this.cursor;
            int usableBufferLength = buffer.length - offset - consumed;
            int chunkEnd = chunkStart + Math.min(runLength - this.cursor, usableBufferLength - 1);
            int chunk = chunkEnd - chunkStart + 1;
            for (int i = 0; i < chunk; ++i) {
                buffer[offset + consumed + i] = key + chunkStart + i;
            }
            consumed += chunk;
            if (runStart + runLength == chunkEnd) {
                ++this.run;
                this.cursor = 0;
                continue;
            }
            this.cursor += chunk;
        } while (offset + consumed < buffer.length && this.run != this.runs.numberOfRuns());
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return this.run < this.runs.numberOfRuns();
    }

    @Override
    public ContainerBatchIterator clone() {
        try {
            return (ContainerBatchIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void releaseContainer() {
        this.runs = null;
    }

    @Override
    public void advanceIfNeeded(char target) {
        do {
            char runStart = this.runs.getValue(this.run);
            char runLength = this.runs.getLength(this.run);
            if (runStart > target) {
                this.cursor = 0;
                break;
            }
            int offset = target - runStart;
            if (offset <= runLength) {
                this.cursor = offset;
                break;
            }
            ++this.run;
            this.cursor = 0;
        } while (this.run != this.runs.numberOfRuns());
    }

    void wrap(MappeableRunContainer runs) {
        this.runs = runs;
        this.run = 0;
        this.cursor = 0;
    }
}

