/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.insert;

import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.internal.CommonSettings;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Map;

public class InsertSettings {
    private static final int DEFAULT_INPUT_STREAM_BATCH_SIZE = 8196;
    private int inputStreamCopyBufferSize;
    CommonSettings settings;

    public InsertSettings() {
        this.settings = new CommonSettings();
        this.setDefaults();
    }

    public InsertSettings(Map<String, Object> settings) {
        this.settings = new CommonSettings();
        this.setDefaults();
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            this.settings.setOption(entry.getKey(), entry.getValue());
        }
    }

    private InsertSettings(CommonSettings settings) {
        this.settings = settings;
        this.setDefaults();
    }

    private void setDefaults() {
        this.setInputStreamCopyBufferSize(8196);
    }

    public Object getOption(String option) {
        return this.settings.getOption(option);
    }

    public InsertSettings setOption(String option, Object value) {
        this.settings.setOption(option, value);
        return this;
    }

    public Map<String, Object> getAllSettings() {
        return this.settings.getAllSettings();
    }

    public InsertSettings setDeduplicationToken(String token) {
        this.serverSetting("insert_deduplication_token", token);
        return this;
    }

    public String getQueryId() {
        return this.settings.getQueryId();
    }

    public InsertSettings setQueryId(String queryId) {
        this.settings.setQueryId(queryId);
        return this;
    }

    public int getInputStreamCopyBufferSize() {
        return this.inputStreamCopyBufferSize;
    }

    public InsertSettings setInputStreamCopyBufferSize(int size) {
        this.inputStreamCopyBufferSize = size;
        return this;
    }

    public String getOperationId() {
        return this.settings.getOperationId();
    }

    public InsertSettings setOperationId(String operationId) {
        this.settings.setOperationId(operationId);
        return this;
    }

    public InsertSettings setDatabase(String database) {
        this.settings.setDatabase(database);
        return this;
    }

    public String getDatabase() {
        return this.settings.getDatabase();
    }

    public InsertSettings compressClientRequest(boolean enabled) {
        this.settings.setOption(ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getKey(), enabled);
        return this;
    }

    public InsertSettings useHttpCompression(boolean enabled) {
        this.settings.setOption(ClientConfigProperties.USE_HTTP_COMPRESSION.getKey(), enabled);
        return this;
    }

    public InsertSettings appCompressedData(boolean enabled, String compressionMethod) {
        this.settings.setOption(ClientConfigProperties.APP_COMPRESSED_DATA.getKey(), enabled);
        this.useHttpCompression(true);
        this.httpHeader("Content-Encoding", compressionMethod);
        return this;
    }

    public boolean isClientRequestEnabled() {
        return this.isClientCompressionEnabled();
    }

    public boolean isClientCompressionEnabled() {
        return (Boolean)this.settings.getOption(ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getKey(), false);
    }

    public InsertSettings httpHeader(String key, String value) {
        this.settings.httpHeader(key, value);
        return this;
    }

    public InsertSettings httpHeader(String key, Collection<String> values) {
        this.settings.httpHeader(key, values);
        return this;
    }

    public InsertSettings httpHeaders(Map<String, String> headers) {
        this.settings.httpHeaders(headers);
        return this;
    }

    public InsertSettings serverSetting(String name, String value) {
        this.settings.serverSetting(name, value);
        return this;
    }

    public InsertSettings serverSetting(String name, Collection<String> values) {
        this.settings.serverSetting(name, values);
        return this;
    }

    public InsertSettings setDBRoles(Collection<String> dbRoles) {
        this.settings.setDBRoles(dbRoles);
        return this;
    }

    public Collection<String> getDBRoles() {
        return this.settings.getDBRoles();
    }

    public InsertSettings logComment(String logComment) {
        this.settings.logComment(logComment);
        return this;
    }

    public String getLogComment() {
        return this.settings.getLogComment();
    }

    public static InsertSettings merge(InsertSettings source, InsertSettings override) {
        CommonSettings mergedSettings = source.settings.copyAndMerge(override.settings);
        InsertSettings insertSettings = new InsertSettings(mergedSettings);
        insertSettings.setInputStreamCopyBufferSize(override.getInputStreamCopyBufferSize());
        return insertSettings;
    }

    public void setNetworkTimeout(long timeout, ChronoUnit unit) {
        this.settings.setNetworkTimeout(timeout, unit);
    }

    public Long getNetworkTimeout() {
        return this.settings.getNetworkTimeout();
    }
}

