/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataProcessor;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

@Deprecated
public class ClickHouseStreamResponse
implements ClickHouseResponse {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseStreamResponse.class);
    private static final long serialVersionUID = 2271296998310082447L;
    private final TimeZone timeZone;
    protected static final List<ClickHouseColumn> defaultTypes = Collections.singletonList(ClickHouseColumn.of("results", "Nullable(String)"));
    protected final ClickHouseConfig config;
    protected final transient ClickHouseDataProcessor processor;
    protected final ClickHouseResponseSummary summary;
    private volatile boolean closed;

    public static ClickHouseResponse of(ClickHouseConfig config, ClickHouseInputStream input, Map<String, Serializable> settings, List<ClickHouseColumn> columns, ClickHouseResponseSummary summary, TimeZone timeZone) throws IOException {
        return new ClickHouseStreamResponse(config, input, settings, columns, summary, timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClickHouseStreamResponse(ClickHouseConfig config, ClickHouseInputStream input, Map<String, Serializable> settings, List<ClickHouseColumn> columns, ClickHouseResponseSummary summary, TimeZone timeZone) throws IOException {
        this.timeZone = timeZone;
        boolean hasError = true;
        try {
            if (timeZone != null && config.isUseServerTimeZone() && !config.getUseTimeZone().equals(timeZone)) {
                HashMap<ClickHouseOption, Serializable> configOptions = new HashMap<ClickHouseOption, Serializable>(config.getAllOptions());
                configOptions.put(ClickHouseClientOption.SERVER_TIME_ZONE, (Serializable)((Object)timeZone.getID()));
                config = new ClickHouseConfig(configOptions);
            }
            this.processor = ClickHouseDataStreamFactory.getInstance().getProcessor(config, input, null, settings, columns);
            hasError = false;
        }
        finally {
            if (hasError) {
                log.error((Object)"Failed to create stream response, closing input stream", new Object[0]);
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.config = config;
        this.closed = hasError;
        this.summary = summary != null ? summary : ClickHouseResponseSummary.EMPTY;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        ClickHouseInputStream input = this.processor.getInputStream();
        if (this.closed) return;
        if (input.isClosed()) {
            return;
        }
        try {
            long skipped = input.skip(Long.MAX_VALUE);
            if (skipped <= 0L) return;
            log.debug((Object)"%d bytes skipped before closing input stream", skipped);
            return;
        }
        catch (Exception e) {
            log.debug((Object)"Failed to skip reading input stream due to: %s", e.getMessage());
            return;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                log.warn((Object)"Failed to close input stream", e);
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public List<ClickHouseColumn> getColumns() {
        return this.processor.getColumns();
    }

    public ClickHouseFormat getFormat() {
        return this.config.getFormat();
    }

    @Override
    public ClickHouseResponseSummary getSummary() {
        return this.summary;
    }

    @Override
    public ClickHouseInputStream getInputStream() {
        return this.processor.getInputStream();
    }

    @Override
    public Iterable<ClickHouseRecord> records() {
        if (this.processor == null) {
            throw new UnsupportedOperationException("No data processor available for deserialization, please consider to use getInputStream instead");
        }
        return this.processor.records();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public <T> Iterable<T> records(Class<T> objClass) {
        if (this.processor == null) {
            throw new UnsupportedOperationException("No data processor available for deserialization, please consider to use getInputStream instead");
        }
        return this.processor.records(objClass, null);
    }
}

