/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.CreateMaterializedViewRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;

public final class CreateMaterializedViewRequest {
    private final String instanceId;
    private final CreateMaterializedViewRequest.Builder proto;

    public static CreateMaterializedViewRequest of(String instanceId, String materializedViewId) {
        return new CreateMaterializedViewRequest(instanceId, materializedViewId);
    }

    private CreateMaterializedViewRequest(String instanceId, String materializedViewId) {
        this.instanceId = instanceId;
        this.proto = com.google.bigtable.admin.v2.CreateMaterializedViewRequest.newBuilder();
        this.proto.setMaterializedViewId(materializedViewId);
    }

    public CreateMaterializedViewRequest setDeletionProtection(boolean value) {
        this.proto.getMaterializedViewBuilder().setDeletionProtection(value);
        return this;
    }

    public CreateMaterializedViewRequest setQuery(@Nonnull String query) {
        this.proto.getMaterializedViewBuilder().setQuery(query);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMaterializedViewRequest that = (CreateMaterializedViewRequest)o;
        return Objects.equal((Object)this.proto.build(), (Object)that.proto.build()) && Objects.equal((Object)this.instanceId, (Object)that.instanceId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto.build(), this.instanceId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CreateMaterializedViewRequest toProto(String projectId) {
        String name = NameUtil.formatInstanceName(projectId, this.instanceId);
        return this.proto.setParent(name).build();
    }
}

