/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.duckdb;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="DuckDB", typeDescription="DuckDB", image="duckdb.svg", documentationUrl="/database/databases/duckdb.html")
@GuiPlugin(id="GUI-DuckDBDatabaseMeta")
public class DuckDBDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    private static final Class<?> PKG = DuckDBDatabaseMeta.class;

    public String getCreateTableStatement() {
        return super.getCreateTableStatement();
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoIncrement, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        retval = addFieldName ? (String)retval + fieldname + " " : (String)retval + fieldname + " TYPE ";
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    retval = (String)retval + "BOOLEAN";
                    break;
                }
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = (String)retval + "IDENTITY";
                    break;
                }
                if (type == 5) {
                    if (length < 3) {
                        retval = (String)retval + "TINYINT";
                        break;
                    }
                    if (length < 5) {
                        retval = (String)retval + "SMALLINT";
                        break;
                    }
                    if (length < 10) {
                        retval = (String)retval + "INT";
                        break;
                    }
                    if (length < 20) {
                        retval = (String)retval + "BIGINT";
                        break;
                    }
                    retval = (String)retval + "DECIMAL(" + length + ")";
                    break;
                }
                if (type == 6) {
                    if (length < 1) {
                        length = 16;
                    }
                    if (precision < 1) {
                        precision = 16;
                    }
                    retval = (String)retval + "DECIMAL(" + length + "," + precision + ")";
                    break;
                }
                retval = (String)retval + "DOUBLE";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = (String)retval + "TEXT";
                    break;
                }
                retval = (String)retval + "VARCHAR";
                retval = length > 0 ? (String)retval + "(" + length : (String)retval + "(2147483647";
                retval = (String)retval + ")";
                break;
            }
            case 8: {
                retval = (String)retval + "BLOB";
                break;
            }
            default: {
                retval = (String)retval + "UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public String getDriverClass() {
        return "org.duckdb.DuckDBDriver";
    }

    public boolean isDuckDbVariant() {
        return true;
    }

    public String getURL(String hostname, String port, String databaseName) throws HopDatabaseException {
        return "jdbc:duckdb:" + (databaseName.equals("memory") ? "" : databaseName);
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoIncrement, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoIncrement, false, false);
    }

    public boolean isSupportsOptionsInURL() {
        return false;
    }

    public String[] getTableTypes() {
        return new String[]{"BASE TABLE", "LOCAL TEMPORARY"};
    }

    public void addDefaultOptions() {
        this.setSupportsBooleanDataType(true);
        this.setSupportsTimestampDataType(true);
    }
}

