/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.StorageService;

public class EndpointsForToken
extends Endpoints<EndpointsForToken> {
    private final Token token;

    EndpointsForToken(Token token, AbstractReplicaCollection.ReplicaList list, AbstractReplicaCollection.ReplicaMap<InetAddressAndPort> byEndpoint) {
        super(list, byEndpoint);
        this.token = token;
        assert (token != null);
    }

    public Token token() {
        return this.token;
    }

    public Builder newBuilder(int initialCapacity) {
        return new Builder(this.token, initialCapacity);
    }

    @Override
    public EndpointsForToken snapshot() {
        return this;
    }

    @Override
    protected EndpointsForToken snapshot(AbstractReplicaCollection.ReplicaList newList) {
        if (newList.isEmpty()) {
            return EndpointsForToken.empty(this.token);
        }
        AbstractReplicaCollection.ReplicaMap byEndpoint = null;
        if (this.byEndpoint != null && this.list.isSubList(newList)) {
            byEndpoint = this.byEndpoint.forSubList(newList);
        }
        return new EndpointsForToken(this.token, newList, byEndpoint);
    }

    public Replica lookup(InetAddressAndPort endpoint) {
        return this.byEndpoint().get(endpoint);
    }

    public static Builder builder(Token token) {
        return new Builder(token);
    }

    public static Builder builder(Token token, int capacity) {
        return new Builder(token, capacity);
    }

    public static EndpointsForToken empty(Token token) {
        return new EndpointsForToken(token, EMPTY_LIST, EMPTY_MAP);
    }

    public static EndpointsForToken of(Token token, Replica replica) {
        AbstractReplicaCollection.ReplicaList one = new AbstractReplicaCollection.ReplicaList(1);
        one.add(replica);
        return new EndpointsForToken(token, one, EndpointsForToken.endpointMap(one));
    }

    public static EndpointsForToken of(Token token, Replica ... replicas) {
        return EndpointsForToken.copyOf(token, Arrays.asList(replicas));
    }

    public static EndpointsForToken copyOf(Token token, Collection<Replica> replicas) {
        if (replicas.isEmpty()) {
            return EndpointsForToken.empty(token);
        }
        return (EndpointsForToken)EndpointsForToken.builder(token, replicas.size()).addAll(replicas).build();
    }

    public static EndpointsForToken copyOf(Token token, Iterable<Replica> replicas) {
        if (!replicas.iterator().hasNext()) {
            return EndpointsForToken.empty(token);
        }
        return (EndpointsForToken)EndpointsForToken.builder(token).addAll(replicas).build();
    }

    public static EndpointsForToken natural(Keyspace keyspace, Token token) {
        return keyspace.getReplicationStrategy().getNaturalReplicasForToken(token);
    }

    public static EndpointsForToken natural(AbstractReplicationStrategy replicationStrategy, Token token) {
        return replicationStrategy.getNaturalReplicasForToken(token);
    }

    public static EndpointsForToken natural(TableMetadata table, Token token) {
        return EndpointsForToken.natural(Keyspace.open(table.keyspace), token);
    }

    public static EndpointsForToken pending(TableMetadata table, Token token) {
        return EndpointsForToken.pending(table.keyspace, token);
    }

    public static EndpointsForToken pending(Keyspace keyspace, Token token) {
        return EndpointsForToken.pending(keyspace.getName(), token);
    }

    public static EndpointsForToken pending(String keyspace, Token token) {
        return StorageService.instance.getTokenMetadata().pendingEndpointsForToken(token, keyspace);
    }

    public static class Builder
    extends EndpointsForToken
    implements ReplicaCollection.Builder<EndpointsForToken> {
        boolean built;

        public Builder(Token token) {
            this(token, 0);
        }

        public Builder(Token token, int capacity) {
            this(token, new AbstractReplicaCollection.ReplicaList(capacity));
        }

        private Builder(Token token, AbstractReplicaCollection.ReplicaList list) {
            super(token, list, Builder.endpointMap(list));
        }

        public Builder add(Replica replica, ReplicaCollection.Builder.Conflict ignoreConflict) {
            if (this.built) {
                throw new IllegalStateException();
            }
            Preconditions.checkNotNull((Object)replica);
            if (!replica.range().contains(((EndpointsForToken)this).token)) {
                throw new IllegalArgumentException("Replica " + replica + " does not contain " + ((EndpointsForToken)this).token);
            }
            if (!this.byEndpoint.internalPutIfAbsent(replica, this.list.size())) {
                switch (ignoreConflict) {
                    case DUPLICATE: {
                        if (this.byEndpoint().get(replica.endpoint()).equals(replica)) break;
                    }
                    case NONE: {
                        throw new IllegalArgumentException("Conflicting replica added (expected unique endpoints): " + replica + "; existing: " + this.byEndpoint().get(replica.endpoint()));
                    }
                }
                return this;
            }
            this.list.add(replica);
            return this;
        }

        @Override
        public EndpointsForToken snapshot() {
            return this.snapshot(this.list.subList(0, this.list.size()));
        }

        @Override
        public EndpointsForToken build() {
            this.built = true;
            return new EndpointsForToken(((EndpointsForToken)this).token, this.list, this.byEndpoint);
        }
    }
}

