/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bq;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.TableResult;
import java.util.Date;
import java.util.StringJoiner;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.transforms.bq.BQField;
import org.apache.hop.beam.transforms.bq.BeamBQInputData;
import org.apache.hop.beam.transforms.bq.BeamBQInputMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class BeamBQInput
extends BaseTransform<BeamBQInputMeta, BeamBQInputData> {
    public BeamBQInput(TransformMeta transformMeta, BeamBQInputMeta meta, BeamBQInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        ((BeamBQInputData)this.data).bigquery = (BigQuery)BigQueryOptions.getDefaultInstance().getService();
        return super.init();
    }

    public boolean processRow() throws HopException {
        Object query;
        ((BeamBQInputData)this.data).outputRowMeta = new RowMeta();
        ((BeamBQInputMeta)this.meta).getFields(((BeamBQInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        if (StringUtils.isNotEmpty((String)((BeamBQInputMeta)this.meta).getQuery())) {
            query = this.resolve(((BeamBQInputMeta)this.meta).getQuery());
        } else {
            StringJoiner joiner = new StringJoiner(",");
            for (int i = 0; i < ((BeamBQInputMeta)this.meta).getFields().size(); ++i) {
                joiner.add(((BeamBQInputMeta)this.meta).getFields().get(i).getName());
            }
            String bgFields = joiner.toString();
            query = "SELECT " + bgFields + " FROM " + this.resolve(((BeamBQInputMeta)this.meta).getDatasetId() + "." + this.resolve(((BeamBQInputMeta)this.meta).getTableId()));
        }
        QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)query).setUseLegacySql(Boolean.valueOf(false)).build();
        ((BeamBQInputData)this.data).jobId = JobId.of((String)UUID.randomUUID().toString());
        ((BeamBQInputData)this.data).queryJob = ((BeamBQInputData)this.data).bigquery.create(JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(((BeamBQInputData)this.data).jobId).build(), new BigQuery.JobOption[0]);
        try {
            ((BeamBQInputData)this.data).queryJob = ((BeamBQInputData)this.data).queryJob.waitFor(new RetryOption[0]);
        }
        catch (InterruptedException e) {
            throw new HopException("BigQuery job was interrupted", (Throwable)e);
        }
        if (((BeamBQInputData)this.data).queryJob == null) {
            throw new HopException("Job no longer exists");
        }
        if (((BeamBQInputData)this.data).queryJob.getStatus().getError() != null) {
            throw new HopException("Error in BigQuery job: " + ((BeamBQInputData)this.data).queryJob.getStatus().getError().toString());
        }
        int[] fieldTypes = new int[((BeamBQInputMeta)this.meta).getFields().size()];
        for (int i = 0; i < fieldTypes.length; ++i) {
            BQField field = ((BeamBQInputMeta)this.meta).getFields().get(i);
            fieldTypes[i] = ValueMetaFactory.getIdForValueMeta((String)field.getHopType());
            if (fieldTypes[i] != 0) continue;
            throw new HopException("Unable to find Hop data type for return field: " + String.valueOf(field));
        }
        try {
            TableResult result = ((BeamBQInputData)this.data).queryJob.getQueryResults(new BigQuery.QueryResultsOption[0]);
            for (FieldValueList row : result.iterateAll()) {
                this.incrementLinesInput();
                Object[] outputRow = RowDataUtil.allocateRowData((int)((BeamBQInputData)this.data).outputRowMeta.size());
                int outputIndex = 0;
                for (int i = 0; i < ((BeamBQInputMeta)this.meta).getFields().size(); ++i) {
                    BQField field = ((BeamBQInputMeta)this.meta).getFields().get(i);
                    FieldValue fieldValue = row.get(field.getName());
                    Object hopValue = null;
                    if (!fieldValue.isNull()) {
                        hopValue = switch (fieldTypes[i]) {
                            case 2 -> fieldValue.getStringValue();
                            case 5 -> fieldValue.getLongValue();
                            case 3 -> new Date(fieldValue.getTimestampValue());
                            case 4 -> fieldValue.getBooleanValue();
                            case 1 -> fieldValue.getDoubleValue();
                            case 8 -> fieldValue.getBytesValue();
                            case 6 -> fieldValue.getNumericValue();
                            default -> throw new HopException("Converting BigQuery data to Hop type " + field.getHopType() + " isn't supported yet");
                        };
                    }
                    outputRow[outputIndex++] = hopValue;
                }
                this.putRow(((BeamBQInputData)this.data).outputRowMeta, outputRow);
                if (!this.isStopped()) continue;
                this.setOutputDone();
                return false;
            }
        }
        catch (InterruptedException e) {
            throw new HopException("BigQuery data retrieval was interrupted", (Throwable)e);
        }
        this.setOutputDone();
        return false;
    }
}

