/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.AbstractValueMap;
import com.ibm.as400.resource.ArrayTypeValueMap;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.DateValueMap;
import com.ibm.as400.resource.IntegerValueMap;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramKeyAttributeSetter;
import com.ibm.as400.resource.ProgramKeys;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.QualifiedValueMap;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ValueMap;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class RJob
extends ChangeableResource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_;
    private static final String ICON_BASE_NAME_ = "RJob";
    private static final String PRESENTATION_KEY_ = "JOB";
    public static final String SYSTEM_VALUE = "*SYSVAL";
    public static final String USER_PROFILE = "*USRPRF";
    public static final String YES = "*YES";
    public static final String NO = "*NO";
    public static final String NONE = "*NONE";
    public static final Date NO_DATE;
    static ResourceMetaDataTable attributes_;
    private static ProgramMap getterMap_;
    private static ProgramKeys setterKeys_;
    private static ArrayTypeValueMap arrayTypeValueMapString_;
    private static IntegerValueMap integerValueMap_;
    private static DateValueMap dateValueMap7_;
    private static DateValueMap dateValueMap6_;
    private static DateValueMap dateValueMap13_;
    private static DateValueMap dateValueMapDts_;
    private static final String JOBI0100_ = "qusrjobi_jobi0100";
    private static final String JOBI0150_ = "qusrjobi_jobi0150";
    private static final String JOBI0200_ = "qusrjobi_jobi0200";
    private static final String JOBI0300_ = "qusrjobi_jobi0300";
    private static final String JOBI0400_ = "qusrjobi_jobi0400";
    private static final String JOBI0500_ = "qusrjobi_jobi0500";
    private static final String JOBI0600_ = "qusrjobi_jobi0600";
    private static final String JOBI0700_ = "qusrjobi_jobi0700";
    private static final String JOBI0800_ = "qusrjobi_jobi0800";
    private static final String JOBI0900_ = "qusrjobi_jobi0900";
    public static final String ACCOUNTING_CODE = "ACCOUNTING_CODE";
    public static final String ACTIVE_JOB_STATUS = "ACTIVE_JOB_STATUS";
    public static final String AUXILIARY_IO_REQUESTS = "AUXILIARY_IO_REQUESTS";
    public static final String BREAK_MESSAGE_HANDLING = "BREAK_MESSAGE_HANDLING";
    public static final String BREAK_MESSAGE_HANDLING_NORMAL = "*NORMAL";
    public static final String BREAK_MESSAGE_HANDLING_HOLD = "*HOLD";
    public static final String BREAK_MESSAGE_HANDLING_NOTIFY = "*NOTIFY";
    public static final String CCSID = "CCSID";
    public static final int CCSID_SYSTEM_VALUE = -1;
    public static final int CCSID_INITIAL_USER = -2;
    public static final String COMPLETION_STATUS = "COMPLETION_STATUS";
    public static final String COMPLETION_STATUS_NOT_COMPLETED = "";
    public static final String COMPLETION_STATUS_COMPLETED_NORMALLY = "0";
    public static final String COMPLETION_STATUS_COMPLETED_ABNORMALLY = "1";
    public static final String CONTROLLED_END_REQUESTED = "CONTROLLED_END_REQUESTED";
    public static final String CONTROLLED_END_REQUESTED_CANCELED = "1";
    public static final String CONTROLLED_END_REQUESTED_NOT_CANCELED = "0";
    public static final String CONTROLLED_END_REQUESTED_NOT_RUNNING = "";
    public static final String COUNTRY_ID = "COUNTRY_ID";
    public static final String CPU_TIME_USED = "CPU_TIME_USED";
    public static final String CURRENT_LIBRARY = "CURRENT_LIBRARY";
    public static final String CURRENT_LIBRARY_EXISTENCE = "CURRENT_LIBRARY_EXISTENCE";
    public static final String CURRENT_SYSTEM_POOL_ID = "CURRENT_SYSTEM_POOL_ID";
    public static final String CURRENT_USER = "CURRENT_USER";
    public static final String DATE_ENTERED_SYSTEM = "DATE_ENTERED_SYSTEM";
    public static final String DATE_FORMAT = "DATE_FORMAT";
    public static final String DATE_FORMAT_SYSTEM_VALUE = "*SYS";
    public static final String DATE_FORMAT_YMD = "*YMD";
    public static final String DATE_FORMAT_MDY = "*MDY";
    public static final String DATE_FORMAT_DMY = "*DMY";
    public static final String DATE_FORMAT_JULIAN = "*JUL";
    public static final String DATE_SEPARATOR = "DATE_SEPARATOR";
    public static final String DATE_SEPARATOR_SYSTEM_VALUE = "S";
    public static final String DATE_STARTED = "DATE_STARTED";
    public static final String DBCS_CAPABLE = "DBCS_CAPABLE";
    public static final String DECIMAL_FORMAT = "DECIMAL_FORMAT";
    public static final String DECIMAL_FORMAT_PERIOD = "";
    public static final String DECIMAL_FORMAT_COMMA_I = "I";
    public static final String DECIMAL_FORMAT_COMMA_J = "J";
    public static final String DEFAULT_CCSID = "DEFAULT_CCSID";
    public static final String DEFAULT_WAIT_TIME = "DEFAULT_WAIT_TIME";
    public static final String DEVICE_RECOVERY_ACTION = "DEVICE_RECOVERY_ACTION";
    public static final String DEVICE_RECOVERY_ACTION_MESSAGE = "*MSG";
    public static final String DEVICE_RECOVERY_ACTION_DISCONNECT_MESSAGE = "*DSCMSG";
    public static final String DEVICE_RECOVERY_ACTION_DISCONNECT_END_REQUEST = "*DSCENDRQS";
    public static final String DEVICE_RECOVERY_ACTION_END_JOB = "*ENDJOB";
    public static final String DEVICE_RECOVERY_ACTION_END_JOB_NO_LIST = "*ENDJOBNOLIST";
    public static final String ELIGIBLE_FOR_PURGE = "ELIGIBLE_FOR_PURGE";
    public static final String END_SEVERITY = "END_SEVERITY";
    public static final String FUNCTION_NAME = "FUNCTION_NAME";
    public static final String FUNCTION_TYPE = "FUNCTION_TYPE";
    public static final String FUNCTION_TYPE_BLANK = "";
    public static final String FUNCTION_TYPE_COMMAND = "C";
    public static final String FUNCTION_TYPE_DELAY = "D";
    public static final String FUNCTION_TYPE_GROUP = "G";
    public static final String FUNCTION_TYPE_INDEX = "I";
    public static final String FUNCTION_TYPE_LOG = "L";
    public static final String FUNCTION_TYPE_MRT = "M";
    public static final String FUNCTION_TYPE_MENU = "N";
    public static final String FUNCTION_TYPE_IO = "O";
    public static final String FUNCTION_TYPE_PROGRAM = "P";
    public static final String FUNCTION_TYPE_PROCEDURE = "R";
    public static final String FUNCTION_TYPE_SPECIAL = "*";
    public static final String INQUIRY_MESSAGE_REPLY = "INQUIRY_MESSAGE_REPLY";
    public static final String INQUIRY_MESSAGE_REPLY_REQUIRED = "*RQD";
    public static final String INQUIRY_MESSAGE_REPLY_DEFAULT = "*DFT";
    public static final String INQUIRY_MESSAGE_REPLY_SYSTEM_REPLY_LIST = "*SYSRPYL";
    public static final String INSTANCE = "INSTANCE";
    public static final String INTERACTIVE_TRANSACTIONS = "INTERACTIVE_TRANSACTIONS";
    public static final String INTERNAL_JOB_ID = "INTERNAL_JOB_ID";
    public static final String JOB_DATE = "JOB_DATE";
    public static final String JOB_DESCRIPTION = "JOB_DESCRIPTION";
    public static final String JOB_NAME = "JOB_NAME";
    public static final String JOB_NUMBER = "JOB_NUMBER";
    public static final String JOB_QUEUE = "JOB_QUEUE";
    public static final String JOB_QUEUE_DATE = "JOB_QUEUE_DATE";
    public static final String JOB_QUEUE_PRIORITY = "JOB_QUEUE_PRIORITY";
    public static final String JOB_QUEUE_STATUS = "JOB_QUEUE_STATUS";
    public static final String JOB_QUEUE_STATUS_BLANK = "";
    public static final String JOB_QUEUE_STATUS_SCHEDULED = "SCD";
    public static final String JOB_QUEUE_STATUS_HELD = "HLD";
    public static final String JOB_QUEUE_STATUS_RELEASED = "RLS";
    public static final String JOB_STATUS = "JOB_STATUS";
    public static final String JOB_STATUS_ACTIVE = "*ACTIVE";
    public static final String JOB_STATUS_JOBQ = "*JOBQ";
    public static final String JOB_STATUS_OUTQ = "*OUTQ";
    public static final String JOB_SUBTYPE = "JOB_SUBTYPE";
    public static final String JOB_SUBTYPE_BLANK = "";
    public static final String JOB_SUBTYPE_IMMEDIATE = "D";
    public static final String JOB_SUBTYPE_PROCEDURE_START_REQUEST = "E";
    public static final String JOB_SUBTYPE_MACHINE_SERVER_JOB = "F";
    public static final String JOB_SUBTYPE_PRESTART = "J";
    public static final String JOB_SUBTYPE_PRINT_DRIVER = "P";
    public static final String JOB_SUBTYPE_MRT = "T";
    public static final String JOB_SUBTYPE_ALTERNATE_SPOOL_USER = "U";
    public static final String JOB_SWITCHES = "JOB_SWITCHES";
    public static final String JOB_TYPE = "JOB_TYPE";
    public static final String JOB_TYPE_NOT_VALID = "";
    public static final String JOB_TYPE_AUTOSTART = "A";
    public static final String JOB_TYPE_BATCH = "B";
    public static final String JOB_TYPE_INTERACTIVE = "I";
    public static final String JOB_TYPE_SUBSYSTEM_MONITOR = "M";
    public static final String JOB_TYPE_SPOOLED_READER = "R";
    public static final String JOB_TYPE_SYSTEM = "S";
    public static final String JOB_TYPE_SPOOLED_WRITER = "W";
    public static final String JOB_TYPE_SCPF_SYSTEM = "X";
    public static final String KEEP_DDM_CONNECTIONS_ACTIVE = "KEEP_DDM_CONNECTIONS_ACTIVE";
    public static final String KEEP_DDM_CONNECTIONS_ACTIVE_KEEP = "*KEEP";
    public static final String KEEP_DDM_CONNECTIONS_ACTIVE_DROP = "*DROP";
    public static final String LANGUAGE_ID = "LANGUAGE_ID";
    public static final String LOCATION_NAME = "LOCATION_NAME";
    public static final String LOG_CL_PROGRAMS = "LOG_CL_PROGRAMS";
    public static final String LOGGING_LEVEL = "LOGGING_LEVEL";
    public static final String LOGGING_LEVEL_NONE = "0";
    public static final String LOGGING_LEVEL_MESSAGES_BY_SEVERITY = "1";
    public static final String LOGGING_LEVEL_REQUESTS_BY_SEVERITY_AND_ASSOCIATED_MESSAGES = "2";
    public static final String LOGGING_LEVEL_ALL_REQUESTS_AND_ASSOCIATED_MESSAGES = "3";
    public static final String LOGGING_LEVEL_ALL_REQUESTS_AND_MESSAGES = "4";
    public static final String LOGGING_SEVERITY = "LOGGING_SEVERITY";
    public static final String LOGGING_TEXT = "LOGGING_TEXT";
    public static final String LOGGING_TEXT_MESSAGE = "*MSG";
    public static final String LOGGING_TEXT_SECLVL = "*SECLVL";
    public static final String LOGGING_TEXT_NO_LIST = "*NOLIST";
    public static final String MAX_CPU_TIME = "MAX_CPU_TIME";
    public static final String MAX_TEMP_STORAGE = "MAX_TEMP_STORAGE";
    public static final String MESSAGE_QUEUE_ACTION = "MESSAGE_QUEUE_ACTION";
    public static final String MESSAGE_QUEUE_ACTION_NO_WRAP = "*NOWRAP";
    public static final String MESSAGE_QUEUE_ACTION_WRAP = "*WRAP";
    public static final String MESSAGE_QUEUE_ACTION_PRINT_WRAP = "*PRTWRAP";
    public static final String MESSAGE_QUEUE_MAX_SIZE = "MESSAGE_QUEUE_MAX_SIZE";
    public static final String MODE = "MODE";
    public static final String NETWORK_ID = "NETWORK_ID";
    public static final String OUTPUT_QUEUE = "OUTPUT_QUEUE";
    public static final String OUTPUT_QUEUE_PRIORITY = "OUTPUT_QUEUE_PRIORITY";
    public static final String PRINT_KEY_FORMAT = "PRINT_KEY_FORMAT";
    public static final String PRINT_KEY_FORMAT_BORDER = "*PRTBDR";
    public static final String PRINT_KEY_FORMAT_HEADER = "*PRTHDR";
    public static final String PRINT_KEY_FORMAT_ALL = "*PRTALL";
    public static final String PRINT_TEXT = "PRINT_TEXT";
    public static final String PRINTER_DEVICE_NAME = "PRINTER_DEVICE_NAME";
    public static final String PRINTER_DEVICE_NAME_WORK_STATION = "*WRKSTN";
    public static final String PRODUCT_LIBRARIES = "PRODUCT_LIBRARIES";
    public static final String PRODUCT_RETURN_CODE = "PRODUCT_RETURN_CODE";
    public static final String PROGRAM_RETURN_CODE = "PROGRAM_RETURN_CODE";
    public static final String ROUTING_DATA = "ROUTING_DATA";
    public static final String RUN_PRIORITY = "RUN_PRIORITY";
    public static final String SCHEDULE_DATE = "SCHEDULE_DATE";
    public static final Date SCHEDULE_DATE_CURRENT;
    public static final Date SCHEDULE_DATE_MONTH_START;
    public static final Date SCHEDULE_DATE_MONTH_END;
    public static final Date SCHEDULE_DATE_MONDAY;
    public static final Date SCHEDULE_DATE_TUESDAY;
    public static final Date SCHEDULE_DATE_WEDNESDAY;
    public static final Date SCHEDULE_DATE_THURSDAY;
    public static final Date SCHEDULE_DATE_FRIDAY;
    public static final Date SCHEDULE_DATE_SATURDAY;
    public static final Date SCHEDULE_DATE_SUNDAY;
    public static final String SEQUENCE_NUMBER = "SEQUENCE_NUMBER";
    public static final String SERVER_TYPE = "SERVER_TYPE";
    public static final String SIGNED_ON_JOB = "SIGNED_ON_JOB";
    public static final String SORT_SEQUENCE_TABLE = "SORT_SEQUENCE_TABLE";
    public static final String SPECIAL_ENVIRONMENT = "SPECIAL_ENVIRONMENT";
    public static final String SPECIAL_ENVIRONMENT_SYSTEM_36 = "*S36";
    public static final String SPECIAL_ENVIRONMENT_NOT_ACTIVE = "";
    public static final String STATUS_MESSAGE_HANDLING = "STATUS_MESSAGE_HANDLING";
    public static final String STATUS_MESSAGE_HANDLING_NORMAL = "*NORMAL";
    public static final String SUBMITTED_BY_JOB_NAME = "SUBMITTED_BY_JOB_NAME";
    public static final String SUBMITTED_BY_JOB_NUMBER = "SUBMITTED_BY_JOB_NUMBER";
    public static final String SUBMITTED_BY_USER = "SUBMITTED_BY_USER";
    public static final String SUBSYSTEM = "SUBSYSTEM";
    public static final String SYSTEM_LIBRARY_LIST = "SYSTEM_LIBRARY_LIST";
    public static final String SYSTEM_POOL_ID = "SYSTEM_POOL_ID";
    public static final String TEMP_STORAGE_USED = "TEMP_STORAGE_USED";
    public static final String THREAD_COUNT = "THREAD_COUNT";
    public static final String TIME_SEPARATOR = "TIME_SEPARATOR";
    public static final String TIME_SEPARATOR_SYSTEM_VALUE = "S";
    public static final String TIME_SLICE = "TIME_SLICE";
    public static final String TIME_SLICE_END_POOL = "TIME_SLICE_END_POOL";
    public static final String TIME_SLICE_END_POOL_BASE = "*BASE";
    public static final String TOTAL_RESPONSE_TIME = "TOTAL_RESPONSE_TIME";
    public static final String USER_LIBRARY_LIST = "USER_LIBRARY_LIST";
    public static final String USER_NAME = "USER_NAME";
    public static final String USER_RETURN_CODE = "USER_RETURN_CODE";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RJob";
    private static ProgramCallDocument staticDocument_;
    private static final byte[] BLANK_INTERNAL_JOB_ID_;
    private byte[] internalJobID_ = null;
    private String name_ = "*";
    private String number_ = "";
    private String user_ = "";
    private ProgramAttributeGetter attributeGetter_ = null;
    private ProgramKeyAttributeSetter attributeSetter_ = null;

    private static Date computeSpecialDate(int second) {
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, second);
        return calendar.getTime();
    }

    public RJob() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    public RJob(AS400 system) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RJob(AS400 system, String name, String user, String number) {
        this();
        try {
            this.setSystem(system);
            this.setName(name);
            this.setUser(user);
            this.setNumber(number);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (name.equals(FUNCTION_TYPE_SPECIAL)) {
            if (user.trim().length() > 0) {
                throw new ExtendedIllegalArgumentException("user", 2);
            }
            if (number.trim().length() > 0) {
                throw new ExtendedIllegalArgumentException("number", 2);
            }
        }
    }

    public RJob(AS400 system, byte[] internalJobID) {
        this();
        try {
            this.setSystem(system);
            this.setName("*INT");
            this.setInternalJobID(internalJobID);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    protected void commitAttributeChanges(Object[] attributeIDs, Object[] values, int[] bidiStringTypes) throws ResourceException {
        super.commitAttributeChanges(attributeIDs, values, bidiStringTypes);
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeSetter_.setValues(attributeIDs, values, bidiStringTypes);
    }

    static Object computeResourceKey(AS400 system, String name, String user, String number, byte[] internalJobID) {
        if (internalJobID == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(RJob.class);
            buffer.append(':');
            buffer.append(system.getSystemName());
            buffer.append(':');
            buffer.append(system.getUserId());
            buffer.append(':');
            buffer.append(number);
            buffer.append('/');
            buffer.append(user);
            buffer.append('/');
            buffer.append(name);
            return buffer.toString();
        }
        return internalJobID;
    }

    public void createResource(Object[] attributeIDs, Object[] values) throws ResourceException {
        throw new ResourceException(5);
    }

    public void end() throws ResourceException {
        this.endInternal(-1);
    }

    public void end(int delayTime) throws ResourceException {
        if (delayTime < 0) {
            throw new ExtendedIllegalArgumentException("delayTime", 2);
        }
        this.endInternal(delayTime);
    }

    private void endInternal(int delayTime) throws ResourceException {
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.number_ == null) {
            throw new ExtendedIllegalStateException("number", 4);
        }
        if (this.user_ == null) {
            throw new ExtendedIllegalStateException("user", 4);
        }
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        AS400 sys = null;
        try {
            CommandCall commandCall;
            boolean success;
            StringBuilder buffer = new StringBuilder();
            buffer.append("ENDJOB JOB(");
            buffer.append(this.number_);
            buffer.append('/');
            buffer.append(this.user_);
            buffer.append('/');
            buffer.append(this.name_);
            buffer.append(") OPTION(");
            if (delayTime == 0) {
                buffer.append("*IMMED)");
            } else {
                buffer.append("*CNTRLD)");
                if (delayTime > 0) {
                    buffer.append(" DELAY(");
                    buffer.append(delayTime);
                    buffer.append(")");
                }
            }
            String endJob = buffer.toString();
            if (Trace.isTraceOn()) {
                Trace.log(3, "Ending the job:" + endJob);
            }
            if (!(success = (commandCall = new CommandCall(sys = new AS400(this.getSystem()), endJob)).run())) {
                throw new ResourceException(commandCall.getMessageList());
            }
        }
        catch (Exception e) {
            throw new ResourceException(e);
        }
        finally {
            if (sys != null) {
                sys.disconnectAllServices();
            }
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        AS400 system;
        ProgramCallDocument document;
        block6: {
            super.establishConnection();
            if (this.internalJobID_ == null) {
                if (this.name_ == null) {
                    throw new ExtendedIllegalStateException("name", 4);
                }
                if (this.number_ == null) {
                    throw new ExtendedIllegalStateException("number", 4);
                }
                if (this.user_ == null) {
                    throw new ExtendedIllegalStateException("user", 4);
                }
            }
            document = (ProgramCallDocument)staticDocument_.clone();
            system = this.getSystem();
            try {
                document.setSystem(system);
                byte[] actualInternalJobID = this.internalJobID_ == null ? BLANK_INTERNAL_JOB_ID_ : this.internalJobID_;
                document.setValue("qusrjobi_jobi0100.internalJobIdentifier", actualInternalJobID);
                document.setValue("qusrjobi_jobi0150.internalJobIdentifier", actualInternalJobID);
                document.setValue("qusrjobi_jobi0200.internalJobIdentifier", actualInternalJobID);
                document.setValue("qusrjobi_jobi0300.internalJobIdentifier", actualInternalJobID);
                document.setValue("qusrjobi_jobi0400.internalJobIdentifier", actualInternalJobID);
                document.setValue("qusrjobi_jobi0500.internalJobIdentifier", actualInternalJobID);
                document.setValue("qusrjobi_jobi0600.internalJobIdentifier", actualInternalJobID);
                document.setValue("qusrjobi_jobi0700.internalJobIdentifier", actualInternalJobID);
                document.setValue("qwtchgjb.internalJobIdentifier", actualInternalJobID);
                String actualName = this.internalJobID_ == null ? this.name_.toUpperCase() : "*INT";
                document.setValue("qusrjobi_jobi0100.qualifiedJobName.jobName", actualName);
                document.setValue("qusrjobi_jobi0150.qualifiedJobName.jobName", actualName);
                document.setValue("qusrjobi_jobi0200.qualifiedJobName.jobName", actualName);
                document.setValue("qusrjobi_jobi0300.qualifiedJobName.jobName", actualName);
                document.setValue("qusrjobi_jobi0400.qualifiedJobName.jobName", actualName);
                document.setValue("qusrjobi_jobi0500.qualifiedJobName.jobName", actualName);
                document.setValue("qusrjobi_jobi0600.qualifiedJobName.jobName", actualName);
                document.setValue("qusrjobi_jobi0700.qualifiedJobName.jobName", actualName);
                document.setValue("qwtchgjb.qualifiedJobName.jobName", actualName);
                String actualNumber = this.internalJobID_ == null ? this.number_ : "";
                document.setValue("qusrjobi_jobi0100.qualifiedJobName.jobNumber", actualNumber);
                document.setValue("qusrjobi_jobi0150.qualifiedJobName.jobNumber", actualNumber);
                document.setValue("qusrjobi_jobi0200.qualifiedJobName.jobNumber", actualNumber);
                document.setValue("qusrjobi_jobi0300.qualifiedJobName.jobNumber", actualNumber);
                document.setValue("qusrjobi_jobi0400.qualifiedJobName.jobNumber", actualNumber);
                document.setValue("qusrjobi_jobi0500.qualifiedJobName.jobNumber", actualNumber);
                document.setValue("qusrjobi_jobi0600.qualifiedJobName.jobNumber", actualNumber);
                document.setValue("qusrjobi_jobi0700.qualifiedJobName.jobNumber", actualNumber);
                document.setValue("qwtchgjb.qualifiedJobName.jobNumber", actualNumber);
                String actualUser = this.internalJobID_ == null ? this.user_.toUpperCase() : "";
                document.setValue("qusrjobi_jobi0100.qualifiedJobName.userName", actualUser);
                document.setValue("qusrjobi_jobi0150.qualifiedJobName.userName", actualUser);
                document.setValue("qusrjobi_jobi0200.qualifiedJobName.userName", actualUser);
                document.setValue("qusrjobi_jobi0300.qualifiedJobName.userName", actualUser);
                document.setValue("qusrjobi_jobi0400.qualifiedJobName.userName", actualUser);
                document.setValue("qusrjobi_jobi0500.qualifiedJobName.userName", actualUser);
                document.setValue("qusrjobi_jobi0600.qualifiedJobName.userName", actualUser);
                document.setValue("qusrjobi_jobi0700.qualifiedJobName.userName", actualUser);
                document.setValue("qwtchgjb.qualifiedJobName.userName", actualUser);
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block6;
                Trace.log(2, "Error setting PCML document values", (Throwable)e);
            }
        }
        this.attributeGetter_ = new ProgramAttributeGetter(system, document, getterMap_);
        this.attributeSetter_ = new ProgramKeyAttributeSetter(system, document, "qwtchgjb", "jobChangeInformation", setterKeys_);
    }

    @Override
    protected void freezeProperties() throws ResourceException {
        if (this.internalJobID_ == null) {
            if (this.name_ == null) {
                throw new ExtendedIllegalStateException("name", 4);
            }
            if (this.number_ == null) {
                throw new ExtendedIllegalStateException("number", 4);
            }
            if (this.user_ == null) {
                throw new ExtendedIllegalStateException("user", 4);
            }
        }
        if (this.getResourceKey() == null) {
            this.setResourceKey(RJob.computeResourceKey(this.getSystem(), this.name_, this.user_, this.number_, this.internalJobID_));
        }
        super.freezeProperties();
    }

    @Override
    public Object getAttributeUnchangedValue(Object attributeID, int bidiStringType) throws ResourceException {
        Object value = super.getAttributeUnchangedValue(attributeID, bidiStringType);
        if (value == null) {
            if (!this.isConnectionEstablished()) {
                this.establishConnection();
            }
            value = this.attributeGetter_.getValue(attributeID, bidiStringType);
        }
        return value;
    }

    public byte[] getInternalJobID() {
        return this.internalJobID_;
    }

    public String getName() {
        return this.name_;
    }

    public String getNumber() {
        return this.number_;
    }

    public String getUser() {
        return this.user_;
    }

    @Override
    protected boolean isBidiEnabled() {
        return true;
    }

    @Override
    public void refreshAttributeValues() throws ResourceException {
        super.refreshAttributeValues();
        if (this.attributeGetter_ != null) {
            this.attributeGetter_.clearBuffer();
        }
    }

    public void setInternalJobID(byte[] internalJobID) throws PropertyVetoException {
        if (internalJobID == null) {
            throw new NullPointerException("internalJobID");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        byte[] oldValue = this.internalJobID_;
        this.fireVetoableChange("internalJobID", oldValue, internalJobID);
        this.internalJobID_ = internalJobID;
        this.firePropertyChange("internalJobID", oldValue, internalJobID);
        Presentation presentation = this.getPresentation();
        presentation.setName("*INT");
        presentation.setFullName(this.toString());
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.name_;
        this.fireVetoableChange("name", oldValue, name);
        this.name_ = name;
        this.firePropertyChange("name", oldValue, name);
        Presentation presentation = this.getPresentation();
        presentation.setName(this.name_);
        presentation.setFullName(this.toString());
    }

    public void setNumber(String number) throws PropertyVetoException {
        if (number == null) {
            throw new NullPointerException("number");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.number_;
        this.fireVetoableChange("number", oldValue, number);
        this.number_ = number;
        this.firePropertyChange("number", oldValue, number);
        Presentation presentation = this.getPresentation();
        presentation.setFullName(this.toString());
    }

    public void setUser(String user) throws PropertyVetoException {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.user_;
        this.fireVetoableChange("user", oldValue, user);
        this.user_ = user;
        this.firePropertyChange("user", oldValue, user);
        Presentation presentation = this.getPresentation();
        presentation.setFullName(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.number_);
        buffer.append('/');
        buffer.append(this.user_);
        buffer.append('/');
        buffer.append(this.name_);
        return buffer.toString();
    }

    static {
        block2: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            NO_DATE = DateValueMap.NO_DATE;
            attributes_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            getterMap_ = new ProgramMap();
            setterKeys_ = new ProgramKeys();
            arrayTypeValueMapString_ = new ArrayTypeValueMap(String.class);
            integerValueMap_ = new IntegerValueMap();
            dateValueMap7_ = new DateValueMap(6);
            dateValueMap6_ = new DateValueMap(7);
            dateValueMap13_ = new DateValueMap(13);
            dateValueMapDts_ = new DateValueMap(99);
            attributes_.add((Object)ACCOUNTING_CODE, String.class, false);
            getterMap_.add(ACCOUNTING_CODE, JOBI0400_, "receiverVariable.jobAccountingCode");
            setterKeys_.add(ACCOUNTING_CODE, 1001, 1, 15);
            attributes_.add((Object)ACTIVE_JOB_STATUS, String.class, true);
            getterMap_.add(ACTIVE_JOB_STATUS, JOBI0200_, "receiverVariable.activeJobStatus");
            attributes_.add((Object)AUXILIARY_IO_REQUESTS, Integer.class, true);
            getterMap_.add(AUXILIARY_IO_REQUESTS, JOBI0200_, "receiverVariable.numberOfAuxiliaryIORequests");
            attributes_.add(BREAK_MESSAGE_HANDLING, String.class, false, new Object[]{"*NORMAL", BREAK_MESSAGE_HANDLING_HOLD, BREAK_MESSAGE_HANDLING_NOTIFY}, null, true);
            getterMap_.add(BREAK_MESSAGE_HANDLING, JOBI0400_, "receiverVariable.breakMessageHandling");
            setterKeys_.add(BREAK_MESSAGE_HANDLING, 201, 1, 10);
            attributes_.add(CCSID, Integer.class, false, new Object[]{-1, -2}, null, false);
            getterMap_.add(CCSID, JOBI0400_, "receiverVariable.codedCharacterSetID");
            setterKeys_.add(CCSID, 302, 0);
            attributes_.add(COMPLETION_STATUS, String.class, true, new Object[]{"", "0", "1"}, null, true);
            getterMap_.add(COMPLETION_STATUS, JOBI0400_, "receiverVariable.completionStatus");
            attributes_.add(CONTROLLED_END_REQUESTED, String.class, true, new Object[]{"1", "0", ""}, null, true);
            getterMap_.add(CONTROLLED_END_REQUESTED, JOBI0600_, "receiverVariable.endStatus");
            attributes_.add(COUNTRY_ID, String.class, false, new Object[]{SYSTEM_VALUE, USER_PROFILE}, null, false);
            getterMap_.add(COUNTRY_ID, JOBI0400_, "receiverVariable.countryID");
            setterKeys_.add(COUNTRY_ID, 303, 1, 10);
            attributes_.add((Object)CPU_TIME_USED, Integer.class, true);
            getterMap_.add(CPU_TIME_USED, JOBI0150_, "receiverVariable.processingUnitTimeUsed");
            getterMap_.add(CPU_TIME_USED, JOBI0200_, "receiverVariable.processingUnitTimeUsed");
            attributes_.add((Object)CURRENT_LIBRARY, String.class, true);
            getterMap_.add((Object)CURRENT_LIBRARY, JOBI0700_, "receiverVariable.currentLibrary", "receiverVariable.currentLibraryExistence", (ValueMap)new CurrentLibraryValueMap_());
            attributes_.add((Object)CURRENT_LIBRARY_EXISTENCE, Boolean.class, true);
            getterMap_.add((Object)CURRENT_LIBRARY_EXISTENCE, JOBI0700_, "receiverVariable.currentLibraryExistence", new BooleanValueMap(0, 1));
            attributes_.add((Object)CURRENT_SYSTEM_POOL_ID, Integer.class, true);
            getterMap_.add(CURRENT_SYSTEM_POOL_ID, JOBI0200_, "receiverVariable.currentSystemPoolIdentifier");
            attributes_.add((Object)CURRENT_USER, String.class, true);
            getterMap_.add(CURRENT_USER, JOBI0600_, "receiverVariable.currentUserProfile");
            attributes_.add((Object)DATE_ENTERED_SYSTEM, Date.class, true);
            getterMap_.add((Object)DATE_ENTERED_SYSTEM, JOBI0400_, "receiverVariable.dateAndTimeJobEnteredSystem", dateValueMap13_);
            attributes_.add(DATE_FORMAT, String.class, false, new Object[]{DATE_FORMAT_YMD, DATE_FORMAT_MDY, DATE_FORMAT_DMY, DATE_FORMAT_JULIAN, DATE_FORMAT_SYSTEM_VALUE}, null, true);
            getterMap_.add(DATE_FORMAT, JOBI0400_, "receiverVariable.dateFormat");
            setterKeys_.add(DATE_FORMAT, 405, 1, 4);
            attributes_.add(DATE_SEPARATOR, String.class, false, new Object[]{"S"}, null, false);
            getterMap_.add((Object)DATE_SEPARATOR, JOBI0400_, "receiverVariable.dateSeparator", new DateSeparatorValueMap_());
            setterKeys_.add(DATE_SEPARATOR, 406, 1, 1);
            attributes_.add((Object)DATE_STARTED, Date.class, true);
            getterMap_.add((Object)DATE_STARTED, JOBI0400_, "receiverVariable.dateAndTimeJobBecameActive", dateValueMap13_);
            attributes_.add((Object)DBCS_CAPABLE, Boolean.class, true);
            getterMap_.add((Object)DBCS_CAPABLE, JOBI0600_, "receiverVariable.dbcsCapable", new BooleanValueMap(new String[]{"0", ""}, new String[]{"1"}));
            attributes_.add(DECIMAL_FORMAT, String.class, false, new Object[]{SYSTEM_VALUE, "", "I", "J"}, null, true);
            getterMap_.add(DECIMAL_FORMAT, JOBI0400_, "receiverVariable.decimalFormat");
            setterKeys_.add(DECIMAL_FORMAT, 413, 1, 8);
            attributes_.add((Object)DEFAULT_CCSID, Integer.class, true);
            getterMap_.add(DEFAULT_CCSID, JOBI0400_, "receiverVariable.defaultCodedCharacterSetIdentifier");
            attributes_.add((Object)DEFAULT_WAIT_TIME, Integer.class, false);
            getterMap_.add(DEFAULT_WAIT_TIME, JOBI0100_, "receiverVariable.defaultWait");
            getterMap_.add(DEFAULT_WAIT_TIME, JOBI0150_, "receiverVariable.defaultWait");
            setterKeys_.add(DEFAULT_WAIT_TIME, 409, 0);
            attributes_.add(DEVICE_RECOVERY_ACTION, String.class, false, new Object[]{"*MSG", DEVICE_RECOVERY_ACTION_DISCONNECT_MESSAGE, DEVICE_RECOVERY_ACTION_DISCONNECT_END_REQUEST, DEVICE_RECOVERY_ACTION_END_JOB, DEVICE_RECOVERY_ACTION_END_JOB_NO_LIST, SYSTEM_VALUE}, null, true);
            getterMap_.add(DEVICE_RECOVERY_ACTION, JOBI0400_, "receiverVariable.deviceRecoveryAction");
            setterKeys_.add(DEVICE_RECOVERY_ACTION, 410, 1, 13);
            attributes_.add((Object)ELIGIBLE_FOR_PURGE, Boolean.class, false);
            Serializable valueMap = new BooleanValueMap(new String[]{NO, ""}, new String[]{YES});
            getterMap_.add((Object)ELIGIBLE_FOR_PURGE, JOBI0100_, "receiverVariable.purge", (ValueMap)((Object)valueMap));
            getterMap_.add((Object)ELIGIBLE_FOR_PURGE, JOBI0150_, "receiverVariable.purge", (ValueMap)((Object)valueMap));
            setterKeys_.add(ELIGIBLE_FOR_PURGE, 1604, 1, 4, (ValueMap)((Object)valueMap));
            attributes_.add((Object)END_SEVERITY, Integer.class, true);
            getterMap_.add(END_SEVERITY, JOBI0500_, "receiverVariable.endSeverity");
            attributes_.add((Object)FUNCTION_NAME, String.class, true);
            getterMap_.add(FUNCTION_NAME, JOBI0200_, "receiverVariable.functionName");
            attributes_.add(FUNCTION_TYPE, String.class, true, new String[]{"", FUNCTION_TYPE_COMMAND, "D", FUNCTION_TYPE_GROUP, "I", FUNCTION_TYPE_IO, FUNCTION_TYPE_LOG, FUNCTION_TYPE_MENU, "M", "R", "P", FUNCTION_TYPE_SPECIAL}, null, true);
            getterMap_.add(FUNCTION_TYPE, JOBI0200_, "receiverVariable.functionType");
            attributes_.add(INQUIRY_MESSAGE_REPLY, String.class, false, new String[]{INQUIRY_MESSAGE_REPLY_REQUIRED, INQUIRY_MESSAGE_REPLY_DEFAULT, INQUIRY_MESSAGE_REPLY_SYSTEM_REPLY_LIST}, null, true);
            getterMap_.add(INQUIRY_MESSAGE_REPLY, JOBI0400_, "receiverVariable.inquiryMessageReply");
            setterKeys_.add(INQUIRY_MESSAGE_REPLY, 901, 1, 10);
            attributes_.add((Object)INSTANCE, byte[].class, true);
            getterMap_.add(INSTANCE, JOBI0400_, "receiverVariable.unitOfWorkID.instance");
            attributes_.add((Object)INTERACTIVE_TRANSACTIONS, Integer.class, true);
            getterMap_.add(INTERACTIVE_TRANSACTIONS, JOBI0200_, "receiverVariable.numberOfInteractiveTransactions");
            attributes_.add((Object)INTERNAL_JOB_ID, byte[].class, true);
            getterMap_.add(INTERNAL_JOB_ID, JOBI0100_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(INTERNAL_JOB_ID, JOBI0150_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(INTERNAL_JOB_ID, JOBI0200_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(INTERNAL_JOB_ID, JOBI0300_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(INTERNAL_JOB_ID, JOBI0400_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(INTERNAL_JOB_ID, JOBI0500_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(INTERNAL_JOB_ID, JOBI0600_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(INTERNAL_JOB_ID, JOBI0700_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(INTERNAL_JOB_ID, JOBI0800_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(INTERNAL_JOB_ID, JOBI0900_, "receiverVariable.qualifiedJobName.jobName");
            attributes_.add((Object)JOB_DATE, Date.class, false);
            valueMap = new DateValueMap(7);
            getterMap_.add((Object)JOB_DATE, JOBI0300_, "receiverVariable.jobDate", (ValueMap)((Object)valueMap));
            setterKeys_.add(JOB_DATE, 1002, 1, 7, (ValueMap)((Object)valueMap));
            attributes_.add((Object)JOB_DESCRIPTION, String.class, true);
            getterMap_.add((Object)JOB_DESCRIPTION, JOBI0400_, "receiverVariable.jobDescription", new QualifiedValueMap(20, "JOBD"));
            attributes_.add((Object)JOB_NAME, String.class, true);
            getterMap_.add(JOB_NAME, JOBI0100_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(JOB_NAME, JOBI0150_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(JOB_NAME, JOBI0200_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(JOB_NAME, JOBI0300_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(JOB_NAME, JOBI0400_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(JOB_NAME, JOBI0500_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(JOB_NAME, JOBI0600_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(JOB_NAME, JOBI0700_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(JOB_NAME, JOBI0800_, "receiverVariable.qualifiedJobName.jobName");
            getterMap_.add(JOB_NAME, JOBI0900_, "receiverVariable.qualifiedJobName.jobName");
            attributes_.add((Object)JOB_NUMBER, String.class, true);
            getterMap_.add(JOB_NUMBER, JOBI0100_, "receiverVariable.qualifiedJobName.jobNumber");
            getterMap_.add(JOB_NUMBER, JOBI0150_, "receiverVariable.qualifiedJobName.jobNumber");
            getterMap_.add(JOB_NUMBER, JOBI0200_, "receiverVariable.qualifiedJobName.jobNumber");
            getterMap_.add(JOB_NUMBER, JOBI0300_, "receiverVariable.qualifiedJobName.jobNumber");
            getterMap_.add(JOB_NUMBER, JOBI0400_, "receiverVariable.qualifiedJobName.jobNumber");
            getterMap_.add(JOB_NUMBER, JOBI0500_, "receiverVariable.qualifiedJobName.jobNumber");
            getterMap_.add(JOB_NUMBER, JOBI0600_, "receiverVariable.qualifiedJobName.jobNumber");
            getterMap_.add(JOB_NUMBER, JOBI0700_, "receiverVariable.qualifiedJobName.jobNumber");
            getterMap_.add(JOB_NUMBER, JOBI0800_, "receiverVariable.qualifiedJobName.jobNumber");
            getterMap_.add(JOB_NUMBER, JOBI0900_, "receiverVariable.qualifiedJobName.jobNumber");
            attributes_.add((Object)JOB_QUEUE, String.class, false);
            valueMap = new QualifiedValueMap(20, "JOBQ");
            getterMap_.add((Object)JOB_QUEUE, JOBI0300_, "receiverVariable.jobQueue", (ValueMap)((Object)valueMap));
            setterKeys_.add(JOB_QUEUE, 1004, 1, 20, (ValueMap)((Object)valueMap));
            attributes_.add((Object)JOB_QUEUE_DATE, Date.class, true);
            getterMap_.add((Object)JOB_QUEUE_DATE, JOBI0300_, "receiverVariable.dateAndTimeJobWasPutOnThisJobQueue", dateValueMapDts_);
            attributes_.add((Object)JOB_QUEUE_PRIORITY, Integer.class, false);
            getterMap_.add((Object)JOB_QUEUE_PRIORITY, JOBI0300_, "receiverVariable.jobQueuePriority", integerValueMap_);
            setterKeys_.add(JOB_QUEUE_PRIORITY, 1005, 1, 2, integerValueMap_);
            attributes_.add(JOB_QUEUE_STATUS, String.class, true, new String[]{"", JOB_QUEUE_STATUS_SCHEDULED, JOB_QUEUE_STATUS_HELD, JOB_QUEUE_STATUS_RELEASED}, null, true);
            getterMap_.add(JOB_QUEUE_STATUS, JOBI0300_, "receiverVariable.statusOfJobOnThejobQueue");
            attributes_.add(JOB_STATUS, String.class, true, new String[]{JOB_STATUS_ACTIVE, JOB_STATUS_JOBQ, JOB_STATUS_OUTQ}, null, true);
            getterMap_.add(JOB_STATUS, JOBI0400_, "receiverVariable.jobStatus");
            attributes_.add(JOB_SUBTYPE, String.class, true, new String[]{"", "D", JOB_SUBTYPE_PROCEDURE_START_REQUEST, JOB_SUBTYPE_MACHINE_SERVER_JOB, "J", "P", JOB_SUBTYPE_MRT, JOB_SUBTYPE_ALTERNATE_SPOOL_USER}, null, true);
            getterMap_.add(JOB_SUBTYPE, JOBI0100_, "receiverVariable.jobSubtype");
            getterMap_.add(JOB_SUBTYPE, JOBI0150_, "receiverVariable.jobSubtype");
            getterMap_.add(JOB_SUBTYPE, JOBI0200_, "receiverVariable.jobSubtype");
            getterMap_.add(JOB_SUBTYPE, JOBI0300_, "receiverVariable.jobSubtype");
            getterMap_.add(JOB_SUBTYPE, JOBI0400_, "receiverVariable.jobSubtype");
            getterMap_.add(JOB_SUBTYPE, JOBI0500_, "receiverVariable.jobSubtype");
            getterMap_.add(JOB_SUBTYPE, JOBI0600_, "receiverVariable.jobSubtype");
            getterMap_.add(JOB_SUBTYPE, JOBI0700_, "receiverVariable.jobSubtype");
            getterMap_.add(JOB_SUBTYPE, JOBI0800_, "receiverVariable.jobSubtype");
            getterMap_.add(JOB_SUBTYPE, JOBI0900_, "receiverVariable.jobSubtype");
            attributes_.add((Object)JOB_SWITCHES, String.class, false);
            getterMap_.add(JOB_SWITCHES, JOBI0400_, "receiverVariable.jobSwitches");
            setterKeys_.add(JOB_SWITCHES, 1006, 1, 8);
            attributes_.add(JOB_TYPE, String.class, true, new String[]{"", JOB_TYPE_AUTOSTART, JOB_TYPE_BATCH, "I", "M", "R", "S", JOB_TYPE_SPOOLED_WRITER, JOB_TYPE_SCPF_SYSTEM}, null, true);
            getterMap_.add(JOB_TYPE, JOBI0100_, "receiverVariable.jobType");
            getterMap_.add(JOB_TYPE, JOBI0150_, "receiverVariable.jobType");
            getterMap_.add(JOB_TYPE, JOBI0200_, "receiverVariable.jobType");
            getterMap_.add(JOB_TYPE, JOBI0300_, "receiverVariable.jobType");
            getterMap_.add(JOB_TYPE, JOBI0400_, "receiverVariable.jobType");
            getterMap_.add(JOB_TYPE, JOBI0500_, "receiverVariable.jobType");
            getterMap_.add(JOB_TYPE, JOBI0600_, "receiverVariable.jobType");
            getterMap_.add(JOB_TYPE, JOBI0700_, "receiverVariable.jobType");
            getterMap_.add(JOB_TYPE, JOBI0800_, "receiverVariable.jobType");
            getterMap_.add(JOB_TYPE, JOBI0900_, "receiverVariable.jobType");
            attributes_.add(KEEP_DDM_CONNECTIONS_ACTIVE, String.class, false, new String[]{KEEP_DDM_CONNECTIONS_ACTIVE_KEEP, KEEP_DDM_CONNECTIONS_ACTIVE_DROP}, null, true);
            getterMap_.add(KEEP_DDM_CONNECTIONS_ACTIVE, JOBI0400_, "receiverVariable.ddmConversationHandling");
            setterKeys_.add(KEEP_DDM_CONNECTIONS_ACTIVE, 408, 1, 5);
            attributes_.add(LANGUAGE_ID, String.class, false, new String[]{SYSTEM_VALUE, USER_PROFILE}, null, false);
            getterMap_.add(LANGUAGE_ID, JOBI0400_, "receiverVariable.languageID");
            setterKeys_.add(LANGUAGE_ID, 1201, 1, 8);
            attributes_.add((Object)LOCATION_NAME, String.class, true);
            getterMap_.add(LOCATION_NAME, JOBI0400_, "receiverVariable.unitOfWorkID.locationName");
            attributes_.add((Object)LOG_CL_PROGRAMS, Boolean.class, false);
            valueMap = new BooleanValueMap(NO, YES);
            getterMap_.add((Object)LOG_CL_PROGRAMS, JOBI0400_, "receiverVariable.loggingOfCLPrograms", (ValueMap)((Object)valueMap));
            setterKeys_.add(LOG_CL_PROGRAMS, 1203, 1, 10, (ValueMap)((Object)valueMap));
            attributes_.add(LOGGING_LEVEL, String.class, false, new String[]{"0", "1", LOGGING_LEVEL_REQUESTS_BY_SEVERITY_AND_ASSOCIATED_MESSAGES, LOGGING_LEVEL_ALL_REQUESTS_AND_ASSOCIATED_MESSAGES, LOGGING_LEVEL_ALL_REQUESTS_AND_MESSAGES}, null, true);
            getterMap_.add(LOGGING_LEVEL, JOBI0500_, "receiverVariable.loggingLevel");
            setterKeys_.add(LOGGING_LEVEL, 1202, 1, 1);
            attributes_.add((Object)LOGGING_SEVERITY, Integer.class, false);
            getterMap_.add(LOGGING_SEVERITY, JOBI0500_, "receiverVariable.loggingSeverity");
            setterKeys_.add(LOGGING_SEVERITY, 1204, 0);
            attributes_.add(LOGGING_TEXT, String.class, false, new String[]{"*MSG", LOGGING_TEXT_SECLVL, LOGGING_TEXT_NO_LIST}, null, true);
            getterMap_.add(LOGGING_TEXT, JOBI0500_, "receiverVariable.loggingText");
            setterKeys_.add(LOGGING_TEXT, 1205, 1, 7);
            attributes_.add((Object)MAX_CPU_TIME, Integer.class, true);
            getterMap_.add(MAX_CPU_TIME, JOBI0150_, "receiverVariable.maximumProcessingUnitTime");
            attributes_.add((Object)MAX_TEMP_STORAGE, Integer.class, true);
            getterMap_.add(MAX_TEMP_STORAGE, JOBI0150_, "receiverVariable.maximumTemporaryStorageInMegabytes");
            attributes_.add(MESSAGE_QUEUE_ACTION, String.class, false, new String[]{MESSAGE_QUEUE_ACTION_NO_WRAP, MESSAGE_QUEUE_ACTION_WRAP, MESSAGE_QUEUE_ACTION_PRINT_WRAP}, null, true);
            getterMap_.add(MESSAGE_QUEUE_ACTION, JOBI0400_, "receiverVariable.jobMessageQueueFullAction");
            setterKeys_.add(MESSAGE_QUEUE_ACTION, 1007, 1, 10);
            attributes_.add((Object)MESSAGE_QUEUE_MAX_SIZE, Integer.class, true);
            getterMap_.add(MESSAGE_QUEUE_MAX_SIZE, JOBI0400_, "receiverVariable.jobMessageQueueMaximumSize");
            attributes_.add((Object)MODE, String.class, true);
            getterMap_.add(MODE, JOBI0400_, "receiverVariable.modeName");
            attributes_.add((Object)NETWORK_ID, String.class, true);
            getterMap_.add(NETWORK_ID, JOBI0400_, "receiverVariable.unitOfWorkID.networkID");
            attributes_.add((Object)OUTPUT_QUEUE, String.class, false);
            valueMap = new QualifiedValueMap(20, "OUTQ");
            getterMap_.add((Object)OUTPUT_QUEUE, JOBI0300_, "receiverVariable.outputQueue", (ValueMap)((Object)valueMap));
            setterKeys_.add(OUTPUT_QUEUE, 1501, 1, 20, (ValueMap)((Object)valueMap));
            attributes_.add((Object)OUTPUT_QUEUE_PRIORITY, Integer.class, false);
            getterMap_.add((Object)OUTPUT_QUEUE_PRIORITY, JOBI0300_, "receiverVariable.outputQueuePriority", integerValueMap_);
            setterKeys_.add(OUTPUT_QUEUE_PRIORITY, 1502, 1, 2, integerValueMap_);
            attributes_.add(PRINT_KEY_FORMAT, String.class, false, new String[]{NONE, PRINT_KEY_FORMAT_BORDER, PRINT_KEY_FORMAT_HEADER, PRINT_KEY_FORMAT_ALL, SYSTEM_VALUE}, null, true);
            getterMap_.add(PRINT_KEY_FORMAT, JOBI0400_, "receiverVariable.printKeyFormat");
            setterKeys_.add(PRINT_KEY_FORMAT, 1601, 1, 10);
            attributes_.add(PRINT_TEXT, String.class, false, new String[]{SYSTEM_VALUE}, null, false);
            getterMap_.add(PRINT_TEXT, JOBI0400_, "receiverVariable.printText");
            setterKeys_.add(PRINT_TEXT, 1602, 1, 30);
            attributes_.add(PRINTER_DEVICE_NAME, String.class, false, new String[]{SYSTEM_VALUE, PRINTER_DEVICE_NAME_WORK_STATION, USER_PROFILE}, null, false);
            getterMap_.add(PRINTER_DEVICE_NAME, JOBI0300_, "receiverVariable.printerDeviceName");
            setterKeys_.add(PRINTER_DEVICE_NAME, 1603, 1, 10);
            attributes_.add((Object)PRODUCT_LIBRARIES, String[].class, true);
            getterMap_.add((Object)PRODUCT_LIBRARIES, JOBI0700_, "receiverVariable.productLibraries", "receiverVariable.numberOfProductLibraries", (ValueMap)arrayTypeValueMapString_);
            attributes_.add((Object)PRODUCT_RETURN_CODE, Integer.class, true);
            getterMap_.add(PRODUCT_RETURN_CODE, JOBI0600_, "receiverVariable.productReturnCode");
            attributes_.add((Object)PROGRAM_RETURN_CODE, Integer.class, true);
            getterMap_.add(PROGRAM_RETURN_CODE, JOBI0600_, "receiverVariable.programReturnCode");
            attributes_.add((Object)ROUTING_DATA, String.class, true);
            getterMap_.add(ROUTING_DATA, JOBI0400_, "receiverVariable.routingData");
            attributes_.add((Object)RUN_PRIORITY, Integer.class, false);
            getterMap_.add(RUN_PRIORITY, JOBI0200_, "receiverVariable.runPriority");
            setterKeys_.add(RUN_PRIORITY, 1802, 0);
            SCHEDULE_DATE_CURRENT = RJob.computeSpecialDate(0);
            SCHEDULE_DATE_MONTH_START = RJob.computeSpecialDate(10);
            SCHEDULE_DATE_MONTH_END = RJob.computeSpecialDate(20);
            SCHEDULE_DATE_MONDAY = RJob.computeSpecialDate(1);
            SCHEDULE_DATE_TUESDAY = RJob.computeSpecialDate(2);
            SCHEDULE_DATE_WEDNESDAY = RJob.computeSpecialDate(3);
            SCHEDULE_DATE_THURSDAY = RJob.computeSpecialDate(4);
            SCHEDULE_DATE_FRIDAY = RJob.computeSpecialDate(5);
            SCHEDULE_DATE_SATURDAY = RJob.computeSpecialDate(6);
            SCHEDULE_DATE_SUNDAY = RJob.computeSpecialDate(7);
            attributes_.add(SCHEDULE_DATE, Date.class, false, new Date[]{SCHEDULE_DATE_CURRENT, SCHEDULE_DATE_MONTH_START, SCHEDULE_DATE_MONTH_END, SCHEDULE_DATE_MONDAY, SCHEDULE_DATE_TUESDAY, SCHEDULE_DATE_WEDNESDAY, SCHEDULE_DATE_THURSDAY, SCHEDULE_DATE_FRIDAY, SCHEDULE_DATE_SATURDAY, SCHEDULE_DATE_SUNDAY}, null, false, false, new String[]{"CURRENT", "MONTHSTR", "MONTHEND", "MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"});
            getterMap_.add((Object)SCHEDULE_DATE, JOBI0400_, "receiverVariable.dateAndTimeJobIsScheduledToRun", dateValueMapDts_);
            setterKeys_.add(SCHEDULE_DATE, 1920, 1, 10, new ScheduleDateValueMap_(13));
            setterKeys_.add(SCHEDULE_DATE, 1921, 1, 8, new ScheduleDateValueMap_(6));
            attributes_.add((Object)SEQUENCE_NUMBER, String.class, true);
            getterMap_.add(SEQUENCE_NUMBER, JOBI0400_, "receiverVariable.unitOfWorkID.sequenceNumber");
            attributes_.add((Object)SERVER_TYPE, String.class, true);
            getterMap_.add(SERVER_TYPE, JOBI0400_, "receiverVariable.serverType");
            attributes_.add((Object)SIGNED_ON_JOB, Boolean.class, true);
            getterMap_.add((Object)SIGNED_ON_JOB, JOBI0400_, "receiverVariable.signedOnJob", new BooleanValueMap(new Object[]{"1"}, new Object[]{"0", ""}));
            attributes_.add((Object)SORT_SEQUENCE_TABLE, String.class, false);
            valueMap = new QualifiedValueMap(20, "FILE");
            getterMap_.add((Object)SORT_SEQUENCE_TABLE, JOBI0400_, "receiverVariable.sortSequence", (ValueMap)((Object)valueMap));
            setterKeys_.add(SORT_SEQUENCE_TABLE, 1901, 1, 20, (ValueMap)((Object)valueMap));
            attributes_.add(SPECIAL_ENVIRONMENT, String.class, true, new String[]{NONE, SPECIAL_ENVIRONMENT_SYSTEM_36, ""}, null, true);
            getterMap_.add(SPECIAL_ENVIRONMENT, JOBI0600_, "receiverVariable.specialEnvironment");
            attributes_.add(STATUS_MESSAGE_HANDLING, String.class, false, new String[]{NONE, "*NORMAL", SYSTEM_VALUE, USER_PROFILE}, null, true);
            getterMap_.add(STATUS_MESSAGE_HANDLING, JOBI0400_, "receiverVariable.statusMessageHandling");
            setterKeys_.add(STATUS_MESSAGE_HANDLING, 1902, 1, 10);
            attributes_.add((Object)SUBMITTED_BY_JOB_NAME, String.class, true);
            getterMap_.add(SUBMITTED_BY_JOB_NAME, JOBI0300_, "receiverVariable.submittersJob.jobName");
            attributes_.add((Object)SUBMITTED_BY_JOB_NUMBER, String.class, true);
            getterMap_.add(SUBMITTED_BY_JOB_NUMBER, JOBI0300_, "receiverVariable.submittersJob.jobNumber");
            attributes_.add((Object)SUBMITTED_BY_USER, String.class, true);
            getterMap_.add(SUBMITTED_BY_USER, JOBI0300_, "receiverVariable.submittersJob.userName");
            attributes_.add((Object)SUBSYSTEM, String.class, true);
            getterMap_.add((Object)SUBSYSTEM, JOBI0600_, "receiverVariable.subsystemDescription", new QualifiedValueMap(20, "SBSD"));
            attributes_.add((Object)SYSTEM_LIBRARY_LIST, String[].class, true);
            getterMap_.add((Object)SYSTEM_LIBRARY_LIST, JOBI0700_, "receiverVariable.systemLibraryList", "receiverVariable.numberOfLibrariesInSystemLibraryList", (ValueMap)arrayTypeValueMapString_);
            attributes_.add((Object)SYSTEM_POOL_ID, Integer.class, true);
            getterMap_.add(SYSTEM_POOL_ID, JOBI0150_, "receiverVariable.systemPoolIdentifier");
            getterMap_.add(SYSTEM_POOL_ID, JOBI0200_, "receiverVariable.systemPoolIdentifier");
            attributes_.add((Object)TEMP_STORAGE_USED, Integer.class, true);
            getterMap_.add(TEMP_STORAGE_USED, JOBI0150_, "receiverVariable.temporaryStorageUsedInMegabytes");
            attributes_.add((Object)THREAD_COUNT, Integer.class, true);
            getterMap_.add(THREAD_COUNT, JOBI0150_, "receiverVariable.threadCount");
            getterMap_.add(THREAD_COUNT, JOBI0200_, "receiverVariable.threadCount");
            attributes_.add(TIME_SEPARATOR, String.class, false, new String[]{"S"}, null, false);
            getterMap_.add(TIME_SEPARATOR, JOBI0400_, "receiverVariable.timeSeparator");
            setterKeys_.add(TIME_SEPARATOR, 2001, 1, 1);
            attributes_.add((Object)TIME_SLICE, Integer.class, false);
            getterMap_.add(TIME_SLICE, JOBI0100_, "receiverVariable.timeSlice");
            setterKeys_.add(TIME_SLICE, 2002, 0);
            attributes_.add(TIME_SLICE_END_POOL, String.class, false, new String[]{NONE, TIME_SLICE_END_POOL_BASE, SYSTEM_VALUE}, null, true);
            getterMap_.add(TIME_SLICE_END_POOL, JOBI0150_, "receiverVariable.timeSliceEndPool");
            setterKeys_.add(TIME_SLICE_END_POOL, 2003, 1, 10);
            attributes_.add((Object)TOTAL_RESPONSE_TIME, Integer.class, true);
            getterMap_.add(TOTAL_RESPONSE_TIME, JOBI0200_, "receiverVariable.responseTimeTotal");
            attributes_.add((Object)USER_LIBRARY_LIST, String[].class, true);
            getterMap_.add((Object)USER_LIBRARY_LIST, JOBI0700_, "receiverVariable.userLibraryList", "receiverVariable.numberOfLibrariesInUserLibraryList", (ValueMap)arrayTypeValueMapString_);
            attributes_.add((Object)USER_NAME, String.class, true);
            getterMap_.add(USER_NAME, JOBI0100_, "receiverVariable.qualifiedJobName.userName");
            getterMap_.add(USER_NAME, JOBI0150_, "receiverVariable.qualifiedJobName.userName");
            getterMap_.add(USER_NAME, JOBI0200_, "receiverVariable.qualifiedJobName.userName");
            getterMap_.add(USER_NAME, JOBI0300_, "receiverVariable.qualifiedJobName.userName");
            getterMap_.add(USER_NAME, JOBI0400_, "receiverVariable.qualifiedJobName.userName");
            getterMap_.add(USER_NAME, JOBI0500_, "receiverVariable.qualifiedJobName.userName");
            getterMap_.add(USER_NAME, JOBI0600_, "receiverVariable.qualifiedJobName.userName");
            getterMap_.add(USER_NAME, JOBI0700_, "receiverVariable.qualifiedJobName.userName");
            getterMap_.add(USER_NAME, JOBI0800_, "receiverVariable.qualifiedJobName.userName");
            getterMap_.add(USER_NAME, JOBI0900_, "receiverVariable.qualifiedJobName.userName");
            attributes_.add((Object)USER_RETURN_CODE, Integer.class, true);
            getterMap_.add(USER_RETURN_CODE, JOBI0600_, "receiverVariable.userReturnCode");
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)e);
            }
        }
        BLANK_INTERNAL_JOB_ID_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    }

    private static class ScheduleDateValueMap_
    extends DateValueMap {
        private static Hashtable constantMap_ = new Hashtable();
        private boolean time_;

        public ScheduleDateValueMap_(int type) {
            super(type);
            this.time_ = type == 6;
        }

        @Override
        public Object ltop(Object logicalValue, AS400 system) {
            if (constantMap_.containsKey(logicalValue)) {
                if (this.time_ && logicalValue.equals(SCHEDULE_DATE_CURRENT)) {
                    return "*CURRENT";
                }
                if (!this.time_) {
                    return constantMap_.get(logicalValue);
                }
            }
            return super.ltop(logicalValue, system);
        }

        static {
            constantMap_.put(SCHEDULE_DATE_CURRENT, "*CURRENT");
            constantMap_.put(SCHEDULE_DATE_MONTH_START, "*MONTHSTR");
            constantMap_.put(SCHEDULE_DATE_MONTH_END, "*MONTHEND");
            constantMap_.put(SCHEDULE_DATE_MONDAY, "*MON");
            constantMap_.put(SCHEDULE_DATE_TUESDAY, "*TUE");
            constantMap_.put(SCHEDULE_DATE_WEDNESDAY, "*WED");
            constantMap_.put(SCHEDULE_DATE_THURSDAY, "*THU");
            constantMap_.put(SCHEDULE_DATE_FRIDAY, "*FRI");
            constantMap_.put(SCHEDULE_DATE_SATURDAY, "*SAT");
            constantMap_.put(SCHEDULE_DATE_SUNDAY, "*SUN");
        }
    }

    private static class DateSeparatorValueMap_
    extends AbstractValueMap {
        private DateSeparatorValueMap_() {
        }

        @Override
        public Object ptol(Object physicalValue, AS400 system) {
            if (((String)physicalValue).length() == 0) {
                return " ";
            }
            return super.ptol(physicalValue);
        }
    }

    private static class CurrentLibraryValueMap_
    extends AbstractValueMap {
        private CurrentLibraryValueMap_() {
        }

        @Override
        public Object ptol(Object physicalValue) {
            String[] logicalValue = (String[])arrayTypeValueMapString_.ptol(physicalValue);
            if (logicalValue.length == 0) {
                return "";
            }
            return logicalValue[0];
        }
    }
}

