/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserObjectsOwnedListEntry;
import com.ibm.as400.access.UserSpace;
import java.io.IOException;

public class UserObjectsOwnedList {
    private static final String USERSPACE_NAME = "JT4SYLOBJAQTEMP     ";
    private static final String USERSPACE_PATH = "/QSYS.LIB/QTEMP.LIB/JT4SYLOBJA.USRSPC";
    private static final String CONTINUATION_HANDLE_BLANKS = "                    ";
    public static final int SELECTION_FILE_SYSTEM_LIBRARY = 0;
    private static final String SELECTION_FILE_SYSTEM_LIBRARY_0300 = "OBJA0300";
    public static final int SELECTION_FILE_SYSTEM_DIRECTORY = 1;
    private static final String SELECTION_FILE_SYSTEM_DIRECTORY_0310 = "OBJA0310";
    public static final int SELECTION_OBJECT_RELATION_AUTHORIZED = 0;
    private static final String SELECTION_OBJECT_RELATION_AUTHORIZED_PRIV = "*OBJAUT   ";
    public static final int SELECTION_OBJECT_RELATION_OWNED = 1;
    private static final String SELECTION_OBJECT_RELATION_OWNED_PRIV = "*OBJOWN   ";
    public static final int SELECTION_OBJECT_RELATION_OWNED_OR_AUTHORIZED = 2;
    private static final String SELECTION_OBJECT_RELATION_OWNED_OR_AUTHORIZED_PRIV = "*BOTH     ";
    private static final String SELECTION_OBJECT_TYPE_ALL_PRIV = "*ALL      ";
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private AS400 system_;
    private String userName_;
    private String selectionFileSystem_;
    private String selectionObjectRelation_;

    public UserObjectsOwnedList(AS400 system, String userName) {
        this(system, userName, 0, 1);
    }

    public UserObjectsOwnedList(AS400 system, String userName, int selectionFileSystem, int selectionObjectRelation) {
        this.setSystem(system);
        this.setUserName(userName);
        this.setSelectionFileSystem(selectionFileSystem);
        this.setSelectionObjectRelation(selectionObjectRelation);
        if (Trace.traceOn_) {
            Trace.log(1, this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserObjectsOwnedListEntry[] getObjectList() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int systemCCSID = this.system_.getCcsid();
        CharConverter conv = new CharConverter(systemCCSID);
        ProgramParameter[] parms = new ProgramParameter[7];
        parms[0] = new ProgramParameter(conv.stringToByteArray(USERSPACE_NAME));
        parms[1] = new ProgramParameter(conv.stringToByteArray(this.selectionFileSystem_));
        StringBuilder userNameBuff = new StringBuilder("          ");
        userNameBuff.replace(0, this.userName_.length(), this.userName_);
        parms[2] = new ProgramParameter(conv.stringToByteArray(userNameBuff.toString()));
        parms[3] = new ProgramParameter(conv.stringToByteArray(SELECTION_OBJECT_TYPE_ALL_PRIV));
        parms[4] = new ProgramParameter(conv.stringToByteArray(this.selectionObjectRelation_));
        parms[5] = new ProgramParameter(conv.stringToByteArray(CONTINUATION_HANDLE_BLANKS));
        parms[6] = errorCode_;
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QSYLOBJA.PGM", parms);
        pc.suggestThreadsafe();
        boolean willRunProgramsOnThread = pc.isStayOnThread();
        Object lockObject = willRunProgramsOnThread ? USERSPACE_PATH : this.system_;
        byte[] buf = null;
        Object object = lockObject;
        synchronized (object) {
            UserSpace space = new UserSpace(this.system_, USERSPACE_PATH);
            try {
                space.setMustUseProgramCall(true);
                if (!willRunProgramsOnThread) {
                    space.setMustUseSockets(true);
                }
                space.create(262144, true, "", (byte)0, "User space for UserObjectsOwnedList", "*EXCLUDE");
                if (!pc.run()) {
                    throw new AS400Exception(pc.getMessageList());
                }
                int size = space.getLength();
                buf = new byte[size];
                space.read(buf, 0);
            }
            finally {
                try {
                    space.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
            }
        }
        int headerOffset = BinaryConverter.byteArrayToInt(buf, 116);
        int startingOffset = BinaryConverter.byteArrayToInt(buf, 124);
        int numEntries = BinaryConverter.byteArrayToInt(buf, 132);
        int entrySize = BinaryConverter.byteArrayToInt(buf, 136);
        int entryCCSID = BinaryConverter.byteArrayToInt(buf, 140);
        String informationStatus = conv.byteArrayToString(buf, 103, 1);
        if (entryCCSID == 0) {
            entryCCSID = systemCCSID;
        }
        conv = new CharConverter(entryCCSID);
        String continuationHandle = conv.byteArrayToString(buf, headerOffset + 10, 20).trim();
        int reasonCode = BinaryConverter.byteArrayToInt(buf, headerOffset + 30);
        if (Trace.traceOn_) {
            Trace.log(1, "UserObjectsOwnedList.getObjectList()  informationStatus='" + informationStatus + "' reasonCode='" + reasonCode + "' continuationHandle='" + continuationHandle + "' numEntries='" + numEntries + "'");
        }
        UserObjectsOwnedListEntry[] entries = new UserObjectsOwnedListEntry[numEntries];
        int offset = startingOffset;
        for (int i = 0; i < numEntries; ++i) {
            String aspDeviceNameOfObject;
            String objectReference;
            String objectAlter;
            String dataExecute;
            String textDescription;
            String attribute;
            String dataDelete;
            String dataUpdate;
            String dataAdd;
            String dataRead;
            String objectExistence;
            String objectManagement;
            String objectOperational;
            String authorityListManagement;
            String authorityValue;
            String ownership;
            String authorityHolder;
            String objectType;
            if (this.selectionFileSystem_.equals(SELECTION_FILE_SYSTEM_LIBRARY_0300)) {
                offset = startingOffset + i * entrySize;
                String objectName = conv.byteArrayToString(buf, offset, 10).trim();
                String libraryName = conv.byteArrayToString(buf, offset += 10, 10).trim();
                objectType = conv.byteArrayToString(buf, offset += 10, 10).trim();
                authorityHolder = conv.byteArrayToString(buf, offset += 10, 1).trim();
                ownership = conv.byteArrayToString(buf, ++offset, 1).trim();
                authorityValue = conv.byteArrayToString(buf, ++offset, 10).trim();
                authorityListManagement = conv.byteArrayToString(buf, offset += 10, 1).trim();
                objectOperational = conv.byteArrayToString(buf, ++offset, 1).trim();
                objectManagement = conv.byteArrayToString(buf, ++offset, 1).trim();
                objectExistence = conv.byteArrayToString(buf, ++offset, 1).trim();
                dataRead = conv.byteArrayToString(buf, ++offset, 1).trim();
                dataAdd = conv.byteArrayToString(buf, ++offset, 1).trim();
                dataUpdate = conv.byteArrayToString(buf, ++offset, 1).trim();
                dataDelete = conv.byteArrayToString(buf, ++offset, 1).trim();
                attribute = conv.byteArrayToString(buf, ++offset, 10).trim();
                textDescription = conv.byteArrayToString(buf, offset += 10, 50).trim();
                dataExecute = conv.byteArrayToString(buf, offset += 50, 1).trim();
                ++offset;
                objectAlter = conv.byteArrayToString(buf, offset += 10, 1).trim();
                objectReference = conv.byteArrayToString(buf, ++offset, 1).trim();
                String aspDeviceNameOfLibrary = conv.byteArrayToString(buf, ++offset, 10).trim();
                aspDeviceNameOfObject = conv.byteArrayToString(buf, offset += 10, 10).trim();
                offset += 10;
                entries[i] = new UserObjectsOwnedListEntry(objectName, libraryName, objectType, authorityHolder, ownership, authorityValue, authorityListManagement, objectOperational, objectManagement, objectExistence, dataRead, dataAdd, dataUpdate, dataDelete, attribute, textDescription, dataExecute, objectAlter, objectReference, aspDeviceNameOfLibrary, aspDeviceNameOfObject);
                continue;
            }
            int offsetToPathName = BinaryConverter.byteArrayToInt(buf, offset);
            int lengthPathName = BinaryConverter.byteArrayToInt(buf, offset += 4);
            objectType = conv.byteArrayToString(buf, offset += 4, 10).trim();
            authorityHolder = conv.byteArrayToString(buf, offset += 10, 1).trim();
            ownership = conv.byteArrayToString(buf, ++offset, 1).trim();
            authorityValue = conv.byteArrayToString(buf, ++offset, 10).trim();
            authorityListManagement = conv.byteArrayToString(buf, offset += 10, 1).trim();
            objectOperational = conv.byteArrayToString(buf, ++offset, 1).trim();
            objectManagement = conv.byteArrayToString(buf, ++offset, 1).trim();
            objectExistence = conv.byteArrayToString(buf, ++offset, 1).trim();
            objectAlter = conv.byteArrayToString(buf, ++offset, 1).trim();
            objectReference = conv.byteArrayToString(buf, ++offset, 1).trim();
            ++offset;
            dataRead = conv.byteArrayToString(buf, offset += 10, 1).trim();
            dataAdd = conv.byteArrayToString(buf, ++offset, 1).trim();
            dataUpdate = conv.byteArrayToString(buf, ++offset, 1).trim();
            dataDelete = conv.byteArrayToString(buf, ++offset, 1).trim();
            dataExecute = conv.byteArrayToString(buf, ++offset, 1).trim();
            ++offset;
            attribute = conv.byteArrayToString(buf, offset += 10, 10).trim();
            textDescription = conv.byteArrayToString(buf, offset += 10, 50).trim();
            aspDeviceNameOfObject = conv.byteArrayToString(buf, offset += 50, 10).trim();
            offset += 10;
            int pathCCSID = BinaryConverter.byteArrayToInt(buf, offsetToPathName + 0);
            CharConverter pathConv = new CharConverter(pathCCSID);
            String pathName = pathConv.byteArrayToString(buf, offsetToPathName + 32, lengthPathName - 32).trim();
            offset += 10;
            offset = offsetToPathName + lengthPathName;
            entries[i] = new UserObjectsOwnedListEntry(objectType, authorityHolder, ownership, authorityValue, authorityListManagement, objectOperational, objectManagement, objectExistence, dataRead, dataAdd, dataUpdate, dataDelete, attribute, textDescription, dataExecute, objectAlter, objectReference, aspDeviceNameOfObject, pathName);
        }
        return entries;
    }

    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public void setUserName(String userName) {
        if (userName == null) {
            throw new NullPointerException("userName");
        }
        this.userName_ = userName;
    }

    public String getUserName() {
        return this.userName_;
    }

    public void setSelectionFileSystem(int selectionFileSystem) {
        switch (selectionFileSystem) {
            case 0: {
                this.selectionFileSystem_ = SELECTION_FILE_SYSTEM_LIBRARY_0300;
                break;
            }
            case 1: {
                this.selectionFileSystem_ = SELECTION_FILE_SYSTEM_DIRECTORY_0310;
                break;
            }
            default: {
                Trace.log(2, "UserObjectsOwnedList.setSelectionFileSystem() PARAMETER_VALUE_NOT_VALID");
                throw new ExtendedIllegalArgumentException("selectionFileSystem", 2);
            }
        }
    }

    public int getSelectionFileSystem() {
        if (this.selectionFileSystem_.equals(SELECTION_FILE_SYSTEM_LIBRARY_0300)) {
            return 0;
        }
        return 1;
    }

    public void setSelectionObjectRelation(int selectionObjectRelation) {
        switch (selectionObjectRelation) {
            case 0: {
                this.selectionObjectRelation_ = SELECTION_OBJECT_RELATION_AUTHORIZED_PRIV;
                break;
            }
            case 1: {
                this.selectionObjectRelation_ = SELECTION_OBJECT_RELATION_OWNED_PRIV;
                break;
            }
            case 2: {
                this.selectionObjectRelation_ = SELECTION_OBJECT_RELATION_OWNED_OR_AUTHORIZED_PRIV;
                break;
            }
            default: {
                Trace.log(2, "UserObjectsOwnedList.setSelectionObjectRelation() PARAMETER_VALUE_NOT_VALID");
                throw new ExtendedIllegalArgumentException("selectionObjectRelation", 2);
            }
        }
    }

    public int getSelectionObjectRelation() {
        if (this.selectionObjectRelation_.equals(SELECTION_OBJECT_RELATION_AUTHORIZED_PRIV)) {
            return 0;
        }
        if (this.selectionObjectRelation_.equals(SELECTION_OBJECT_RELATION_OWNED_PRIV)) {
            return 1;
        }
        return 2;
    }

    public String toString() {
        String returnString = "UserObjectsOwnedList (getSystem()=" + this.getSystem() + " getUserName()=" + this.getUserName() + " getSelectionFileSystem()=" + this.getSelectionFileSystem() + " getSelectionObjectRelation()=" + this.getSelectionObjectRelation() + ")";
        return returnString;
    }
}

