/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDOutQ;
import com.ibm.as400.access.OutputQueueEvent;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.OutputQueueListener;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class OutputQueue
extends PrintObject
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PATH = "path";
    private transient Vector outputQueueListeners_ = new Vector();

    OutputQueue(AS400 system, NPCPIDOutQ id, NPCPAttribute attrs) {
        super(system, id, attrs, 4);
    }

    public OutputQueue() {
        super(null, null, 4);
    }

    public OutputQueue(AS400 system, String queueName) {
        super(system, OutputQueue.buildIDCodePoint(queueName), null, 4);
    }

    public void addOutputQueueListener(OutputQueueListener listener) {
        this.outputQueueListeners_.addElement(listener);
    }

    private static NPCPIDOutQ buildIDCodePoint(String IFSQueueName) {
        QSYSObjectPathName ifsPath = new QSYSObjectPathName(IFSQueueName, "OUTQ");
        return new NPCPIDOutQ(ifsPath.getObjectName(), ifsPath.getLibraryName());
    }

    @Override
    void checkRunTimeState() {
        super.checkRunTimeState();
        if (this.getIDCodePoint() == null) {
            Trace.log(2, "Parameter 'path' has not been set.");
            throw new ExtendedIllegalStateException(PATH, 4);
        }
    }

    @Override
    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 system = this.getSystem();
        if (system == null) {
            Trace.log(2, "Attempt to use OutputQueue before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (OutputQueueImpl)system.loadImpl2("com.ibm.as400.access.OutputQueueImplRemote", "com.ibm.as400.access.OutputQueueImplProxy");
        super.setImpl();
    }

    public void clear(PrintParameterList clearOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.checkRunTimeState();
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((OutputQueueImpl)this.impl_).clear(clearOptions);
        this.attrs = this.impl_.getAttrValue();
        this.fireOutputQueueEvent(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOutputQueueEvent(int id) {
        Vector l;
        if (this.outputQueueListeners_.isEmpty()) {
            return;
        }
        OutputQueueEvent event = new OutputQueueEvent(this, id);
        OutputQueue outputQueue = this;
        synchronized (outputQueue) {
            l = (Vector)this.outputQueueListeners_.clone();
        }
        block8: for (int i = 0; i < l.size(); ++i) {
            switch (id) {
                case 1: {
                    ((OutputQueueListener)l.elementAt(i)).outputQueueCleared(event);
                    continue block8;
                }
                case 2: {
                    ((OutputQueueListener)l.elementAt(i)).outputQueueHeld(event);
                    continue block8;
                }
                case 3: {
                    ((OutputQueueListener)l.elementAt(i)).outputQueueReleased(event);
                }
            }
        }
    }

    public String getName() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return IDCodePoint.getStringValue(74);
    }

    public String getPath() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return QSYSObjectPathName.toPath(IDCodePoint.getStringValue(73), IDCodePoint.getStringValue(74), "OUTQ");
    }

    public void hold() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.checkRunTimeState();
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((OutputQueueImpl)this.impl_).hold();
        this.attrs = this.impl_.getAttrValue();
        this.fireOutputQueueEvent(2);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.outputQueueListeners_ = new Vector();
    }

    public void release() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.checkRunTimeState();
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((OutputQueueImpl)this.impl_).release();
        this.attrs = this.impl_.getAttrValue();
        this.fireOutputQueueEvent(3);
    }

    public void removeOutputQueueListener(OutputQueueListener listener) {
        this.outputQueueListeners_.removeElement(listener);
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null");
            throw new NullPointerException(PATH);
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'Path' after connect.");
            throw new ExtendedIllegalStateException(PATH, 5);
        }
        String oldPath = this.getPath();
        this.vetos.fireVetoableChange(PATH, oldPath, path);
        this.setIDCodePoint(OutputQueue.buildIDCodePoint(path));
        this.changes.firePropertyChange(PATH, oldPath, path);
    }
}

