/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class LineDataRecordWriter {
    private OutputStream outPut;
    private Converter cvt;
    private ByteArrayOutputStream buffer;

    public LineDataRecordWriter(OutputStream out, AS400 system) throws UnsupportedEncodingException {
        this.outPut = out;
        this.cvt = new Converter(system.getCcsid(), system);
        this.buffer = new ByteArrayOutputStream();
    }

    public LineDataRecordWriter(OutputStream out, int ccsid, AS400 system) throws UnsupportedEncodingException {
        this.outPut = out;
        this.cvt = new Converter(ccsid, system);
        this.buffer = new ByteArrayOutputStream();
    }

    private void addToBuffer(byte[] data) throws IOException {
        if (this.outPut == null) {
            throw new IOException("Stream closed");
        }
        int len = data.length;
        this.buffer.write(data, 0, len);
    }

    public int getCcsid() {
        if (this.cvt == null) {
            return 0;
        }
        return this.cvt.getCcsid();
    }

    public String getEncoding() {
        if (this.cvt == null) {
            return null;
        }
        return this.cvt.getEncoding();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retrieveRecord(Record record) throws IOException, UnsupportedEncodingException, ExtendedIllegalStateException {
        RecordFormat recfmt = record.getRecordFormat();
        String recfmtid = recfmt.getRecordFormatID();
        int recfmttype = recfmt.getRecordFormatType();
        Object[] fields = record.getFields();
        char delimiter = recfmt.getDelimiter();
        if ("".equals(recfmtid)) {
            throw new ExtendedIllegalStateException("recordFormatID", 4);
        }
        if (recfmttype == 0) {
            throw new ExtendedIllegalStateException("recordFormatType for record format " + recfmtid, 4);
        }
        byte[] conBytes1 = this.cvt.stringToByteArray(recfmtid);
        this.addToBuffer(conBytes1);
        for (int i = 0; i < fields.length; ++i) {
            String str;
            FieldDescription fd = recfmt.getFieldDescription(i);
            String fvalue = fields[i].toString();
            int strlen = fvalue.length();
            if (recfmttype == 1) {
                int fldalign = fd.getLayoutAlignment();
                int fldlayoutl = fd.getLayoutLength();
                if (fldalign == 0) {
                    fldalign = 1;
                }
                if (fldlayoutl < strlen) throw new ExtendedIllegalArgumentException("Field description " + fd.getFieldName(), 1);
                int padlen = fldlayoutl - strlen;
                String padstring = this.pad(padlen);
                str = fldalign == 2 ? padstring + fvalue : fvalue + padstring;
            } else {
                if (delimiter == '\u0000') {
                    throw new ExtendedIllegalStateException("delimiter for record format " + recfmtid, 4);
                }
                str = fvalue + delimiter;
            }
            byte[] conBytes = this.cvt.stringToByteArray(str);
            this.addToBuffer(conBytes);
        }
    }

    public void writeRecord(Record record) throws IOException, UnsupportedEncodingException, ExtendedIllegalStateException {
        this.buffer.reset();
        this.retrieveRecord(record);
        if (this.buffer.size() > 0) {
            if (this.outPut == null) {
                throw new IOException("Stream closed");
            }
            this.buffer.writeTo(this.outPut);
            this.outPut.flush();
            this.buffer.reset();
        }
    }

    private String pad(int slen) {
        StringBuilder buf = new StringBuilder(slen);
        for (int i = 0; i < slen; ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }
}

