/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DBStorage;
import com.ibm.as400.access.JDTrace;
import java.lang.ref.SoftReference;

class DBStoragePool {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final int MAX_POOL_INCREMENT = 4096;
    private static final int STORAGE_POOL_LOCALITY = 256;
    private SoftReference[] pool_ = new SoftReference[16];
    private int lastReturned_;
    private int searches_ = 0;

    DBStoragePool() {
    }

    int getSize() {
        return this.pool_.length;
    }

    final synchronized DBStorage getUnpooledStorage() {
        DBStorage storage = new DBStorage(-1, this);
        storage.canUse();
        return storage;
    }

    final synchronized DBStorage getUnusedStorage() {
        int max = this.pool_.length;
        int searchStart = this.lastReturned_;
        ++this.searches_;
        if (this.searches_ > 4096) {
            searchStart = 0;
            this.searches_ = 0;
        }
        for (int i = searchStart; i < max; ++i) {
            DBStorage storage = this.pool_[i] == null ? null : (DBStorage)this.pool_[i].get();
            if (storage == null) {
                storage = new DBStorage(i, this);
                storage.canUse();
                this.pool_[i] = new SoftReference<DBStorage>(storage);
                this.lastReturned_ = i + 1;
                return storage;
            }
            if (!storage.canUse()) continue;
            this.lastReturned_ = i + 1;
            return storage;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Creating new DBStoragePool of size " + max * 2);
        }
        int increment = max;
        if (max > 4096) {
            increment = 4096;
        }
        SoftReference[] tempPool = new SoftReference[max + increment];
        for (int i = 0; i < max; ++i) {
            tempPool[i] = this.pool_[i];
        }
        DBStorage storage = new DBStorage(max, this);
        storage.canUse();
        tempPool[max] = new SoftReference<DBStorage>(storage);
        this.pool_ = tempPool;
        this.lastReturned_ = 0;
        return storage;
    }

    public synchronized void returned(int id_) {
        if (id_ < this.lastReturned_ && id_ >= this.lastReturned_ - 256) {
            this.lastReturned_ = id_;
        }
    }
}

