/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDAFPResource;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectImpl;
import com.ibm.as400.access.PrintObjectInputStream;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class AFPResource
extends PrintObject
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final String STR_FNTRSC = "FNTRSC";
    public static final String STR_FORMDF = "FORMDF";
    public static final String STR_OVL = "OVL";
    public static final String STR_PAGDFN = "PAGDFN";
    public static final String STR_PAGSEG = "PAGSEG";
    private static final String PATH = "path";

    AFPResource(AS400 system, NPCPIDAFPResource id, NPCPAttribute attrs) {
        super(system, id, attrs, 7);
    }

    public AFPResource() {
        super(null, null, 7);
    }

    public AFPResource(AS400 system, String resourceName) {
        super(system, AFPResource.buildIDCodePoint(resourceName), null, 7);
    }

    private static NPCPIDAFPResource buildIDCodePoint(String IFSResourceName) {
        QSYSObjectPathName ifsPath = new QSYSObjectPathName(IFSResourceName);
        return new NPCPIDAFPResource(ifsPath.getObjectName(), ifsPath.getLibraryName(), ifsPath.getObjectType());
    }

    @Override
    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 system = this.getSystem();
        if (system == null) {
            Trace.log(2, "Attempt to use AFPResource before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectImpl)system.loadImpl2("com.ibm.as400.access.AFPResourceImplRemote", "com.ibm.as400.access.AFPResourceImplProxy");
        super.setImpl();
    }

    public PrintObjectInputStream getInputStream() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectInputStream is = new PrintObjectInputStream(this, null);
        return is;
    }

    public String getName() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return IDCodePoint.getStringValue(175);
    }

    public String getPath() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return QSYSObjectPathName.toPath(IDCodePoint.getStringValue(174), IDCodePoint.getStringValue(175), ((NPCPIDAFPResource)IDCodePoint).getResourceType());
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            Trace.log(2, "Parameter 'path' is null");
            throw new NullPointerException(PATH);
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException(PATH, 5);
        }
        String oldPath = this.getPath();
        this.vetos.fireVetoableChange(PATH, oldPath, path);
        this.setIDCodePoint(AFPResource.buildIDCodePoint(path));
        this.changes.firePropertyChange(PATH, oldPath, path);
    }
}

