/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.snappy.SnappyCompressorOutputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.beam.sdk.util.LzoCompression;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Ints;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public enum Compression {
    AUTO("", new String[0]){

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) {
            throw new UnsupportedOperationException("Must resolve compression into a concrete value before calling readDecompressed()");
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) {
            throw new UnsupportedOperationException("AUTO is applicable only to reading files");
        }
    }
    ,
    UNCOMPRESSED("", new String[0]){

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) {
            return channel;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) {
            return channel;
        }
    }
    ,
    GZIP(".gz", new String[]{".gz"}){

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            byte zero;
            int header;
            PushbackInputStream stream = new PushbackInputStream(Channels.newInputStream(channel), 2);
            byte[] headerBytes = new byte[2];
            int bytesRead = ByteStreams.read((InputStream)stream, (byte[])headerBytes, (int)0, (int)2);
            stream.unread(headerBytes, 0, bytesRead);
            if (bytesRead >= 2 && (header = Ints.fromBytes((byte)(zero = 0), (byte)zero, (byte)headerBytes[1], (byte)headerBytes[0])) == 35615) {
                return Channels.newChannel(new GzipCompressorInputStream(stream, true));
            }
            return Channels.newChannel(stream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(new GZIPOutputStream(Channels.newOutputStream(channel), 4096, true));
        }
    }
    ,
    BZIP2(".bz2", new String[]{".bz2"}){

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(new BZip2CompressorInputStream(Channels.newInputStream(channel), true));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(new BZip2CompressorOutputStream(Channels.newOutputStream(channel)));
        }
    }
    ,
    ZIP(".zip", new String[]{".zip"}){

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            FullZipInputStream zip = new FullZipInputStream(Channels.newInputStream(channel));
            return Channels.newChannel(zip);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            throw new UnsupportedOperationException("Writing ZIP files is currently unsupported");
        }
    }
    ,
    ZSTD(".zst", new String[]{".zst", ".zstd"}){

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(new ZstdCompressorInputStream(Channels.newInputStream(channel)));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(new ZstdCompressorOutputStream(Channels.newOutputStream(channel)));
        }
    }
    ,
    LZO(".lzo_deflate", new String[]{".lzo_deflate"}){

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(LzoCompression.createLzoInputStream(Channels.newInputStream(channel)));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(LzoCompression.createLzoOutputStream(Channels.newOutputStream(channel)));
        }
    }
    ,
    LZOP(".lzo", new String[]{".lzo"}){

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(LzoCompression.createLzopInputStream(Channels.newInputStream(channel)));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(LzoCompression.createLzopOutputStream(Channels.newOutputStream(channel)));
        }
    }
    ,
    DEFLATE(".deflate", new String[]{".deflate", ".zlib"}){

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(new DeflateCompressorInputStream(Channels.newInputStream(channel)));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(new DeflateCompressorOutputStream(Channels.newOutputStream(channel)));
        }
    }
    ,
    SNAPPY(".snappy", new String[]{".snappy"}){
        private @UnknownKeyFor @NonNull @Initialized int uncompressedSize;

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            SnappyCompressorInputStream is = new SnappyCompressorInputStream(Channels.newInputStream(channel));
            this.uncompressedSize = is.getSize();
            return Channels.newChannel(is);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return Channels.newChannel(new SnappyCompressorOutputStream(Channels.newOutputStream(channel), this.uncompressedSize));
        }
    };

    private final @UnknownKeyFor @NonNull @Initialized String suggestedSuffix;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> detectedSuffixes;

    private Compression(String suggestedSuffix, String ... detectedSuffixes) {
        this.suggestedSuffix = suggestedSuffix;
        this.detectedSuffixes = ImmutableList.copyOf((Object[])detectedSuffixes);
    }

    public @UnknownKeyFor @NonNull @Initialized String getSuggestedSuffix() {
        return this.suggestedSuffix;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized String filename) {
        for (String suffix : this.detectedSuffixes) {
            if (!filename.toLowerCase().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCompressed(@UnknownKeyFor @NonNull @Initialized String filename) {
        Compression compression = this;
        if (compression == AUTO) {
            compression = Compression.detect(filename);
        }
        return compression != UNCOMPRESSED;
    }

    public static @UnknownKeyFor @NonNull @Initialized Compression detect(@UnknownKeyFor @NonNull @Initialized String filename) {
        for (Compression value : Compression.values()) {
            if (!value.matches(filename)) continue;
            return value;
        }
        return UNCOMPRESSED;
    }

    public abstract @UnknownKeyFor @NonNull @Initialized ReadableByteChannel readDecompressed(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract @UnknownKeyFor @NonNull @Initialized WritableByteChannel writeCompressed(@UnknownKeyFor @NonNull @Initialized WritableByteChannel var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    private static class FullZipInputStream
    extends InputStream {
        private @UnknownKeyFor @NonNull @Initialized ZipInputStream zipInputStream;
        private @UnknownKeyFor @NonNull @Initialized ZipEntry currentEntry;

        public FullZipInputStream(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.zipInputStream = new ZipInputStream(is);
            this.currentEntry = this.zipInputStream.getNextEntry();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
            int result = this.zipInputStream.read();
            while (result == -1) {
                this.currentEntry = this.zipInputStream.getNextEntry();
                if (this.currentEntry == null) {
                    return -1;
                }
                result = this.zipInputStream.read();
            }
            return result;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int result = this.zipInputStream.read(b, off, len);
            while (result == -1) {
                this.currentEntry = this.zipInputStream.getNextEntry();
                if (this.currentEntry == null) {
                    return -1;
                }
                result = this.zipInputStream.read(b, off, len);
            }
            return result;
        }
    }
}

