/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.shared;

import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.CheckBoxVar;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NeoConnectionEditor
extends MetadataEditor<NeoConnection> {
    private static final Class<?> PKG = NeoConnectionEditor.class;
    private CTabFolder wTabFolder;
    private Text wName;
    private Label wlAutomatic;
    private CheckBoxVar wAutomatic;
    private TextVar wProtocol;
    private Label wlServer;
    private TextVar wServer;
    private Label wlDatabaseName;
    private TextVar wDatabaseName;
    private Label wlDatabasePort;
    private TextVar wDatabasePort;
    private TextVar wUsername;
    private TextVar wPassword;
    private TextVar wBrowserPort;
    private Label wlPolicy;
    private TextVar wPolicy;
    private Label wlRouting;
    private CheckBoxVar wRouting;
    private Label wlEncryption;
    private CheckBoxVar wEncryption;
    private Label wlTrustAllCertificates;
    private CheckBoxVar wTrustAllCertificates;
    private TextVar wConnectionLivenessCheckTimeout;
    private TextVar wMaxConnectionLifetime;
    private TextVar wMaxConnectionPoolSize;
    private TextVar wConnectionAcquisitionTimeout;
    private TextVar wConnectionTimeout;
    private TextVar wMaxTransactionRetryTime;
    private TableView wUrls;

    public NeoConnectionEditor(HopGui hopGui, MetadataManager<NeoConnection> manager, NeoConnection neoConnection) {
        super(hopGui, manager, (IHopMetadata)neoConnection);
    }

    public void createControl(Composite composite) {
        Control[] controls;
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = PropsUi.getMargin() + 2;
        IVariables variables = this.getHopGui().getVariables();
        Label wlName = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(composite, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wTabFolder = new CTabFolder(composite, 2048);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, 2 * margin);
        fdTabFolder.bottom = new FormAttachment(100, -2 * margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.addBasicTab(props, variables, middle, margin);
        this.addProtocolTab(props, variables, middle, margin);
        this.addAdvancedTab(props, variables, middle, margin);
        this.addUrlsTab(props, variables);
        this.wTabFolder.setSelection(0);
        this.setWidgetsContent();
        this.enableFields();
        this.clearChanged();
        for (Control control : controls = new Control[]{this.wName, this.wAutomatic, this.wServer, this.wDatabaseName, this.wDatabasePort, this.wBrowserPort, this.wPolicy, this.wUsername, this.wPassword, this.wRouting, this.wEncryption, this.wTrustAllCertificates, this.wConnectionLivenessCheckTimeout, this.wMaxConnectionLifetime, this.wMaxConnectionPoolSize, this.wConnectionAcquisitionTimeout, this.wConnectionTimeout, this.wMaxTransactionRetryTime, this.wProtocol}) {
            control.addListener(24, e -> this.setChanged());
            control.addListener(13, e -> this.setChanged());
        }
    }

    private void addBasicTab(PropsUi props, IVariables variables, int middle, int margin) {
        CTabItem wModelTab = new CTabItem(this.wTabFolder, 0);
        wModelTab.setFont(GuiResource.getInstance().getFontDefault());
        wModelTab.setText("Basic   ");
        ScrolledComposite wBasicSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        wBasicSComp.setLayout((Layout)new FillLayout());
        Composite wBasicComp = new Composite((Composite)wBasicSComp, 0);
        PropsUi.setLook((Widget)wBasicComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 3;
        formLayout.marginHeight = 3;
        wBasicComp.setLayout((Layout)formLayout);
        this.wlAutomatic = new Label(wBasicComp, 131072);
        this.wlAutomatic.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Automatic.Label", (String[])new String[0]));
        this.wlAutomatic.setToolTipText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Automatic.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAutomatic);
        FormData fdlAutomatic = new FormData();
        fdlAutomatic.top = new FormAttachment(0, margin);
        fdlAutomatic.left = new FormAttachment(0, 0);
        fdlAutomatic.right = new FormAttachment(middle, -margin);
        this.wlAutomatic.setLayoutData((Object)fdlAutomatic);
        this.wAutomatic = new CheckBoxVar(variables, wBasicComp, 32);
        this.wAutomatic.setToolTipText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Automatic.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAutomatic);
        FormData fdAutomatic = new FormData();
        fdAutomatic.top = new FormAttachment((Control)this.wlAutomatic, 0, 0x1000000);
        fdAutomatic.left = new FormAttachment(middle, 0);
        fdAutomatic.right = new FormAttachment(95, 0);
        this.wAutomatic.setLayoutData((Object)fdAutomatic);
        this.wAutomatic.addListener(13, e -> this.enableFields());
        CheckBoxVar lastControl = this.wAutomatic;
        Label wlProtocol = new Label(wBasicComp, 131072);
        wlProtocol.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Protocol.Label", (String[])new String[0]));
        wlProtocol.setToolTipText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Protocol.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProtocol);
        FormData fdlProtocol = new FormData();
        fdlProtocol.top = new FormAttachment((Control)lastControl, margin);
        fdlProtocol.left = new FormAttachment(0, 0);
        fdlProtocol.right = new FormAttachment(middle, -margin);
        wlProtocol.setLayoutData((Object)fdlProtocol);
        this.wProtocol = new TextVar(variables, wBasicComp, 18436);
        this.wProtocol.setToolTipText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Protocol.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wProtocol);
        FormData fdProtocol = new FormData();
        fdProtocol.top = new FormAttachment((Control)wlProtocol, 0, 0x1000000);
        fdProtocol.left = new FormAttachment(middle, 0);
        fdProtocol.right = new FormAttachment(95, 0);
        this.wProtocol.setLayoutData((Object)fdProtocol);
        lastControl = this.wProtocol;
        this.wlServer = new Label(wBasicComp, 131072);
        PropsUi.setLook((Widget)this.wlServer);
        this.wlServer.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Server.Label", (String[])new String[0]));
        FormData fdlServer = new FormData();
        fdlServer.top = new FormAttachment((Control)lastControl, margin);
        fdlServer.left = new FormAttachment(0, 0);
        fdlServer.right = new FormAttachment(middle, -margin);
        this.wlServer.setLayoutData((Object)fdlServer);
        this.wServer = new TextVar(variables, wBasicComp, 18436);
        PropsUi.setLook((Widget)this.wServer);
        FormData fdServer = new FormData();
        fdServer.top = new FormAttachment((Control)this.wlServer, 0, 0x1000000);
        fdServer.left = new FormAttachment(middle, 0);
        fdServer.right = new FormAttachment(95, 0);
        this.wServer.setLayoutData((Object)fdServer);
        lastControl = this.wServer;
        this.wlDatabaseName = new Label(wBasicComp, 131072);
        PropsUi.setLook((Widget)this.wlDatabaseName);
        this.wlDatabaseName.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.DatabaseName.Label", (String[])new String[0]));
        FormData fdlDatabaseName = new FormData();
        fdlDatabaseName.top = new FormAttachment((Control)lastControl, margin);
        fdlDatabaseName.left = new FormAttachment(0, 0);
        fdlDatabaseName.right = new FormAttachment(middle, -margin);
        this.wlDatabaseName.setLayoutData((Object)fdlDatabaseName);
        this.wDatabaseName = new TextVar(variables, wBasicComp, 18436);
        PropsUi.setLook((Widget)this.wDatabaseName);
        FormData fdDatabaseName = new FormData();
        fdDatabaseName.top = new FormAttachment((Control)this.wlDatabaseName, 0, 0x1000000);
        fdDatabaseName.left = new FormAttachment(middle, 0);
        fdDatabaseName.right = new FormAttachment(95, 0);
        this.wDatabaseName.setLayoutData((Object)fdDatabaseName);
        lastControl = this.wDatabaseName;
        this.wlDatabasePort = new Label(wBasicComp, 131072);
        PropsUi.setLook((Widget)this.wlDatabasePort);
        this.wlDatabasePort.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.DatabasePort.Label", (String[])new String[0]));
        FormData fdlDatabasePort = new FormData();
        fdlDatabasePort.top = new FormAttachment((Control)lastControl, margin);
        fdlDatabasePort.left = new FormAttachment(0, 0);
        fdlDatabasePort.right = new FormAttachment(middle, -margin);
        this.wlDatabasePort.setLayoutData((Object)fdlDatabasePort);
        this.wDatabasePort = new TextVar(variables, wBasicComp, 18436);
        PropsUi.setLook((Widget)this.wDatabasePort);
        FormData fdDatabasePort = new FormData();
        fdDatabasePort.top = new FormAttachment((Control)this.wlDatabasePort, 0, 0x1000000);
        fdDatabasePort.left = new FormAttachment(middle, 0);
        fdDatabasePort.right = new FormAttachment(95, 0);
        this.wDatabasePort.setLayoutData((Object)fdDatabasePort);
        lastControl = this.wDatabasePort;
        Label wlUsername = new Label(wBasicComp, 131072);
        wlUsername.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.UserName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUsername);
        FormData fdlUsername = new FormData();
        fdlUsername.top = new FormAttachment((Control)lastControl, margin);
        fdlUsername.left = new FormAttachment(0, 0);
        fdlUsername.right = new FormAttachment(middle, -margin);
        wlUsername.setLayoutData((Object)fdlUsername);
        this.wUsername = new TextVar(variables, wBasicComp, 18436);
        PropsUi.setLook((Widget)this.wUsername);
        FormData fdUsername = new FormData();
        fdUsername.top = new FormAttachment((Control)wlUsername, 0, 0x1000000);
        fdUsername.left = new FormAttachment(middle, 0);
        fdUsername.right = new FormAttachment(95, 0);
        this.wUsername.setLayoutData((Object)fdUsername);
        lastControl = this.wUsername;
        Label wlPassword = new Label(wBasicComp, 131072);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Password.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.top = new FormAttachment((Control)lastControl, margin);
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.right = new FormAttachment(middle, -margin);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(variables, wBasicComp, 18436);
        PropsUi.setLook((Widget)this.wPassword);
        FormData fdPassword = new FormData();
        fdPassword.top = new FormAttachment((Control)wlPassword, 0, 0x1000000);
        fdPassword.left = new FormAttachment(middle, 0);
        fdPassword.right = new FormAttachment(95, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        wBasicComp.pack();
        Rectangle bounds = wBasicComp.getBounds();
        wBasicSComp.setContent((Control)wBasicComp);
        wBasicSComp.setExpandHorizontal(true);
        wBasicSComp.setExpandVertical(true);
        wBasicSComp.setMinWidth(bounds.width);
        wBasicSComp.setMinHeight(bounds.height);
        wModelTab.setControl((Control)wBasicSComp);
    }

    private void addProtocolTab(PropsUi props, IVariables variables, int middle, int margin) {
        CTabItem wProtocolTab = new CTabItem(this.wTabFolder, 0);
        wProtocolTab.setFont(GuiResource.getInstance().getFontDefault());
        wProtocolTab.setText("Protocol   ");
        ScrolledComposite wProtocolSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        wProtocolSComp.setLayout((Layout)new FillLayout());
        Composite wProtocolComp = new Composite((Composite)wProtocolSComp, 0);
        PropsUi.setLook((Widget)wProtocolComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 3;
        formLayout.marginHeight = 3;
        wProtocolComp.setLayout((Layout)formLayout);
        TextVar lastControl = null;
        Label wlBrowserPort = new Label(wProtocolComp, 131072);
        PropsUi.setLook((Widget)wlBrowserPort);
        wlBrowserPort.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.BrowserPort.Label", (String[])new String[0]));
        FormData fdlBrowserPort = new FormData();
        fdlBrowserPort.top = new FormAttachment(lastControl, margin);
        fdlBrowserPort.left = new FormAttachment(0, 0);
        fdlBrowserPort.right = new FormAttachment(middle, -margin);
        wlBrowserPort.setLayoutData((Object)fdlBrowserPort);
        this.wBrowserPort = new TextVar(variables, wProtocolComp, 18436);
        PropsUi.setLook((Widget)this.wBrowserPort);
        FormData fdBrowserPort = new FormData();
        fdBrowserPort.top = new FormAttachment((Control)wlBrowserPort, 0, 0x1000000);
        fdBrowserPort.left = new FormAttachment(middle, 0);
        fdBrowserPort.right = new FormAttachment(95, 0);
        this.wBrowserPort.setLayoutData((Object)fdBrowserPort);
        lastControl = this.wBrowserPort;
        this.wlRouting = new Label(wProtocolComp, 131072);
        this.wlRouting.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Routing.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlRouting);
        FormData fdlRouting = new FormData();
        fdlRouting.top = new FormAttachment((Control)lastControl, margin);
        fdlRouting.left = new FormAttachment(0, 0);
        fdlRouting.right = new FormAttachment(middle, -margin);
        this.wlRouting.setLayoutData((Object)fdlRouting);
        this.wRouting = new CheckBoxVar(variables, wProtocolComp, 32);
        PropsUi.setLook((Widget)this.wRouting);
        FormData fdRouting = new FormData();
        fdRouting.top = new FormAttachment((Control)this.wlRouting, 0, 0x1000000);
        fdRouting.left = new FormAttachment(middle, 0);
        fdRouting.right = new FormAttachment(95, 0);
        this.wRouting.setLayoutData((Object)fdRouting);
        this.wRouting.addListener(13, e -> this.enableFields());
        lastControl = this.wRouting;
        this.wlPolicy = new Label(wProtocolComp, 131072);
        this.wlPolicy.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Policy.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPolicy);
        FormData fdlPolicy = new FormData();
        fdlPolicy.top = new FormAttachment((Control)lastControl, margin);
        fdlPolicy.left = new FormAttachment(0, 0);
        fdlPolicy.right = new FormAttachment(middle, -margin);
        this.wlPolicy.setLayoutData((Object)fdlPolicy);
        this.wPolicy = new TextVar(variables, wProtocolComp, 18436);
        PropsUi.setLook((Widget)this.wPolicy);
        FormData fdPolicy = new FormData();
        fdPolicy.top = new FormAttachment((Control)this.wlPolicy, 0, 0x1000000);
        fdPolicy.left = new FormAttachment(middle, 0);
        fdPolicy.right = new FormAttachment(95, 0);
        this.wPolicy.setLayoutData((Object)fdPolicy);
        lastControl = this.wPolicy;
        this.wlEncryption = new Label(wProtocolComp, 131072);
        this.wlEncryption.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Encryption.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlEncryption);
        FormData fdlEncryption = new FormData();
        fdlEncryption.top = new FormAttachment((Control)lastControl, margin);
        fdlEncryption.left = new FormAttachment(0, 0);
        fdlEncryption.right = new FormAttachment(middle, -margin);
        this.wlEncryption.setLayoutData((Object)fdlEncryption);
        this.wEncryption = new CheckBoxVar(variables, wProtocolComp, 32);
        PropsUi.setLook((Widget)this.wEncryption);
        FormData fdEncryption = new FormData();
        fdEncryption.top = new FormAttachment((Control)this.wlEncryption, 0, 0x1000000);
        fdEncryption.left = new FormAttachment(middle, 0);
        fdEncryption.right = new FormAttachment(95, 0);
        this.wEncryption.setLayoutData((Object)fdEncryption);
        this.wEncryption.addListener(13, e -> this.enableFields());
        lastControl = this.wEncryption;
        this.wlTrustAllCertificates = new Label(wProtocolComp, 131072);
        this.wlTrustAllCertificates.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.TrustAllCertificates.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTrustAllCertificates);
        FormData fdlTrustAllCertificates = new FormData();
        fdlTrustAllCertificates.top = new FormAttachment((Control)lastControl, margin);
        fdlTrustAllCertificates.left = new FormAttachment(0, 0);
        fdlTrustAllCertificates.right = new FormAttachment(middle, -margin);
        this.wlTrustAllCertificates.setLayoutData((Object)fdlTrustAllCertificates);
        this.wTrustAllCertificates = new CheckBoxVar(variables, wProtocolComp, 32);
        PropsUi.setLook((Widget)this.wEncryption);
        FormData fdTrustAllCertificates = new FormData();
        fdTrustAllCertificates.top = new FormAttachment((Control)this.wlTrustAllCertificates, 0, 0x1000000);
        fdTrustAllCertificates.left = new FormAttachment(middle, 0);
        fdTrustAllCertificates.right = new FormAttachment(95, 0);
        this.wTrustAllCertificates.setLayoutData((Object)fdTrustAllCertificates);
        wProtocolComp.pack();
        Rectangle bounds = wProtocolComp.getBounds();
        wProtocolSComp.setContent((Control)wProtocolComp);
        wProtocolSComp.setExpandHorizontal(true);
        wProtocolSComp.setExpandVertical(true);
        wProtocolSComp.setMinWidth(bounds.width);
        wProtocolSComp.setMinHeight(bounds.height);
        wProtocolTab.setControl((Control)wProtocolSComp);
    }

    private void addUrlsTab(PropsUi props, IVariables variables) {
        CTabItem wUrlsTab = new CTabItem(this.wTabFolder, 0);
        wUrlsTab.setFont(GuiResource.getInstance().getFontDefault());
        wUrlsTab.setText("Manual URLs");
        ScrolledComposite wUrlsSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        wUrlsSComp.setLayout((Layout)new FillLayout());
        Composite wUrlsComp = new Composite((Composite)wUrlsSComp, 0);
        PropsUi.setLook((Widget)wUrlsComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 3;
        formLayout.marginHeight = 3;
        wUrlsComp.setLayout((Layout)formLayout);
        this.wUrls = new TableView(variables, wUrlsComp, 0, new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.URLColumn.Label", (String[])new String[0]), 1)}, ((NeoConnection)this.getMetadata()).getManualUrls().size(), e -> {
            this.setChanged();
            this.enableFields();
        }, props);
        FormData fdUrls = new FormData();
        fdUrls.top = new FormAttachment(0, 0);
        fdUrls.left = new FormAttachment(0, 0);
        fdUrls.right = new FormAttachment(100, 0);
        fdUrls.bottom = new FormAttachment(100, 0);
        this.wUrls.setLayoutData((Object)fdUrls);
        wUrlsComp.pack();
        Rectangle bounds = wUrlsComp.getBounds();
        wUrlsSComp.setContent((Control)wUrlsComp);
        wUrlsSComp.setExpandHorizontal(true);
        wUrlsSComp.setExpandVertical(true);
        wUrlsSComp.setMinWidth(bounds.width);
        wUrlsSComp.setMinHeight(bounds.height);
        wUrlsTab.setControl((Control)wUrlsSComp);
    }

    private void addAdvancedTab(PropsUi props, IVariables variables, int middle, int margin) {
        CTabItem wAdvancedTab = new CTabItem(this.wTabFolder, 0);
        wAdvancedTab.setFont(GuiResource.getInstance().getFontDefault());
        wAdvancedTab.setText("Advanced  ");
        ScrolledComposite wAdvancedSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        wAdvancedSComp.setLayout((Layout)new FillLayout());
        Composite wAdvancedComp = new Composite((Composite)wAdvancedSComp, 0);
        PropsUi.setLook((Widget)wAdvancedComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 3;
        formLayout.marginHeight = 3;
        wAdvancedComp.setLayout((Layout)formLayout);
        Label wlConnectionLivenessCheckTimeout = new Label(wAdvancedComp, 131072);
        wlConnectionLivenessCheckTimeout.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.ConnectionLivenessCheckTimeout.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlConnectionLivenessCheckTimeout);
        FormData fdlConnectionLivenessCheckTimeout = new FormData();
        fdlConnectionLivenessCheckTimeout.top = new FormAttachment(0, 0);
        fdlConnectionLivenessCheckTimeout.left = new FormAttachment(0, 0);
        fdlConnectionLivenessCheckTimeout.right = new FormAttachment(middle, -margin);
        wlConnectionLivenessCheckTimeout.setLayoutData((Object)fdlConnectionLivenessCheckTimeout);
        this.wConnectionLivenessCheckTimeout = new TextVar(variables, wAdvancedComp, 18436);
        PropsUi.setLook((Widget)this.wConnectionLivenessCheckTimeout);
        FormData fdConnectionLivenessCheckTimeout = new FormData();
        fdConnectionLivenessCheckTimeout.top = new FormAttachment((Control)wlConnectionLivenessCheckTimeout, 0, 0x1000000);
        fdConnectionLivenessCheckTimeout.left = new FormAttachment(middle, 0);
        fdConnectionLivenessCheckTimeout.right = new FormAttachment(95, 0);
        this.wConnectionLivenessCheckTimeout.setLayoutData((Object)fdConnectionLivenessCheckTimeout);
        TextVar lastGroupControl = this.wConnectionLivenessCheckTimeout;
        Label wlMaxConnectionLifetime = new Label(wAdvancedComp, 131072);
        wlMaxConnectionLifetime.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.MaxConnectionLifetime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMaxConnectionLifetime);
        FormData fdlMaxConnectionLifetime = new FormData();
        fdlMaxConnectionLifetime.top = new FormAttachment((Control)lastGroupControl, margin);
        fdlMaxConnectionLifetime.left = new FormAttachment(0, 0);
        fdlMaxConnectionLifetime.right = new FormAttachment(middle, -margin);
        wlMaxConnectionLifetime.setLayoutData((Object)fdlMaxConnectionLifetime);
        this.wMaxConnectionLifetime = new TextVar(variables, wAdvancedComp, 18436);
        PropsUi.setLook((Widget)this.wMaxConnectionLifetime);
        FormData fdMaxConnectionLifetime = new FormData();
        fdMaxConnectionLifetime.top = new FormAttachment((Control)wlMaxConnectionLifetime, 0, 0x1000000);
        fdMaxConnectionLifetime.left = new FormAttachment(middle, 0);
        fdMaxConnectionLifetime.right = new FormAttachment(95, 0);
        this.wMaxConnectionLifetime.setLayoutData((Object)fdMaxConnectionLifetime);
        lastGroupControl = this.wMaxConnectionLifetime;
        Label wlMaxConnectionPoolSize = new Label(wAdvancedComp, 131072);
        wlMaxConnectionPoolSize.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.MaxConnectionPoolSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMaxConnectionPoolSize);
        FormData fdlMaxConnectionPoolSize = new FormData();
        fdlMaxConnectionPoolSize.top = new FormAttachment((Control)lastGroupControl, margin);
        fdlMaxConnectionPoolSize.left = new FormAttachment(0, 0);
        fdlMaxConnectionPoolSize.right = new FormAttachment(middle, -margin);
        wlMaxConnectionPoolSize.setLayoutData((Object)fdlMaxConnectionPoolSize);
        this.wMaxConnectionPoolSize = new TextVar(variables, wAdvancedComp, 18436);
        PropsUi.setLook((Widget)this.wMaxConnectionPoolSize);
        FormData fdMaxConnectionPoolSize = new FormData();
        fdMaxConnectionPoolSize.top = new FormAttachment((Control)wlMaxConnectionPoolSize, 0, 0x1000000);
        fdMaxConnectionPoolSize.left = new FormAttachment(middle, 0);
        fdMaxConnectionPoolSize.right = new FormAttachment(95, 0);
        this.wMaxConnectionPoolSize.setLayoutData((Object)fdMaxConnectionPoolSize);
        lastGroupControl = this.wMaxConnectionPoolSize;
        Label wlConnectionAcquisitionTimeout = new Label(wAdvancedComp, 131072);
        wlConnectionAcquisitionTimeout.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.ConnectionAcquisitionTimeout.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlConnectionAcquisitionTimeout);
        FormData fdlConnectionAcquisitionTimeout = new FormData();
        fdlConnectionAcquisitionTimeout.top = new FormAttachment((Control)lastGroupControl, margin);
        fdlConnectionAcquisitionTimeout.left = new FormAttachment(0, 0);
        fdlConnectionAcquisitionTimeout.right = new FormAttachment(middle, -margin);
        wlConnectionAcquisitionTimeout.setLayoutData((Object)fdlConnectionAcquisitionTimeout);
        this.wConnectionAcquisitionTimeout = new TextVar(variables, wAdvancedComp, 18436);
        PropsUi.setLook((Widget)this.wConnectionAcquisitionTimeout);
        FormData fdConnectionAcquisitionTimeout = new FormData();
        fdConnectionAcquisitionTimeout.top = new FormAttachment((Control)wlConnectionAcquisitionTimeout, 0, 0x1000000);
        fdConnectionAcquisitionTimeout.left = new FormAttachment(middle, 0);
        fdConnectionAcquisitionTimeout.right = new FormAttachment(95, 0);
        this.wConnectionAcquisitionTimeout.setLayoutData((Object)fdConnectionAcquisitionTimeout);
        lastGroupControl = this.wConnectionAcquisitionTimeout;
        Label wlConnectionTimeout = new Label(wAdvancedComp, 131072);
        wlConnectionTimeout.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.ConnectionTimeout.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlConnectionTimeout);
        FormData fdlConnectionTimeout = new FormData();
        fdlConnectionTimeout.top = new FormAttachment((Control)lastGroupControl, margin);
        fdlConnectionTimeout.left = new FormAttachment(0, 0);
        fdlConnectionTimeout.right = new FormAttachment(middle, -margin);
        wlConnectionTimeout.setLayoutData((Object)fdlConnectionTimeout);
        this.wConnectionTimeout = new TextVar(variables, wAdvancedComp, 18436);
        PropsUi.setLook((Widget)this.wConnectionTimeout);
        FormData fdConnectionTimeout = new FormData();
        fdConnectionTimeout.top = new FormAttachment((Control)wlConnectionTimeout, 0, 0x1000000);
        fdConnectionTimeout.left = new FormAttachment(middle, 0);
        fdConnectionTimeout.right = new FormAttachment(95, 0);
        this.wConnectionTimeout.setLayoutData((Object)fdConnectionTimeout);
        lastGroupControl = this.wConnectionTimeout;
        Label wlMaxTransactionRetryTime = new Label(wAdvancedComp, 131072);
        wlMaxTransactionRetryTime.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.MaxTransactionRetryTime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMaxTransactionRetryTime);
        FormData fdlMaxTransactionRetryTime = new FormData();
        fdlMaxTransactionRetryTime.top = new FormAttachment((Control)lastGroupControl, margin);
        fdlMaxTransactionRetryTime.left = new FormAttachment(0, 0);
        fdlMaxTransactionRetryTime.right = new FormAttachment(middle, -margin);
        wlMaxTransactionRetryTime.setLayoutData((Object)fdlMaxTransactionRetryTime);
        this.wMaxTransactionRetryTime = new TextVar(variables, wAdvancedComp, 18436);
        PropsUi.setLook((Widget)this.wMaxTransactionRetryTime);
        FormData fdMaxTransactionRetryTime = new FormData();
        fdMaxTransactionRetryTime.top = new FormAttachment((Control)wlMaxTransactionRetryTime, 0, 0x1000000);
        fdMaxTransactionRetryTime.left = new FormAttachment(middle, 0);
        fdMaxTransactionRetryTime.right = new FormAttachment(95, 0);
        this.wMaxTransactionRetryTime.setLayoutData((Object)fdMaxTransactionRetryTime);
        wAdvancedComp.pack();
        Rectangle bounds = wAdvancedComp.getBounds();
        wAdvancedSComp.setContent((Control)wAdvancedComp);
        wAdvancedSComp.setExpandHorizontal(true);
        wAdvancedSComp.setExpandVertical(true);
        wAdvancedSComp.setMinWidth(bounds.width);
        wAdvancedSComp.setMinHeight(bounds.height);
        wAdvancedTab.setControl((Control)wAdvancedSComp);
    }

    private void enableFields() {
        boolean hasNoUrls = this.wUrls.nrNonEmpty() == 0;
        for (Control control : new Control[]{this.wlServer, this.wServer, this.wlDatabaseName, this.wDatabaseName, this.wlDatabasePort, this.wDatabasePort, this.wlRouting, this.wRouting, this.wlPolicy, this.wPolicy, this.wlEncryption, this.wEncryption}) {
            control.setEnabled(hasNoUrls);
        }
        NeoConnection neo = new NeoConnection();
        this.getWidgetsContent(neo);
        boolean automatic = neo.isAutomatic();
        boolean routing = neo.isRouting();
        boolean encryption = neo.isUsingEncryption();
        this.wRouting.setEnabled(!automatic);
        this.wlRouting.setEnabled(!automatic);
        this.wRouting.setEnabled(!automatic);
        this.wlEncryption.setEnabled(!automatic);
        this.wEncryption.setEnabled(!automatic);
        this.wlPolicy.setEnabled(!automatic && routing);
        this.wPolicy.setEnabled(!automatic && routing);
        this.wlTrustAllCertificates.setEnabled(!automatic && encryption);
        this.wTrustAllCertificates.setEnabled(!automatic && encryption);
        this.wTrustAllCertificates.getTextVar().setEnabled(!automatic && encryption);
    }

    public void setWidgetsContent() {
        this.wName.setText(Const.NVL((String)((NeoConnection)this.metadata).getName(), (String)""));
        this.wAutomatic.setSelection(((NeoConnection)this.metadata).isAutomatic());
        this.wAutomatic.setVariableName(Const.NVL((String)((NeoConnection)this.metadata).getAutomaticVariable(), (String)""));
        this.wProtocol.setText(Const.NVL((String)((NeoConnection)this.metadata).getProtocol(), (String)""));
        this.wServer.setText(Const.NVL((String)((NeoConnection)this.metadata).getServer(), (String)""));
        this.wDatabaseName.setText(Const.NVL((String)((NeoConnection)this.metadata).getDatabaseName(), (String)""));
        this.wDatabasePort.setText(Const.NVL((String)((NeoConnection)this.metadata).getBoltPort(), (String)""));
        this.wBrowserPort.setText(Const.NVL((String)((NeoConnection)this.metadata).getBrowserPort(), (String)""));
        this.wRouting.setSelection(((NeoConnection)this.metadata).isRouting());
        this.wRouting.setVariableName(Const.NVL((String)((NeoConnection)this.metadata).getRoutingVariable(), (String)""));
        this.wPolicy.setText(Const.NVL((String)((NeoConnection)this.metadata).getRoutingPolicy(), (String)""));
        this.wUsername.setText(Const.NVL((String)((NeoConnection)this.metadata).getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)((NeoConnection)this.metadata).getPassword(), (String)""));
        this.wEncryption.setSelection(((NeoConnection)this.metadata).isUsingEncryption());
        this.wEncryption.setVariableName(Const.NVL((String)((NeoConnection)this.metadata).getUsingEncryptionVariable(), (String)""));
        this.wTrustAllCertificates.setSelection(((NeoConnection)this.metadata).isTrustAllCertificates());
        this.wTrustAllCertificates.setVariableName(Const.NVL((String)((NeoConnection)this.metadata).getTrustAllCertificatesVariable(), (String)""));
        this.wConnectionLivenessCheckTimeout.setText(Const.NVL((String)((NeoConnection)this.metadata).getConnectionLivenessCheckTimeout(), (String)""));
        this.wMaxConnectionLifetime.setText(Const.NVL((String)((NeoConnection)this.metadata).getMaxConnectionLifetime(), (String)""));
        this.wMaxConnectionPoolSize.setText(Const.NVL((String)((NeoConnection)this.metadata).getMaxConnectionPoolSize(), (String)""));
        this.wConnectionAcquisitionTimeout.setText(Const.NVL((String)((NeoConnection)this.metadata).getConnectionAcquisitionTimeout(), (String)""));
        this.wConnectionTimeout.setText(Const.NVL((String)((NeoConnection)this.metadata).getConnectionTimeout(), (String)""));
        this.wMaxTransactionRetryTime.setText(Const.NVL((String)((NeoConnection)this.metadata).getMaxTransactionRetryTime(), (String)""));
        for (int i = 0; i < ((NeoConnection)this.metadata).getManualUrls().size(); ++i) {
            TableItem item = this.wUrls.table.getItem(i);
            item.setText(1, Const.NVL((String)((NeoConnection)this.metadata).getManualUrls().get(i), (String)""));
        }
        this.wUrls.setRowNums();
        this.wUrls.optWidth(true);
        this.enableFields();
        this.wName.setFocus();
    }

    public void getWidgetsContent(NeoConnection neoConnection) {
        neoConnection.setName(this.wName.getText());
        neoConnection.setAutomatic(this.wAutomatic.getSelection());
        neoConnection.setAutomaticVariable(this.wAutomatic.getVariableName());
        neoConnection.setProtocol(this.wProtocol.getText());
        neoConnection.setServer(this.wServer.getText());
        neoConnection.setDatabaseName(this.wDatabaseName.getText());
        neoConnection.setBoltPort(this.wDatabasePort.getText());
        neoConnection.setBrowserPort(this.wBrowserPort.getText());
        neoConnection.setRouting(this.wRouting.getSelection());
        neoConnection.setRoutingVariable(this.wRouting.getVariableName());
        neoConnection.setRoutingPolicy(this.wPolicy.getText());
        neoConnection.setUsername(this.wUsername.getText());
        neoConnection.setPassword(this.wPassword.getText());
        neoConnection.setUsingEncryption(this.wEncryption.getSelection());
        neoConnection.setUsingEncryptionVariable(this.wEncryption.getVariableName());
        neoConnection.setTrustAllCertificates(this.wTrustAllCertificates.getSelection());
        neoConnection.setTrustAllCertificatesVariable(this.wTrustAllCertificates.getVariableName());
        neoConnection.setConnectionLivenessCheckTimeout(this.wConnectionLivenessCheckTimeout.getText());
        neoConnection.setMaxConnectionLifetime(this.wMaxConnectionLifetime.getText());
        neoConnection.setMaxConnectionPoolSize(this.wMaxConnectionPoolSize.getText());
        neoConnection.setConnectionAcquisitionTimeout(this.wConnectionAcquisitionTimeout.getText());
        neoConnection.setConnectionTimeout(this.wConnectionTimeout.getText());
        neoConnection.setMaxTransactionRetryTime(this.wMaxTransactionRetryTime.getText());
        neoConnection.getManualUrls().clear();
        for (int i = 0; i < this.wUrls.nrNonEmpty(); ++i) {
            TableItem item = this.wUrls.getNonEmpty(i);
            neoConnection.getManualUrls().add(item.getText(1));
        }
    }

    public void test() {
        IVariables variables = this.manager.getVariables();
        NeoConnection neo = new NeoConnection((NeoConnection)this.metadata);
        try {
            this.getWidgetsContent(neo);
            neo.test(variables);
            MessageBox box = new MessageBox(this.hopGui.getShell(), 32);
            box.setText("OK");
            String message = "Connection successful!" + Const.CR;
            message = message + Const.CR;
            message = message + "URL : " + neo.getUrl(variables);
            box.setMessage(message);
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), "Error", "Error connecting to Neo with URL : " + neo.getUrl(variables), e);
        }
    }

    public Button[] createButtonsForButtonBar(Composite composite) {
        Button wTest = new Button(composite, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        wTest.addListener(13, e -> this.test());
        return new Button[]{wTest};
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }

    public void clearChanged() {
        this.resetChanged();
        MetadataPerspective.getInstance().updateEditor((MetadataEditor)this);
    }
}

