/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model;

import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaTimestamp;

public enum GraphPropertyType {
    String,
    Integer,
    Float,
    Boolean,
    Date,
    LocalDateTime,
    ByteArray,
    Time,
    Point,
    Duration,
    LocalTime,
    DateTime,
    Array;


    public static String getCode(GraphPropertyType type) {
        if (type == null) {
            return null;
        }
        return type.name();
    }

    public static GraphPropertyType parseCode(String code) {
        if (code == null) {
            return String;
        }
        try {
            return GraphPropertyType.valueOf(code);
        }
        catch (IllegalArgumentException e) {
            return String;
        }
    }

    public static String[] getNames() {
        String[] names = new String[GraphPropertyType.values().length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = GraphPropertyType.values()[i].name();
        }
        return names;
    }

    public Object convertFromHop(IValueMeta valueMeta, Object valueData) throws HopValueException {
        if (valueMeta.isNull(valueData)) {
            return null;
        }
        TimeZone timeZone = valueMeta.getDateFormatTimeZone();
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        switch (this) {
            case String: {
                return valueMeta.getString(valueData);
            }
            case Boolean: {
                return valueMeta.getBoolean(valueData);
            }
            case Float: {
                return valueMeta.getNumber(valueData);
            }
            case Integer: {
                return valueMeta.getInteger(valueData);
            }
            case Date: {
                return valueMeta.getDate(valueData).toInstant().atZone(timeZone.toZoneId()).toLocalDate();
            }
            case LocalDateTime: {
                return valueMeta.getDate(valueData).toInstant().atZone(timeZone.toZoneId()).toLocalDateTime();
            }
            case ByteArray: {
                return valueMeta.getBinary(valueData);
            }
            case DateTime: {
                ZonedDateTime zonedDateTime;
                if (valueMeta instanceof ValueMetaTimestamp) {
                    ValueMetaTimestamp valueMetaTimestamp = (ValueMetaTimestamp)valueMeta;
                    Timestamp timestamp = valueMetaTimestamp.getTimestamp(valueData);
                    zonedDateTime = timestamp.toInstant().atZone(timeZone.toZoneId());
                } else {
                    Date date = valueMeta.getDate(valueData);
                    zonedDateTime = date.toInstant().atZone(timeZone.toZoneId());
                }
                return zonedDateTime;
            }
            case Array: {
                throw new HopValueException("Array conversion requires separator and enclosure parameters. Use convertFromHop(valueMeta, valueData, separator, enclosure) instead.");
            }
        }
        throw new HopValueException("Data conversion to Neo4j type '" + this.name() + "' from value '" + valueMeta.toStringMeta() + "' is not supported yet");
    }

    public Object convertFromHop(IValueMeta valueMeta, Object valueData, String separator, String enclosure) throws HopValueException {
        String[] parts;
        if (this != Array) {
            return this.convertFromHop(valueMeta, valueData);
        }
        if (valueMeta.isNull(valueData)) {
            return null;
        }
        String arrayString = valueMeta.getString(valueData);
        if (StringUtils.isEmpty((String)arrayString)) {
            return new ArrayList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String sep = StringUtils.isEmpty((String)separator) ? "," : separator;
        String encl = StringUtils.isEmpty((String)enclosure) ? "" : enclosure;
        arrayString = arrayString.trim();
        for (String part : parts = arrayString.split(sep, -1)) {
            if ((part = part.trim()).isEmpty()) continue;
            if (!encl.isEmpty() && part.startsWith(encl) && part.endsWith(encl)) {
                part = part.substring(encl.length(), part.length() - encl.length());
            }
            part = part.trim();
            try {
                double value = Double.parseDouble(part);
                arrayList.add(value);
            }
            catch (NumberFormatException e) {
                arrayList.add(part);
            }
        }
        return arrayList;
    }

    public static final GraphPropertyType getTypeFromHop(IValueMeta valueMeta) {
        return switch (valueMeta.getType()) {
            case 2 -> String;
            case 1 -> Float;
            case 3 -> LocalDateTime;
            case 9 -> LocalDateTime;
            case 4 -> Boolean;
            case 8 -> ByteArray;
            case 6 -> String;
            case 5 -> Integer;
            default -> String;
        };
    }
}

