/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.QueryServiceSettings;
import com.google.cloud.monitoring.v3.stub.QueryServiceStub;
import com.google.cloud.monitoring.v3.stub.QueryServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.monitoring.v3.QueryTimeSeriesRequest;
import com.google.monitoring.v3.QueryTimeSeriesResponse;
import com.google.monitoring.v3.TimeSeriesData;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class QueryServiceClient
implements BackgroundResource {
    private final QueryServiceSettings settings;
    private final QueryServiceStub stub;

    public static final QueryServiceClient create() throws IOException {
        return QueryServiceClient.create(QueryServiceSettings.newBuilder().build());
    }

    public static final QueryServiceClient create(QueryServiceSettings settings) throws IOException {
        return new QueryServiceClient(settings);
    }

    public static final QueryServiceClient create(QueryServiceStub stub) {
        return new QueryServiceClient(stub);
    }

    protected QueryServiceClient(QueryServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((QueryServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected QueryServiceClient(QueryServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final QueryServiceSettings getSettings() {
        return this.settings;
    }

    public QueryServiceStub getStub() {
        return this.stub;
    }

    @Deprecated
    public final QueryTimeSeriesPagedResponse queryTimeSeries(QueryTimeSeriesRequest request) {
        return (QueryTimeSeriesPagedResponse)((Object)this.queryTimeSeriesPagedCallable().call((Object)request));
    }

    @Deprecated
    public final UnaryCallable<QueryTimeSeriesRequest, QueryTimeSeriesPagedResponse> queryTimeSeriesPagedCallable() {
        return this.stub.queryTimeSeriesPagedCallable();
    }

    @Deprecated
    public final UnaryCallable<QueryTimeSeriesRequest, QueryTimeSeriesResponse> queryTimeSeriesCallable() {
        return this.stub.queryTimeSeriesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class QueryTimeSeriesFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData, QueryTimeSeriesPage, QueryTimeSeriesFixedSizeCollection> {
        private QueryTimeSeriesFixedSizeCollection(List<QueryTimeSeriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryTimeSeriesFixedSizeCollection createEmptyCollection() {
            return new QueryTimeSeriesFixedSizeCollection(null, 0);
        }

        protected QueryTimeSeriesFixedSizeCollection createCollection(List<QueryTimeSeriesPage> pages, int collectionSize) {
            return new QueryTimeSeriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryTimeSeriesPage
    extends AbstractPage<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData, QueryTimeSeriesPage> {
        private QueryTimeSeriesPage(PageContext<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> context, QueryTimeSeriesResponse response) {
            super(context, (Object)response);
        }

        private static QueryTimeSeriesPage createEmptyPage() {
            return new QueryTimeSeriesPage(null, null);
        }

        protected QueryTimeSeriesPage createPage(PageContext<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> context, QueryTimeSeriesResponse response) {
            return new QueryTimeSeriesPage(context, response);
        }

        public ApiFuture<QueryTimeSeriesPage> createPageAsync(PageContext<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> context, ApiFuture<QueryTimeSeriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryTimeSeriesPagedResponse
    extends AbstractPagedListResponse<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData, QueryTimeSeriesPage, QueryTimeSeriesFixedSizeCollection> {
        public static ApiFuture<QueryTimeSeriesPagedResponse> createAsync(PageContext<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> context, ApiFuture<QueryTimeSeriesResponse> futureResponse) {
            ApiFuture<QueryTimeSeriesPage> futurePage = QueryTimeSeriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryTimeSeriesPagedResponse((QueryTimeSeriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryTimeSeriesPagedResponse(QueryTimeSeriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryTimeSeriesFixedSizeCollection.createEmptyCollection());
        }
    }
}

