/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.codegen;

import com.sforce.ws.tools.ToolsException;
import com.sforce.ws.util.Verbose;
import java.io.File;
import java.util.ArrayList;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

class Compiler {
    JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    DiagnosticCollector<JavaFileObject> ds = new DiagnosticCollector();
    StandardJavaFileManager mgr = this.compiler.getStandardFileManager(this.ds, null, null);

    public void compile(String[] files) throws ToolsException {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        int itr = 0;
        while (itr < files.length) {
            generatedFiles.add(new File(files[itr]));
            ++itr;
        }
        Iterable<? extends JavaFileObject> sourceFiles = this.mgr.getJavaFileObjectsFromFiles(generatedFiles);
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.mgr, this.ds, null, null, sourceFiles);
        task.call();
        int diagnosticWithError = 0;
        for (Diagnostic<JavaFileObject> d : this.ds.getDiagnostics()) {
            if (d.getKind() == Diagnostic.Kind.ERROR) {
                System.out.format("Error at Line: %d, %s in %s \n", d.getLineNumber(), d.getMessage(null), d.getSource().getName());
                ++diagnosticWithError;
                continue;
            }
            System.out.println(d);
        }
        if (diagnosticWithError > 0) {
            throw new ToolsException("Failed to compile");
        }
        Verbose.log("Compiled " + files.length + " java files.");
    }
}

