/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective;

import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.TabClosable;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TabCloseHandler {
    private static final Class<?> PKG = HopGui.class;
    CTabFolder tabFolder;
    CTabItem selectedItem;

    public TabCloseHandler(TabClosable tabClosablePerspective) {
        this.tabFolder = tabClosablePerspective.getTabFolder();
        Menu menu = new Menu((Control)this.tabFolder);
        this.tabFolder.setMenu(menu);
        this.tabFolder.addListener(35, this::handleTabMenuDetectEvent);
        this.tabFolder.addListener(4, event -> this.handleMouseUp(event, tabClosablePerspective));
        MenuItem miClose = new MenuItem(menu, 0);
        miClose.setText(BaseMessages.getString(PKG, (String)"HopGui.TabItem.Close.Text", (String[])new String[0]));
        miClose.addListener(13, event -> tabClosablePerspective.closeTab(null, this.selectedItem));
        MenuItem miCloseOthers = new MenuItem(menu, 0);
        miCloseOthers.setText(BaseMessages.getString(PKG, (String)"HopGui.TabItem.CloseOther.Text", (String[])new String[0]));
        miCloseOthers.addListener(13, event -> tabClosablePerspective.getOtherTabs(this.selectedItem).forEach(tabItem -> tabClosablePerspective.closeTab(null, (CTabItem)tabItem)));
        MenuItem miCloseAll = new MenuItem(menu, 0);
        miCloseAll.setText(BaseMessages.getString(PKG, (String)"HopGui.TabItem.CloseAll.Text", (String[])new String[0]));
        miCloseAll.addListener(13, event -> {
            for (CTabItem tabItem : tabClosablePerspective.getTabFolder().getItems()) {
                tabClosablePerspective.closeTab(null, tabItem);
            }
        });
        MenuItem miCloseLeft = new MenuItem(menu, 0);
        miCloseLeft.setText(BaseMessages.getString(PKG, (String)"HopGui.TabItem.CloseLeft.Text", (String[])new String[0]));
        miCloseLeft.addListener(13, event -> tabClosablePerspective.getTabsToLeft(this.selectedItem).forEach(tabItem -> tabClosablePerspective.closeTab(null, (CTabItem)tabItem)));
        MenuItem miCloseRight = new MenuItem(menu, 0);
        miCloseRight.setText(BaseMessages.getString(PKG, (String)"HopGui.TabItem.CloseRight.Text", (String[])new String[0]));
        miCloseRight.addListener(13, event -> tabClosablePerspective.getTabsToRight(this.selectedItem).forEach(tabItem -> tabClosablePerspective.closeTab(null, (CTabItem)tabItem)));
    }

    private void handleMouseUp(Event event, TabClosable tabClosablePerspective) {
        Point point;
        CTabItem item;
        if (event.button == 2 && (item = this.tabFolder.getItem(point = new Point(event.x, event.y))) != null) {
            tabClosablePerspective.closeTab(null, item);
        }
        event.doit = false;
    }

    private void handleTabMenuDetectEvent(Event event) {
        Point point = this.tabFolder.toControl(this.tabFolder.getDisplay().getCursorLocation());
        this.selectedItem = this.tabFolder.getItem(new Point(point.x, point.y));
        if (this.selectedItem == null) {
            event.doit = false;
        }
    }
}

