/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.widget.IDoubleClick;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeItemAccelerator {
    public static final void addDoubleClick(final TreeItem treeItem, final IDoubleClick doubleClick) {
        final String[] path1 = ConstUi.getTreeStrings(treeItem);
        final Tree tree = treeItem.getParent();
        if (doubleClick != null) {
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    TreeItem[] items;
                    for (TreeItem item : items = tree.getSelection()) {
                        String[] path2 = ConstUi.getTreeStrings(item);
                        if (!TreeItemAccelerator.equalPaths(path1, path2)) continue;
                        doubleClick.action(treeItem);
                    }
                }
            };
            tree.addSelectionListener((SelectionListener)selectionAdapter);
            treeItem.addDisposeListener(disposeEvent -> tree.removeSelectionListener((SelectionListener)selectionAdapter));
        }
    }

    public static final boolean equalPaths(String[] path1, String[] path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.length != path2.length) {
            return false;
        }
        for (int i = 0; i < path1.length; ++i) {
            if (path1[i].equals(path2[i])) continue;
            return false;
        }
        return true;
    }
}

