/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.database.dialog;

import java.lang.reflect.InvocationTargetException;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.Shell;

public class GetTableSizeProgressDialog {
    private static final Class<?> PKG = GetTableSizeProgressDialog.class;
    private final Shell shell;
    private final IVariables variables;
    private final DatabaseMeta databaseMeta;
    private final String tableName;
    private Long size;
    private Database db;

    public GetTableSizeProgressDialog(Shell shell, IVariables variables, DatabaseMeta databaseMeta, String tableName) {
        this(shell, variables, databaseMeta, tableName, null);
    }

    public GetTableSizeProgressDialog(Shell shell, IVariables variables, DatabaseMeta databaseMeta, String tableName, String schemaName) {
        this.shell = shell;
        this.variables = variables;
        this.databaseMeta = databaseMeta;
        this.tableName = databaseMeta.getQuotedSchemaTableCombination(variables, schemaName, tableName);
    }

    public Long open() {
        IRunnableWithProgress op = monitor -> {
            this.db = new Database(HopGui.getInstance().getLoggingObject(), this.variables, this.databaseMeta);
            try {
                this.db.connect();
                String sql = this.databaseMeta.getIDatabase().getSelectCountStatement(this.tableName);
                RowMetaAndData row = this.db.getOneRow(sql);
                this.size = row.getRowMeta().getInteger(row.getData(), 0);
                if (monitor.isCanceled()) {
                    throw new InvocationTargetException(new Exception("This operation was cancelled!"));
                }
            }
            catch (HopException e) {
                throw new InvocationTargetException(e, "Couldn't get a result because of an error :" + e.toString());
            }
            finally {
                this.db.disconnect();
                monitor.done();
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            Runnable run = () -> {
                IProgressMonitor monitor = pmd.getProgressMonitor();
                while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (monitor.isCanceled()) {
                    try {
                        this.db.cancelQuery();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, op);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.showErrorDialog(e);
            return null;
        }
        return this.size;
    }

    private void showErrorDialog(Exception e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetTableSizeProgressDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetTableSizeProgressDialog.Error.Message", (String[])new String[0]), e);
    }
}

