/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.util.Utils;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;

@HopServerServlet(id="execPipeline", name="Execute pipeline from file path")
public class ExecPipelineServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final long serialVersionUID = -5879219287669847357L;
    private static final String UNABLE_TO_FIND_PIPELINE = "Unable to find pipeline";
    private static final String PIPELINE = "pipeline";
    private static final String LEVEL = "level";
    private static final String RUN_CONFIG = "runConfig";
    public static final String CONTEXT_PATH = "/hop/execPipeline";

    public ExecPipelineServlet() {
    }

    public ExecPipelineServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Execute pipeline requested");
        }
        String[] knownOptions = new String[]{PIPELINE, LEVEL, RUN_CONFIG};
        String pipelineOption = request.getParameter(PIPELINE);
        String levelOption = request.getParameter(LEVEL);
        String runConfigOption = request.getParameter(RUN_CONFIG);
        response.setStatus(200);
        String encoding = System.getProperty("HOP_DEFAULT_SERVLET_ENCODING", null);
        if (encoding != null && !Utils.isEmpty((CharSequence)encoding.trim())) {
            response.setCharacterEncoding(encoding);
            response.setContentType("text/html; charset=" + encoding);
        } else {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        }
        PrintWriter out = response.getWriter();
        if (pipelineOption == null) {
            response.setStatus(400);
            out.println(new WebResult("ERROR", "Missing mandatory parameter: pipeline"));
            return;
        }
        try {
            PipelineRunConfiguration defaultRunConfiguration;
            MultiMetadataProvider metadataProvider = this.getServerConfig().getMetadataProvider();
            if (metadataProvider == null) {
                throw new HopException("Metadata provider is not available");
            }
            String resolvedPipelinePath = this.variables.resolve(pipelineOption);
            PipelineMeta pipelineMeta = new PipelineMeta(resolvedPipelinePath, (IHopMetadataProvider)metadataProvider, this.variables);
            String[] parameters = pipelineMeta.listParameters();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameter = (String)parameterNames.nextElement();
                String[] values = request.getParameterValues(parameter);
                if (Const.indexOfString((String)parameter, (String[])knownOptions) >= 0 || Const.indexOfString((String)parameter, (String[])parameters) >= 0) continue;
                this.variables.setVariable(parameter, values[0]);
            }
            PipelineExecutionConfiguration pipelineExecutionConfiguration = new PipelineExecutionConfiguration();
            LogLevel logLevel = null;
            if (!Utils.isEmpty((CharSequence)levelOption)) {
                logLevel = LogLevel.lookupCode((String)levelOption);
            }
            if (logLevel != null) {
                pipelineExecutionConfiguration.setLogLevel(logLevel);
            }
            String runConfigurationName = !StringUtils.isEmpty((String)runConfigOption) ? runConfigOption : ((defaultRunConfiguration = PipelineRunConfiguration.findDefault((IHopMetadataProvider)metadataProvider)) != null ? defaultRunConfiguration.getName() : "local");
            pipelineExecutionConfiguration.setRunConfiguration(runConfigurationName);
            String serverObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.HOP_SERVER, null);
            servletLoggingObject.setContainerObjectId(serverObjectId);
            if (logLevel != null) {
                servletLoggingObject.setLogLevel(logLevel);
            }
            IPipelineEngine<PipelineMeta> pipeline = PipelineEngineFactory.createPipelineEngine(this.variables, this.variables.resolve(pipelineExecutionConfiguration.getRunConfiguration()), (IHopMetadataProvider)metadataProvider, pipelineMeta);
            pipeline.setParent((ILoggingObject)servletLoggingObject);
            pipeline.setMetadataProvider((IHopMetadataProvider)metadataProvider);
            pipeline.copyParametersFromDefinitions(pipelineMeta);
            for (String parameter : parameters) {
                String value = request.getParameter(parameter);
                if (value == null) continue;
                pipeline.setParameterValue(parameter, value);
            }
            pipeline.activateParameters(pipeline);
            SerializableMetadataProvider serializableMetadataProvider = new SerializableMetadataProvider((IHopMetadataProvider)metadataProvider);
            PipelineConfiguration pipelineConfiguration = new PipelineConfiguration(pipelineMeta, pipelineExecutionConfiguration, serializableMetadataProvider);
            this.getPipelineMap().addPipeline(pipelineMeta.getName(), serverObjectId, pipeline, pipelineConfiguration);
            pipeline.setContainerId(serverObjectId);
            this.executePipeline(pipeline);
            String logging = HopLogStore.getAppender().getBuffer(pipeline.getLogChannelId(), false).toString();
            if (pipeline.isFinished() && pipeline.getErrors() > 0) {
                response.setStatus(500);
                out.println(new WebResult("ERROR", "Error executing pipeline: " + logging));
            } else {
                out.println(new WebResult("OK", "Pipeline executed successfully"));
            }
            out.flush();
        }
        catch (Exception ex) {
            if (ex.getMessage() != null && ex.getMessage().contains(UNABLE_TO_FIND_PIPELINE)) {
                response.setStatus(404);
                out.println(new WebResult("ERROR", "Unable to find pipeline: " + pipelineOption + " (resolved: " + (pipelineOption != null ? this.variables.resolve(pipelineOption) : "null") + ")"));
            }
            String logging = Const.getStackTracker((Throwable)ex);
            response.setStatus(500);
            out.println(new WebResult("ERROR", "Unexpected error executing pipeline: " + Const.CR + logging));
        }
    }

    protected void executePipeline(IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        pipeline.prepareExecution();
        pipeline.startThreads();
        pipeline.waitUntilFinished();
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    @Override
    public String getService() {
        return "/hop/execPipeline (" + this.toString() + ")";
    }

    public String toString() {
        return "Execute pipeline from file";
    }
}

