/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.apache.hop.core.Result;

public class ActionResult
implements Cloneable,
Comparator<ActionResult>,
Comparable<ActionResult> {
    private Result result;
    private String actionName;
    private String comment;
    private String reason;
    private Date logDate = new Date();
    private String actionFilename;
    private String logChannelId;
    private boolean checkpoint;

    public ActionResult() {
    }

    public ActionResult(Result result, String logChannelId, String comment, String reason, String actionName, String actionFilename) {
        this();
        if (result != null) {
            this.result = result.lightClone();
            this.result.setLogText(null);
        } else {
            this.result = null;
        }
        this.logChannelId = logChannelId;
        this.comment = comment;
        this.reason = reason;
        this.actionName = actionName;
        this.actionFilename = actionFilename;
    }

    public Object clone() {
        try {
            ActionResult actionResult = (ActionResult)super.clone();
            if (this.getResult() != null) {
                actionResult.setResult(this.getResult().clone());
            }
            return actionResult;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public int compare(ActionResult one, ActionResult two) {
        if (one == null && two != null) {
            return -1;
        }
        if (one != null && two == null) {
            return 1;
        }
        if (one == null && two == null) {
            return 0;
        }
        if (one.getActionName() == null && two.getActionName() != null) {
            return -1;
        }
        if (one.getActionName() != null && two.getActionName() == null) {
            return 1;
        }
        if (one.getActionName() == null && two.getActionName() == null) {
            return 0;
        }
        return one.getActionName().compareTo(two.getActionName());
    }

    @Override
    public int compareTo(ActionResult two) {
        return this.compare(this, two);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionResult that = (ActionResult)o;
        return this.checkpoint == that.checkpoint && Objects.equals(this.result, that.result) && Objects.equals(this.actionName, that.actionName) && Objects.equals(this.comment, that.comment) && Objects.equals(this.reason, that.reason) && Objects.equals(this.logDate, that.logDate) && Objects.equals(this.actionFilename, that.actionFilename) && Objects.equals(this.logChannelId, that.logChannelId);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.actionName, this.comment, this.reason, this.logDate, this.actionFilename, this.logChannelId, this.checkpoint);
    }

    @Generated
    public Result getResult() {
        return this.result;
    }

    @Generated
    public String getActionName() {
        return this.actionName;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public Date getLogDate() {
        return this.logDate;
    }

    @Generated
    public String getActionFilename() {
        return this.actionFilename;
    }

    @Generated
    public String getLogChannelId() {
        return this.logChannelId;
    }

    @Generated
    public boolean isCheckpoint() {
        return this.checkpoint;
    }

    @Generated
    public void setResult(Result result) {
        this.result = result;
    }

    @Generated
    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    @Generated
    public void setActionFilename(String actionFilename) {
        this.actionFilename = actionFilename;
    }

    @Generated
    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    @Generated
    public void setCheckpoint(boolean checkpoint) {
        this.checkpoint = checkpoint;
    }
}

