/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PartitionerPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.partition.PartitionSchema;
import org.apache.hop.pipeline.IPartitioner;
import org.w3c.dom.Node;

public class TransformPartitioningMeta
implements Cloneable {
    public static final int PARTITIONING_METHOD_NONE = 0;
    public static final int PARTITIONING_METHOD_MIRROR = 1;
    public static final int PARTITIONING_METHOD_SPECIAL = 2;
    public static final String[] methodCodes = new String[]{"none", "Mirror"};
    public static final String[] methodDescriptions = new String[]{"None", "Mirror to all partitions"};
    private int methodType;
    @HopMetadataProperty
    private String method;
    @HopMetadataProperty(storeWithName=true)
    private PartitionSchema partitionSchema;
    @HopMetadataProperty
    private IPartitioner partitioner;
    private boolean hasChanged = false;

    public TransformPartitioningMeta() {
        this.method = "none";
        this.methodType = 0;
        this.partitionSchema = new PartitionSchema();
        this.hasChanged = false;
    }

    public TransformPartitioningMeta(String method, PartitionSchema partitionSchema) throws HopPluginException {
        this.setMethod(method);
        this.partitionSchema = partitionSchema;
        this.hasChanged = false;
    }

    public TransformPartitioningMeta clone() {
        try {
            TransformPartitioningMeta transformPartitioningMeta = new TransformPartitioningMeta(this.method, this.partitionSchema != null ? (PartitionSchema)this.partitionSchema.clone() : null);
            transformPartitioningMeta.setMethodType(this.methodType);
            transformPartitioningMeta.setPartitioner(this.partitioner == null ? null : this.partitioner.clone());
            return transformPartitioningMeta;
        }
        catch (HopPluginException e) {
            throw new RuntimeException("Unable to load partitioning plugin", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.partitionSchema == null) {
            return false;
        }
        TransformPartitioningMeta meta = (TransformPartitioningMeta)obj;
        if (this.partitionSchema == null && meta.partitionSchema == null) {
            return true;
        }
        if (this.partitionSchema != null && meta.partitionSchema == null || this.partitionSchema == null && meta.partitionSchema != null) {
            return false;
        }
        String schemaName = this.partitionSchema.getName();
        String otherName = meta.getPartitionSchema().getName();
        if (schemaName == null && otherName == null) {
            return true;
        }
        if (schemaName != null && otherName == null || schemaName == null && otherName != null) {
            return false;
        }
        return schemaName.equalsIgnoreCase(otherName);
    }

    public int hashCode() {
        return this.partitionSchema == null ? 0 : this.partitionSchema.getName().hashCode();
    }

    public String toString() {
        Object description = this.partitioner != null ? this.partitioner.getDescription() : this.getMethodDescription();
        if (this.partitionSchema != null) {
            description = (String)description + " / " + this.partitionSchema.toString();
        }
        return description;
    }

    public int getMethodType() {
        return this.methodType;
    }

    public void setMethod(String method) throws HopPluginException {
        if (!method.equals(this.method)) {
            this.method = method;
            this.createPartitioner(method);
            this.hasChanged = true;
        }
    }

    public String getXml() throws HopException {
        StringBuilder xml = new StringBuilder(150);
        xml.append("    ").append(XmlHandler.openTag((String)"partitioning")).append(Const.CR);
        xml.append("      ").append(XmlHandler.addTagValue((String)"method", (String)this.getMethodCode()));
        xml.append("      ").append(XmlHandler.addTagValue((String)"schema_name", (String)(this.partitionSchema != null ? this.partitionSchema.getName() : "")));
        if (this.partitioner != null) {
            xml.append(this.partitioner.getXml());
        }
        xml.append("    ").append(XmlHandler.closeTag((String)"partitioning")).append(Const.CR);
        return xml.toString();
    }

    public TransformPartitioningMeta(Node partitioningMethodNode, IHopMetadataProvider metadataProvider) throws HopException {
        this();
        this.setMethod(TransformPartitioningMeta.getMethod(XmlHandler.getTagValue((Node)partitioningMethodNode, (String)"method")));
        String partitionSchemaName = XmlHandler.getTagValue((Node)partitioningMethodNode, (String)"schema_name");
        if (StringUtils.isEmpty((String)partitionSchemaName)) {
            this.partitionSchema = new PartitionSchema();
        } else {
            try {
                IHopMetadataSerializer serializer = metadataProvider.getSerializer(PartitionSchema.class);
                this.partitionSchema = (PartitionSchema)serializer.load(partitionSchemaName);
            }
            catch (Exception e) {
                throw new HopException("Unable to load partition schema with name '" + partitionSchemaName + "'", (Throwable)e);
            }
        }
        this.hasChanged = false;
        if (this.partitioner != null) {
            this.partitioner.loadXml(partitioningMethodNode);
        }
    }

    public String getMethodCode() {
        if (this.methodType == 2) {
            if (this.partitioner != null) {
                return this.partitioner.getId();
            }
            return methodCodes[0];
        }
        return methodCodes[this.methodType];
    }

    public String getMethodDescription() {
        if (this.methodType != 2) {
            return methodDescriptions[this.methodType];
        }
        return this.partitioner.getDescription();
    }

    public String getMethod() {
        return this.method;
    }

    public static final String getMethod(String name) {
        if (Utils.isEmpty((CharSequence)name)) {
            return methodCodes[0];
        }
        for (int i = 0; i < methodDescriptions.length; ++i) {
            if (!methodDescriptions[i].equalsIgnoreCase(name)) continue;
            return methodCodes[i];
        }
        for (String methodCode : methodCodes) {
            if (!methodCode.equalsIgnoreCase(name)) continue;
            return methodCode;
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        IPlugin plugin = registry.findPluginWithName(PartitionerPluginType.class, name);
        if (plugin != null) {
            return name;
        }
        plugin = registry.findPluginWithId(PartitionerPluginType.class, name);
        if (plugin != null) {
            return name;
        }
        return methodCodes[0];
    }

    public static final int getMethodType(String description) {
        int i;
        for (i = 0; i < methodDescriptions.length; ++i) {
            if (!methodDescriptions[i].equalsIgnoreCase(description)) continue;
            return i;
        }
        for (i = 0; i < methodCodes.length; ++i) {
            if (!methodCodes[i].equalsIgnoreCase(description)) continue;
            return i;
        }
        IPlugin plugin = PluginRegistry.getInstance().findPluginWithId(PartitionerPluginType.class, description);
        if (plugin != null) {
            return 2;
        }
        return 0;
    }

    public boolean isPartitioned() {
        return this.methodType != 0;
    }

    public PartitionSchema getPartitionSchema() {
        return this.partitionSchema;
    }

    public void setPartitionSchema(PartitionSchema partitionSchema) {
        this.partitionSchema = partitionSchema;
        this.hasChanged = true;
    }

    public void createPartitioner(String method) throws HopPluginException {
        this.methodType = TransformPartitioningMeta.getMethodType(method);
        switch (this.methodType) {
            case 2: {
                PluginRegistry registry = PluginRegistry.getInstance();
                IPlugin plugin = registry.findPluginWithId(PartitionerPluginType.class, method);
                this.partitioner = (IPartitioner)registry.loadClass(plugin);
                this.partitioner.setId(plugin.getIds()[0]);
                break;
            }
            default: {
                this.partitioner = null;
            }
        }
        if (this.partitioner != null) {
            this.partitioner.setMeta(this);
        }
    }

    public boolean isMethodMirror() {
        return this.methodType == 1;
    }

    public int getPartition(IVariables variables, IRowMeta rowMeta, Object[] row) throws HopException {
        if (this.partitioner != null) {
            return this.partitioner.getPartition(variables, rowMeta, row);
        }
        return 0;
    }

    public IPartitioner getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(IPartitioner partitioner) {
        this.partitioner = partitioner;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void hasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public void setMethodType(int methodType) {
        this.methodType = methodType;
    }
}

