/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.rest;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadata;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

@HopMetadata(key="restconnection", name="i18n::RestConnection.name", description="i18n::RestConnection.description", image="rest.svg", documentationUrl="/metadata-types/rest-connection.html", hopMetadataPropertyType=HopMetadataPropertyType.REST_CONNECTION)
public class RestConnection
extends HopMetadataBase
implements IHopMetadata {
    private IVariables variables;
    private ClientBuilder builder;
    private Client client;
    private transient ILogChannel log;
    @HopMetadataProperty(key="base_url")
    private String baseUrl;
    @HopMetadataProperty(key="test_url")
    private String testUrl;
    @HopMetadataProperty(key="trustStoreFile")
    private String trustStoreFile;
    @HopMetadataProperty(key="trustStorePassword", password=true)
    private String trustStorePassword;
    @HopMetadataProperty(key="ignoreSsl")
    private boolean ignoreSsl;
    @HopMetadataProperty(key="auth_type")
    private String authType;
    @HopMetadataProperty(key="username")
    private String username;
    @HopMetadataProperty(key="password", password=true)
    private String password;
    @HopMetadataProperty(key="bearer_token")
    private String bearerToken;
    @HopMetadataProperty(key="auth_header_name")
    private String authorizationHeaderName;
    @HopMetadataProperty(key="auth_header_prefix")
    private String authorizationPrefix;
    @HopMetadataProperty(key="auth_header_value", password=true)
    private String authorizationHeaderValue;
    @HopMetadataProperty(key="keyStoreFile")
    private String keyStoreFile;
    @HopMetadataProperty(key="keyStorePassword", password=true)
    private String keyStorePassword;
    @HopMetadataProperty(key="keyStoreType")
    private String keyStoreType;
    @HopMetadataProperty(key="keyPassword", password=true)
    private String keyPassword;
    @HopMetadataProperty(key="certificateAlias")
    private String certificateAlias;

    private ILogChannel getLog() {
        if (this.log == null) {
            this.log = new LogChannel((Object)"RestConnection");
        }
        return this.log;
    }

    public RestConnection(IVariables variables) {
        this.variables = variables;
    }

    public Invocation.Builder getInvocationBuilder(String url) throws HopException {
        this.builder = ClientBuilder.newBuilder();
        if (this.needsSslConfiguration()) {
            try {
                SSLContext sslContext = this.buildSslContext();
                this.getLog().logDetailed("SSL context built. ignoreSsl=" + this.ignoreSsl + ", trustStoreFile=" + Const.NVL((String)this.trustStoreFile, (String)"<empty>") + ", keyStoreFile=" + Const.NVL((String)this.keyStoreFile, (String)"<empty>"));
                this.builder = this.builder.sslContext(sslContext);
                if (this.ignoreSsl || !Utils.isEmpty((CharSequence)this.trustStoreFile)) {
                    this.getLog().logDetailed("Enabling permissive hostname verifier.");
                    this.builder = this.builder.hostnameVerifier((hostname, session) -> true);
                }
            }
            catch (Exception e) {
                throw new HopException("Error configuring SSL for REST connection", (Throwable)e);
            }
        }
        this.client = this.builder.build();
        WebTarget target = this.client.target(url);
        Invocation.Builder invocationBuilder = target.request();
        if (StringUtils.isEmpty((String)this.authType)) {
            this.authType = !StringUtils.isEmpty((String)this.authorizationHeaderName) && !StringUtils.isEmpty((String)this.authorizationHeaderValue) ? "API Key" : "No Auth";
        }
        if (this.authType.equals("No Auth")) {
            // empty if block
        }
        if (this.authType.equals("Basic")) {
            if (!StringUtils.isEmpty((String)this.username) && !StringUtils.isEmpty((String)this.password)) {
                this.client.register((Object)HttpAuthenticationFeature.basic((String)this.resolve(this.username), (String)Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(this.password))));
                target = this.client.target(url);
                invocationBuilder = target.request();
            }
        } else if (this.authType.equals("API Key")) {
            if (!StringUtils.isEmpty((String)this.resolve(this.authorizationPrefix))) {
                invocationBuilder.header(this.resolve(this.authorizationHeaderName), (Object)(this.resolve(this.authorizationPrefix) + " " + Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(this.authorizationHeaderValue))));
            } else {
                invocationBuilder.header(this.resolve(this.authorizationHeaderName), (Object)Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(this.authorizationHeaderValue)));
            }
        } else if (this.authType.equals("Bearer") && !StringUtils.isEmpty((String)this.bearerToken)) {
            invocationBuilder.header("Authorization", (Object)("Bearer " + this.resolve(this.bearerToken)));
        }
        return invocationBuilder;
    }

    public String getResponse(String url) throws HopException {
        return (String)this.getResponseFromUrl(url).readEntity(String.class);
    }

    public Response getResponseFromUrl(String url) throws HopException {
        Response response = this.getInvocationBuilder(url).get();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new HopException("Error connecting to " + this.testUrl + ": " + response.getStatus());
        }
        return response;
    }

    public void testConnection() throws HopException {
        Response response = this.getInvocationBuilder(this.resolve(this.testUrl)).get();
        response.close();
    }

    public void disconnect() throws HopException {
        this.client.close();
    }

    public RestConnection() {
    }

    public RestConnection(RestConnection connection) {
        this.baseUrl = connection.baseUrl;
    }

    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RestConnection)) {
            return false;
        }
        RestConnection connection = (RestConnection)((Object)object);
        return this.name != null && this.name.equalsIgnoreCase(connection.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private boolean needsSslConfiguration() {
        return this.ignoreSsl || !Utils.isEmpty((CharSequence)this.trustStoreFile) || !Utils.isEmpty((CharSequence)this.keyStoreFile);
    }

    private SSLContext buildSslContext() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        TrustManager[] trustManagers = this.loadTrustManagers();
        KeyManager[] keyManagers = this.loadKeyManagers();
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }

    private TrustManager[] loadTrustManagers() throws Exception {
        if (this.ignoreSsl) {
            this.getLog().logDetailed("ignoreSsl=true -> using trust-all TrustManager.");
            return new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
        }
        if (Utils.isEmpty((CharSequence)this.trustStoreFile)) {
            this.getLog().logDetailed("No trust store configured. Falling back to default system trust store.");
            return null;
        }
        String resolvedTrustStoreFile = this.resolve(this.trustStoreFile);
        this.getLog().logDetailed("Loading trust store from: " + resolvedTrustStoreFile);
        String resolvedTrustStorePassword = Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(this.trustStorePassword));
        KeyStore trustStore = KeyStore.getInstance("JKS");
        try (FileInputStream fis = new FileInputStream(resolvedTrustStoreFile);){
            trustStore.load(fis, resolvedTrustStorePassword.toCharArray());
            this.getLog().logDetailed("Trust store loaded successfully.");
        }
        catch (FileNotFoundException e) {
            throw new HopException("Trust store file not found: " + resolvedTrustStoreFile, (Throwable)e);
        }
        catch (Exception e) {
            throw new HopException("Failed to load trust store from " + resolvedTrustStoreFile + ". Check file path and password.", (Throwable)e);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        return tmf.getTrustManagers();
    }

    private KeyManager[] loadKeyManagers() throws Exception {
        if (Utils.isEmpty((CharSequence)this.keyStoreFile)) {
            this.getLog().logDetailed("No key store configured. Skipping client certificate setup.");
            return null;
        }
        String resolvedKeyStoreFile = this.resolve(this.keyStoreFile);
        this.getLog().logDetailed("Loading key store from: " + resolvedKeyStoreFile + " (type=" + Const.NVL((String)this.keyStoreType, (String)"PKCS12") + ")");
        String resolvedKeyStorePassword = Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(this.keyStorePassword));
        String storeType = Utils.isEmpty((CharSequence)this.keyStoreType) ? "PKCS12" : this.resolve(this.keyStoreType);
        KeyStore keyStore = KeyStore.getInstance(storeType);
        try (FileInputStream fis = new FileInputStream(resolvedKeyStoreFile);){
            keyStore.load(fis, resolvedKeyStorePassword.toCharArray());
            this.getLog().logDetailed("Key store loaded successfully.");
        }
        catch (FileNotFoundException e) {
            throw new HopException("Key store file not found: " + resolvedKeyStoreFile, (Throwable)e);
        }
        catch (Exception e) {
            throw new HopException("Failed to load key store from " + resolvedKeyStoreFile + ". Check file path, password, and key store type (" + storeType + ").", (Throwable)e);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        char[] keyPass = Utils.isEmpty((CharSequence)this.keyPassword) ? resolvedKeyStorePassword.toCharArray() : Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(this.keyPassword)).toCharArray();
        kmf.init(keyStore, keyPass);
        return kmf.getKeyManagers();
    }

    private String resolve(String value) {
        if (value == null) {
            return null;
        }
        if (this.variables != null) {
            return this.variables.resolve(value);
        }
        return value;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public ClientBuilder getBuilder() {
        return this.builder;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getTestUrl() {
        return this.testUrl;
    }

    @Generated
    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    @Generated
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Generated
    public boolean isIgnoreSsl() {
        return this.ignoreSsl;
    }

    @Generated
    public String getAuthType() {
        return this.authType;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Generated
    public String getAuthorizationHeaderName() {
        return this.authorizationHeaderName;
    }

    @Generated
    public String getAuthorizationPrefix() {
        return this.authorizationPrefix;
    }

    @Generated
    public String getAuthorizationHeaderValue() {
        return this.authorizationHeaderValue;
    }

    @Generated
    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    @Generated
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Generated
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Generated
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Generated
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    @Generated
    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Generated
    public void setBuilder(ClientBuilder builder) {
        this.builder = builder;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setLog(ILogChannel log) {
        this.log = log;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setTestUrl(String testUrl) {
        this.testUrl = testUrl;
    }

    @Generated
    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    @Generated
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Generated
    public void setIgnoreSsl(boolean ignoreSsl) {
        this.ignoreSsl = ignoreSsl;
    }

    @Generated
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @Generated
    public void setAuthorizationHeaderName(String authorizationHeaderName) {
        this.authorizationHeaderName = authorizationHeaderName;
    }

    @Generated
    public void setAuthorizationPrefix(String authorizationPrefix) {
        this.authorizationPrefix = authorizationPrefix;
    }

    @Generated
    public void setAuthorizationHeaderValue(String authorizationHeaderValue) {
        this.authorizationHeaderValue = authorizationHeaderValue;
    }

    @Generated
    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    @Generated
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @Generated
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @Generated
    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    @Generated
    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }
}

