/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.io.aws2.options.S3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.AutoValue_S3FileSystemConfiguration;
import org.apache.beam.sdk.io.aws2.s3.SSECustomerKey;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@AutoValue
public abstract class S3FileSystemConfiguration {
    public static final @UnknownKeyFor @NonNull @Initialized int MINIMUM_UPLOAD_BUFFER_SIZE_BYTES = 0x500000;

    public abstract @UnknownKeyFor @NonNull @Initialized String getScheme();

    public abstract @UnknownKeyFor @NonNull @Initialized String getS3StorageClass();

    public abstract @UnknownKeyFor @NonNull @Initialized int getS3UploadBufferSizeBytes();

    public abstract @UnknownKeyFor @NonNull @Initialized int getS3ThreadPoolSize();

    public abstract @Nullable @UnknownKeyFor @Initialized String getSSEAlgorithm();

    public abstract @UnknownKeyFor @NonNull @Initialized SSECustomerKey getSSECustomerKey();

    public abstract @Nullable @UnknownKeyFor @Initialized String getSSEKMSKeyId();

    public abstract @UnknownKeyFor @NonNull @Initialized boolean getBucketKeyEnabled();

    public abstract @UnknownKeyFor @NonNull @Initialized S3ClientBuilder getS3ClientBuilder();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_S3FileSystemConfiguration.Builder();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public static @UnknownKeyFor @NonNull @Initialized Builder builderFrom(@UnknownKeyFor @NonNull @Initialized S3Options s3Options) {
        return S3FileSystemConfiguration.builder().setScheme("s3").setS3StorageClass(s3Options.getS3StorageClass()).setS3UploadBufferSizeBytes(s3Options.getS3UploadBufferSizeBytes()).setS3ThreadPoolSize(s3Options.getS3ThreadPoolSize()).setSSEAlgorithm(s3Options.getSSEAlgorithm()).setSSECustomerKey(s3Options.getSSECustomerKey()).setSSEKMSKeyId(s3Options.getSSEKMSKeyId()).setBucketKeyEnabled(s3Options.getBucketKeyEnabled()).setS3ClientBuilder(S3FileSystemConfiguration.getBuilder(s3Options));
    }

    public static @UnknownKeyFor @NonNull @Initialized S3FileSystemConfiguration fromS3Options(@UnknownKeyFor @NonNull @Initialized S3Options s3Options) {
        return S3FileSystemConfiguration.builderFrom(s3Options).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized S3ClientBuilder getBuilder(@UnknownKeyFor @NonNull @Initialized S3Options s3Options) {
        return ((S3ClientBuilderFactory)InstanceBuilder.ofType(S3ClientBuilderFactory.class).fromClass(s3Options.getS3ClientFactoryClass()).build()).createBuilder(s3Options);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setScheme(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setS3StorageClass(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setS3UploadBufferSizeBytes(@UnknownKeyFor @NonNull @Initialized int var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setS3ThreadPoolSize(@UnknownKeyFor @NonNull @Initialized int var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSSEAlgorithm(@Nullable @UnknownKeyFor @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSSECustomerKey(@UnknownKeyFor @NonNull @Initialized SSECustomerKey var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSSEKMSKeyId(@Nullable @UnknownKeyFor @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setBucketKeyEnabled(@UnknownKeyFor @NonNull @Initialized boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setS3ClientBuilder(@UnknownKeyFor @NonNull @Initialized S3ClientBuilder var1);

        public abstract @UnknownKeyFor @NonNull @Initialized S3FileSystemConfiguration build();
    }
}

