/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.errors.ErrorHandler;
import org.drools.compiler.builder.impl.errors.SrcErrorHandler;
import org.drools.compiler.kie.builder.impl.CompilationProblemAdapter;
import org.drools.core.util.ClassUtils;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.resources.MemoryResourceReader;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;

public class ProjectJavaCompiler {
    private final JavaCompiler compiler;

    public ProjectJavaCompiler(KnowledgeBuilderConfigurationImpl pkgConf) {
        this((JavaConfiguration)pkgConf.getDialectConfiguration("java"));
    }

    public ProjectJavaCompiler(JavaConfiguration configuration) {
        this.compiler = JavaCompilerFactory.loadCompiler((JavaConfiguration)configuration);
    }

    public List<KnowledgeBuilderResult> compileAll(ProjectClassLoader projectClassLoader, List<String> classList, MemoryResourceReader src) {
        ArrayList<KnowledgeBuilderResult> results = new ArrayList<KnowledgeBuilderResult>();
        if (classList.isEmpty()) {
            return results;
        }
        String[] classes = new String[classList.size()];
        classList.toArray(classes);
        CompilationResult result = this.compiler.compile(classes, (ResourceReader)src, (ResourceStore)new ProjectResourceStore(projectClassLoader), (ClassLoader)projectClassLoader);
        if (result.getErrors().length > 0) {
            HashMap<String, ErrorHandler> errorHandlerMap = new HashMap<String, ErrorHandler>();
            for (int i = 0; i < result.getErrors().length; ++i) {
                CompilationProblemAdapter err = new CompilationProblemAdapter(result.getErrors()[i]);
                ErrorHandler handler = (ErrorHandler)errorHandlerMap.get(err.getFileName());
                if (handler == null) {
                    handler = new SrcErrorHandler("Src compile error");
                    errorHandlerMap.put(err.getFileName(), handler);
                }
                handler.addError(err);
            }
            for (ErrorHandler handler : errorHandlerMap.values()) {
                if (!handler.isInError()) continue;
                results.add(handler.getError());
            }
        }
        return results;
    }

    private static class ProjectResourceStore
    implements ResourceStore {
        private final ProjectClassLoader projectClassLoader;

        private ProjectResourceStore(ProjectClassLoader projectClassLoader) {
            this.projectClassLoader = projectClassLoader;
        }

        public void write(String pResourceName, byte[] pResourceData) {
            this.projectClassLoader.defineClass(ClassUtils.convertResourceToClassName((String)pResourceName), pResourceName, pResourceData);
        }

        public void write(String resourceName, byte[] clazzData, boolean createFolder) {
            this.write(resourceName, clazzData);
        }

        public byte[] read(String pResourceName) {
            return this.projectClassLoader.getBytecode(pResourceName);
        }

        public void remove(String pResourceName) {
            throw new UnsupportedOperationException("org.drools.compiler.compiler.ProjectJavaCompiler.ProjectResourceStore.remove -> TODO");
        }
    }
}

