/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.neo4j.driver.RevocationCheckingStrategy;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.CertificateTool;

public class SecurityPlanImpl
implements SecurityPlan {
    private final boolean requiresEncryption;
    private final SSLContext sslContext;
    private final boolean requiresHostnameVerification;
    private final RevocationCheckingStrategy revocationCheckingStrategy;

    public static SecurityPlan forAllCertificates(boolean requiresHostnameVerification, RevocationCheckingStrategy revocationCheckingStrategy) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], new TrustManager[]{new TrustAllTrustManager()}, null);
        return new SecurityPlanImpl(true, sslContext, requiresHostnameVerification, revocationCheckingStrategy);
    }

    public static SecurityPlan forCustomCASignedCertificates(List<File> certFiles, boolean requiresHostnameVerification, RevocationCheckingStrategy revocationCheckingStrategy) throws GeneralSecurityException, IOException {
        SSLContext sslContext = SecurityPlanImpl.configureSSLContext(certFiles, revocationCheckingStrategy);
        return new SecurityPlanImpl(true, sslContext, requiresHostnameVerification, revocationCheckingStrategy);
    }

    public static SecurityPlan forSystemCASignedCertificates(boolean requiresHostnameVerification, RevocationCheckingStrategy revocationCheckingStrategy) throws GeneralSecurityException, IOException {
        SSLContext sslContext = SecurityPlanImpl.configureSSLContext(Collections.emptyList(), revocationCheckingStrategy);
        return new SecurityPlanImpl(true, sslContext, requiresHostnameVerification, revocationCheckingStrategy);
    }

    private static SSLContext configureSSLContext(List<File> customCertFiles, RevocationCheckingStrategy revocationCheckingStrategy) throws GeneralSecurityException, IOException {
        KeyStore trustedKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustedKeyStore.load(null, null);
        if (!customCertFiles.isEmpty()) {
            CertificateTool.loadX509Cert(customCertFiles, trustedKeyStore);
        } else {
            SecurityPlanImpl.loadSystemCertificates(trustedKeyStore);
        }
        PKIXBuilderParameters pkixBuilderParameters = SecurityPlanImpl.configurePKIXBuilderParameters(trustedKeyStore, revocationCheckingStrategy);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (pkixBuilderParameters == null) {
            trustManagerFactory.init(trustedKeyStore);
        } else {
            trustManagerFactory.init(new CertPathTrustManagerParameters(pkixBuilderParameters));
        }
        sslContext.init(new KeyManager[0], trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }

    private static PKIXBuilderParameters configurePKIXBuilderParameters(KeyStore trustedKeyStore, RevocationCheckingStrategy revocationCheckingStrategy) throws InvalidAlgorithmParameterException, KeyStoreException {
        PKIXBuilderParameters pkixBuilderParameters = null;
        if (RevocationCheckingStrategy.requiresRevocationChecking(revocationCheckingStrategy)) {
            pkixBuilderParameters = new PKIXBuilderParameters(trustedKeyStore, (CertSelector)new X509CertSelector());
            pkixBuilderParameters.setRevocationEnabled(true);
            System.setProperty("jdk.tls.client.enableStatusRequestExtension", "true");
            if (revocationCheckingStrategy.equals((Object)RevocationCheckingStrategy.VERIFY_IF_PRESENT)) {
                Security.setProperty("ocsp.enable", "true");
            }
        }
        return pkixBuilderParameters;
    }

    private static void loadSystemCertificates(KeyStore trustedKeyStore) throws GeneralSecurityException {
        TrustManagerFactory tempFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tempFactory.init((KeyStore)null);
        X509TrustManager x509TrustManager = Arrays.stream(tempFactory.getTrustManagers()).filter(trustManager -> trustManager instanceof X509TrustManager).findFirst().orElse(null);
        if (x509TrustManager == null) {
            throw new CertificateException("No system certificates found");
        }
        CertificateTool.loadX509Cert(x509TrustManager.getAcceptedIssuers(), trustedKeyStore);
    }

    public static SecurityPlan insecure() {
        return new SecurityPlanImpl(false, null, false, RevocationCheckingStrategy.NO_CHECKS);
    }

    private SecurityPlanImpl(boolean requiresEncryption, SSLContext sslContext, boolean requiresHostnameVerification, RevocationCheckingStrategy revocationCheckingStrategy) {
        this.requiresEncryption = requiresEncryption;
        this.sslContext = sslContext;
        this.requiresHostnameVerification = requiresHostnameVerification;
        this.revocationCheckingStrategy = revocationCheckingStrategy;
    }

    @Override
    public boolean requiresEncryption() {
        return this.requiresEncryption;
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public boolean requiresHostnameVerification() {
        return this.requiresHostnameVerification;
    }

    @Override
    public RevocationCheckingStrategy revocationCheckingStrategy() {
        return this.revocationCheckingStrategy;
    }

    private static class TrustAllTrustManager
    implements X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException("All client connections to this client are forbidden.");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

