/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.connection.DirectConnection;
import org.neo4j.driver.internal.messaging.request.MultiDatabaseUtil;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.SessionAuthUtil;

public class DirectConnectionProvider
implements ConnectionProvider {
    private final BoltServerAddress address;
    private final ConnectionPool connectionPool;

    DirectConnectionProvider(BoltServerAddress address, ConnectionPool connectionPool) {
        this.address = address;
        this.connectionPool = connectionPool;
    }

    @Override
    public CompletionStage<Connection> acquireConnection(ConnectionContext context) {
        CompletableFuture<DatabaseName> databaseNameFuture = context.databaseNameFuture();
        databaseNameFuture.complete(DatabaseNameUtil.defaultDatabase());
        return this.acquirePooledConnection(context.overrideAuthToken()).thenApply(connection -> new DirectConnection((Connection)connection, (DatabaseName)Futures.joinNowOrElseThrow(databaseNameFuture, ConnectionContext.PENDING_DATABASE_NAME_EXCEPTION_SUPPLIER), context.mode(), context.impersonatedUser()));
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.acquirePooledConnection(null).thenCompose(Connection::release);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionPool.close();
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb() {
        return this.detectFeature(MultiDatabaseUtil::supportsMultiDatabase);
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth() {
        return this.detectFeature(SessionAuthUtil::supportsSessionAuth);
    }

    private CompletionStage<Boolean> detectFeature(Function<Connection, Boolean> featureDetectionFunction) {
        return this.acquirePooledConnection(null).thenCompose(conn -> {
            boolean featureDetected = (Boolean)featureDetectionFunction.apply((Connection)conn);
            return conn.release().thenApply(ignored -> featureDetected);
        });
    }

    public BoltServerAddress getAddress() {
        return this.address;
    }

    private CompletionStage<Connection> acquirePooledConnection(AuthToken authToken) {
        return this.connectionPool.acquire(this.address, authToken);
    }
}

