/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.janino.function;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.util.Utils;
import org.apache.hop.pipeline.transforms.janino.function.FunctionDescription;
import org.apache.hop.pipeline.transforms.janino.function.FunctionExample;
import org.apache.hop.pipeline.transforms.janino.function.JaninoFunction;

public class FunctionLib {
    private List<FunctionDescription> functions = new ArrayList<FunctionDescription>();

    public FunctionLib() throws HopException {
        try {
            PluginRegistry registry = PluginRegistry.getInstance();
            IPlugin plugin = registry.getPlugin(TransformPluginType.class, "Janino");
            ClassLoader loader = registry.getClassLoader(plugin);
            Set<Class<?>> classes = this.findAllClassesUsingGoogleGuice(loader, "org.apache.hop.pipeline.transforms.janino");
            for (Class<?> clazz : classes) {
                Method[] methods;
                for (Method method : methods = clazz.getMethods()) {
                    JaninoFunction annotation = method.getAnnotation(JaninoFunction.class);
                    ArrayList<FunctionExample> functionExamples = new ArrayList<FunctionExample>();
                    if (annotation == null) continue;
                    if (!Utils.isEmpty((CharSequence)annotation.examples())) {
                        ObjectMapper mapper = new ObjectMapper();
                        JsonNode arrayNode = mapper.readTree(annotation.examples());
                        for (JsonNode jsonNode : arrayNode) {
                            functionExamples.add(new FunctionExample(jsonNode.get("expression").asText(), jsonNode.get("result").asText(), jsonNode.get("level").asText(), jsonNode.get("comment").asText()));
                        }
                    }
                    FunctionDescription functionDescription = new FunctionDescription(annotation.category(), annotation.name(), annotation.description(), annotation.syntax(), annotation.returns(), null, annotation.semantics(), clazz.getCanonicalName(), functionExamples);
                    this.functions.add(functionDescription);
                }
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public List<FunctionDescription> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<FunctionDescription> functions) {
        this.functions = functions;
    }

    public String[] getFunctionNames() {
        Object[] names = new String[this.functions.size()];
        for (int i = 0; i < this.functions.size(); ++i) {
            names[i] = this.functions.get(i).getName();
        }
        Arrays.sort(names);
        return names;
    }

    public String[] getImportPackages() {
        ArrayList<String> importPackages = new ArrayList<String>();
        for (FunctionDescription function : this.functions) {
            importPackages.add(function.getImportPackage());
        }
        importPackages.sort(Comparator.naturalOrder());
        return (String[])importPackages.stream().distinct().toArray(String[]::new);
    }

    public String[] getFunctionCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        for (FunctionDescription function : this.functions) {
            String category = function.getCategory();
            if (categories.contains(category)) continue;
            categories.add(category);
        }
        Collections.sort(categories);
        return categories.toArray(new String[categories.size()]);
    }

    public String[] getFunctionsForACategory(String category) {
        ArrayList<String> names = new ArrayList<String>();
        for (FunctionDescription function : this.functions) {
            if (!function.getCategory().equalsIgnoreCase(category)) continue;
            names.add(function.getName());
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    public FunctionDescription getFunctionDescription(String functionName) {
        for (FunctionDescription function : this.functions) {
            if (!function.getName().equalsIgnoreCase(functionName)) continue;
            return function;
        }
        return null;
    }

    public Set<Class<?>> findAllClassesUsingGoogleGuice(ClassLoader classLoader, String packageName) throws IOException {
        return ClassPath.from((ClassLoader)classLoader).getAllClasses().stream().filter(clazz -> clazz.getPackageName().contains(packageName)).map(ClassPath.ClassInfo::load).collect(Collectors.toSet());
    }
}

