/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopEofException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaPlugin;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.server.HttpUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@ValueMetaPlugin(id="20", name="Avro Record", description="This type wraps around an Avro Record", image="images/avro.svg")
public class ValueMetaAvroRecord
extends ValueMetaBase {
    private Schema schema;
    private static final String CONST_SCHEMA = "schema";
    private static final String CONST_SPECIFIED = " specified.";
    private static final String CONST_UNKNOWN_STORAGE_TYPE = " : Unknown storage type ";

    public ValueMetaAvroRecord() {
        super(null, 20);
    }

    public ValueMetaAvroRecord(String name) {
        super(name, 20);
    }

    public ValueMetaAvroRecord(String name, Schema schema) {
        super(name, 20);
        this.schema = schema;
    }

    public ValueMetaAvroRecord(ValueMetaAvroRecord meta) {
        super(meta.name, 20);
        if (meta.schema != null) {
            this.schema = new Schema.Parser().parse(meta.schema.toString());
        }
    }

    @Override
    public ValueMetaAvroRecord clone() {
        return new ValueMetaAvroRecord(this);
    }

    @Override
    public Object getNativeDataType(Object object) throws HopValueException {
        return this.getGenericRecord(object);
    }

    @Override
    public String toStringMeta() {
        if (this.schema == null) {
            return "Avro Generic Record";
        }
        return "Avro Generic Record " + this.schema.toString(false);
    }

    public GenericRecord getGenericRecord(Object object) throws HopValueException {
        switch (this.type) {
            case 20: {
                switch (this.storageType) {
                    case 0: {
                        break;
                    }
                    default: {
                        throw new HopValueException("Only normal storage type is supported for the Avro GenericRecord value : " + String.valueOf(this));
                    }
                }
                return (GenericRecord)object;
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        try {
                            String jsonString = (String)object;
                            return ValueMetaAvroRecord.convertStringToGenericRecord(jsonString);
                        }
                        catch (Exception e) {
                            throw new HopValueException("Error converting a JSON representation of an Avro GenericRecord to a native representation", e);
                        }
                    }
                }
                throw new HopValueException("Only normal storage type is supported for Avro GenericRecord value : " + String.valueOf(this));
            }
        }
        throw new HopValueException("Unable to convert data type " + String.valueOf(this) + " to an Avro GenericRecord value");
    }

    public static String convertGenericRecordToString(GenericRecord genericRecord) throws HopValueException {
        try {
            Schema schema = genericRecord.getSchema();
            String schemaJson = schema.toString();
            String dataJson = genericRecord.toString();
            return "{ \"schema\" : " + schemaJson + ", \"data\" : " + dataJson + " }";
        }
        catch (Exception e) {
            throw new HopValueException("Unable to convert an Avro record to a JSON String using the provided schema", e);
        }
    }

    public static GenericRecord convertStringToGenericRecord(String jsonString) throws HopValueException {
        try {
            JSONObject json = (JSONObject)new JSONParser().parse(jsonString);
            JSONObject schemaObject = (JSONObject)json.get((Object)CONST_SCHEMA);
            JSONObject dataObject = (JSONObject)json.get((Object)"data");
            Schema schema = new Schema.Parser().parse(schemaObject.toJSONString());
            JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(schema, dataObject.toJSONString());
            GenericDatumReader genericDatumReader = new GenericDatumReader(schema);
            return (GenericRecord)genericDatumReader.read(null, (Decoder)jsonDecoder);
        }
        catch (Exception e) {
            throw new HopValueException("Unable to convert a String to an Avro record", e);
        }
    }

    @Override
    public String getString(Object object) throws HopValueException {
        try {
            String string;
            switch (this.type) {
                case 2: {
                    string = switch (this.storageType) {
                        case 0 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield ValueMetaAvroRecord.convertGenericRecordToString((GenericRecord)object);
                        }
                        case 1 -> (String)this.convertBinaryStringToNativeType((byte[])object);
                        case 2 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield (String)this.index[(Integer)object];
                        }
                        default -> throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_STORAGE_TYPE + this.storageType + CONST_SPECIFIED);
                    };
                    if (string == null) break;
                    string = this.trim(string);
                    break;
                }
                case 3: {
                    throw new HopValueException("You can't convert a Date to an Avro GenericRecord data type for : " + String.valueOf(this));
                }
                case 1: {
                    throw new HopValueException("You can't convert a Number to an Avro GenericRecord data type for : " + String.valueOf(this));
                }
                case 5: {
                    throw new HopValueException("You can't convert an Integer to an Avro GenericRecord data type for : " + String.valueOf(this));
                }
                case 6: {
                    throw new HopValueException("You can't convert a BigNumber to an Avro GenericRecord data type for : " + String.valueOf(this));
                }
                case 4: {
                    throw new HopValueException("You can't convert a Boolean to an Avro GenericRecord data type for : " + String.valueOf(this));
                }
                case 8: {
                    string = switch (this.storageType) {
                        case 0 -> this.convertBinaryStringToString((byte[])object);
                        case 1 -> this.convertBinaryStringToString((byte[])object);
                        case 2 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield this.convertBinaryStringToString((byte[])this.index[(Integer)object]);
                        }
                        default -> throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_STORAGE_TYPE + this.storageType + CONST_SPECIFIED);
                    };
                    break;
                }
                case 7: {
                    string = switch (this.storageType) {
                        case 0 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield object.toString();
                        }
                        case 1 -> this.convertBinaryStringToString((byte[])object);
                        case 2 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield this.index[(Integer)object].toString();
                        }
                        default -> throw new HopValueException(String.valueOf(this) + CONST_UNKNOWN_STORAGE_TYPE + this.storageType + CONST_SPECIFIED);
                    };
                    break;
                }
                case 20: {
                    string = switch (this.storageType) {
                        case 0 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield object.toString();
                        }
                        default -> throw new HopValueException(String.valueOf(this) + " : Unsupported storage type " + this.getStorageTypeDesc() + " for " + String.valueOf(this));
                    };
                    break;
                }
                default: {
                    throw new HopValueException(String.valueOf(this) + " : Unknown type " + this.type + CONST_SPECIFIED);
                }
            }
            if (this.isOutputPaddingEnabled() && this.getLength() > 0) {
                string = ValueDataUtil.rightPad(string, this.getLength());
            }
            return string;
        }
        catch (ClassCastException e) {
            throw new HopValueException(String.valueOf(this) + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + String.valueOf(object) + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    @Override
    public Object cloneValueData(Object object) throws HopValueException {
        if (object == null) {
            return null;
        }
        GenericRecord genericRecord = this.getGenericRecord(object);
        Schema schema = genericRecord.getSchema();
        GenericData.Record copy = new GenericData.Record(schema);
        for (Schema.Field field : schema.getFields()) {
            Object v = genericRecord.get(field.name());
            copy.put(field.name(), v);
        }
        return copy;
    }

    @Override
    public Class<?> getNativeDataTypeClass() throws HopValueException {
        return GenericRecord.class;
    }

    @Override
    public void writeMeta(DataOutputStream outputStream) throws HopFileException {
        try {
            super.writeMeta(outputStream);
            if (this.schema == null) {
                outputStream.writeUTF("");
            } else {
                outputStream.writeUTF(this.schema.toString(false));
            }
        }
        catch (Exception e) {
            throw new HopFileException("Error writing Avro Record metadata", e);
        }
    }

    @Override
    public void readMetaData(DataInputStream inputStream) throws HopFileException {
        try {
            super.readMetaData(inputStream);
            String schemaJson = inputStream.readUTF();
            this.schema = StringUtils.isEmpty((String)schemaJson) ? null : new Schema.Parser().parse(schemaJson);
        }
        catch (Exception e) {
            throw new HopFileException("Error read Avro Record metadata", e);
        }
    }

    @Override
    public String getMetaXml() throws IOException {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag("value-meta"));
        xml.append(XmlHandler.addTagValue("type", this.getTypeDesc()));
        xml.append(XmlHandler.addTagValue("storagetype", ValueMetaAvroRecord.getStorageTypeCode(this.getStorageType())));
        if (this.schema != null) {
            xml.append(XmlHandler.addTagValue(CONST_SCHEMA, HttpUtil.encodeBase64ZippedString(this.schema.toString(false))));
        }
        xml.append(XmlHandler.closeTag("value-meta"));
        return super.getMetaXml();
    }

    @Override
    public void storeMetaInJson(JSONObject jValue) throws HopException {
        super.storeMetaInJson(jValue);
        try {
            if (this.schema != null) {
                String schemaJson = this.schema.toString(false);
                Object jSchema = new JSONParser().parse(schemaJson);
                jValue.put((Object)CONST_SCHEMA, jSchema);
            }
        }
        catch (Exception e) {
            throw new HopException("Error encoding Avro schema as JSON in value metadata of field " + this.name, e);
        }
    }

    @Override
    public void loadMetaFromJson(JSONObject jValue) {
        super.loadMetaFromJson(jValue);
        Object jSchema = jValue.get((Object)CONST_SCHEMA);
        if (jSchema != null) {
            String schemaJson = ((JSONObject)jSchema).toJSONString();
            this.schema = new Schema.Parser().parse(schemaJson);
        } else {
            this.schema = null;
        }
    }

    @Override
    public void writeData(DataOutputStream outputStream, Object object) throws HopFileException {
        try {
            outputStream.writeBoolean(object == null);
            if (object != null) {
                GenericRecord genericRecord = (GenericRecord)object;
                BinaryEncoder binaryEncoder = EncoderFactory.get().directBinaryEncoder((OutputStream)outputStream, null);
                GenericDatumWriter datumWriter = new GenericDatumWriter(genericRecord.getSchema());
                datumWriter.write((Object)genericRecord, (Encoder)binaryEncoder);
            }
        }
        catch (IOException e) {
            throw new HopFileException(String.valueOf(this) + " : Unable to write value data to output stream", e);
        }
    }

    @Override
    public Object readData(DataInputStream inputStream) throws HopFileException, SocketTimeoutException {
        try {
            if (inputStream.readBoolean()) {
                return null;
            }
            if (this.schema == null) {
                throw new HopFileException("An Avro schema is needed to read a GenericRecord from an input stream");
            }
            BinaryDecoder binaryDecoder = DecoderFactory.get().directBinaryDecoder((InputStream)inputStream, null);
            GenericDatumReader datumReader = new GenericDatumReader(this.schema);
            return datumReader.read(null, (Decoder)binaryDecoder);
        }
        catch (EOFException e) {
            throw new HopEofException(e);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HopFileException(String.valueOf(this) + " : Unable to read value data from input stream", e);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public String getComments() {
        if (StringUtils.isEmpty((String)this.comments) && this.schema != null) {
            return this.schema.toString(false);
        }
        return super.getComments();
    }

    @Override
    public Long getInteger(Object object) throws HopValueException {
        return super.getInteger(object);
    }
}

