/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.minio.messages.AccessControlList;
import io.minio.messages.Grant;
import io.minio.messages.Owner;
import io.minio.messages.Permission;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="AccessControlPolicy", strict=false)
@SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
public class AccessControlPolicy {
    @Element(name="Owner", required=false)
    private Owner owner;
    @Element(name="AccessControlList", required=false)
    private AccessControlList accessControlList;

    public AccessControlPolicy(@Element(name="Owner", required=false) Owner owner, @Element(name="AccessControlList", required=false) AccessControlList accessControlList) {
        this.owner = owner;
        this.accessControlList = accessControlList;
    }

    public Owner owner() {
        return this.owner;
    }

    public AccessControlList accessControlList() {
        return this.accessControlList;
    }

    public String cannedAcl() {
        if (this.accessControlList == null) {
            return "";
        }
        List<Grant> grants = this.accessControlList.grants();
        int size = grants.size();
        if (size < 1 || size > 3) {
            return "";
        }
        for (Grant grant : grants) {
            if (grant == null) continue;
            String uri = grant.granteeUri();
            if (grant.permission() == Permission.FULL_CONTROL && size == 1 && "".equals(uri)) {
                return "private";
            }
            if (grant.permission() == Permission.READ && size == 2) {
                if ("http://acs.amazonaws.com/groups/global/AuthenticatedUsers".equals(uri)) {
                    return "authenticated-read";
                }
                if ("http://acs.amazonaws.com/groups/global/AllUsers".equals(uri)) {
                    return "public-read";
                }
                if (this.owner.id() == null || grant.granteeId() == null || !this.owner.id().equals(grant.granteeId())) continue;
                return "bucket-owner-read";
            }
            if (grant.permission() != Permission.WRITE || size != 3 || !"http://acs.amazonaws.com/groups/global/AllUsers".equals(uri)) continue;
            return "public-read-write";
        }
        return "";
    }

    public Multimap<String, String> grantAcl() {
        HashMultimap map = null;
        if (this.accessControlList != null) {
            map = HashMultimap.create();
            for (Grant grant : this.accessControlList.grants()) {
                if (grant == null) continue;
                String value = "id=" + grant.granteeId();
                if (grant.permission() == Permission.READ) {
                    map.put((Object)"X-Amz-Grant-Read", (Object)value);
                    continue;
                }
                if (grant.permission() == Permission.WRITE) {
                    map.put((Object)"X-Amz-Grant-Write", (Object)value);
                    continue;
                }
                if (grant.permission() == Permission.READ_ACP) {
                    map.put((Object)"X-Amz-Grant-Read-Acp", (Object)value);
                    continue;
                }
                if (grant.permission() == Permission.WRITE_ACP) {
                    map.put((Object)"X-Amz-Grant-Write-Acp", (Object)value);
                    continue;
                }
                if (grant.permission() != Permission.FULL_CONTROL) continue;
                map.put((Object)"X-Amz-Grant-Full-Control", (Object)value);
            }
        }
        return map;
    }
}

