/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamcommon.GroupSummary;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class GroupsListResult {
    @Nonnull
    protected final List<GroupSummary> groups;
    @Nonnull
    protected final String cursor;
    protected final boolean hasMore;

    public GroupsListResult(@Nonnull List<GroupSummary> groups, @Nonnull String cursor, boolean hasMore) {
        if (groups == null) {
            throw new IllegalArgumentException("Required value for 'groups' is null");
        }
        for (GroupSummary x : groups) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'groups' is null");
        }
        this.groups = groups;
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    @Nonnull
    public List<GroupSummary> getGroups() {
        return this.groups;
    }

    @Nonnull
    public String getCursor() {
        return this.cursor;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groups, this.cursor, this.hasMore});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupsListResult other = (GroupsListResult)obj;
            return !(this.groups != other.groups && !this.groups.equals(other.groups) || this.cursor != other.cursor && !this.cursor.equals(other.cursor) || this.hasMore != other.hasMore);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GroupsListResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupsListResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("groups");
            StoneSerializers.list(GroupSummary.Serializer.INSTANCE).serialize(value.groups, g);
            g.writeFieldName("cursor");
            StoneSerializers.string().serialize(value.cursor, g);
            g.writeFieldName("has_more");
            StoneSerializers.boolean_().serialize((Boolean)value.hasMore, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GroupsListResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_hasMore;
            String f_cursor;
            List<GroupSummary> f_groups;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_groups = null;
                f_cursor = null;
                f_hasMore = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("groups".equals(field)) {
                        f_groups = StoneSerializers.list(GroupSummary.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("cursor".equals(field)) {
                        f_cursor = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("has_more".equals(field)) {
                        f_hasMore = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_groups == null) {
                    throw new JsonParseException(p, "Required field \"groups\" missing.");
                }
                if (f_cursor == null) {
                    throw new JsonParseException(p, "Required field \"cursor\" missing.");
                }
                if (f_hasMore == null) {
                    throw new JsonParseException(p, "Required field \"has_more\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupsListResult value = new GroupsListResult(f_groups, f_cursor, f_hasMore);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

