/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.runners.flink.translation.functions.AbstractFlinkCombineRunner;
import org.apache.beam.runners.flink.translation.functions.HashingFlinkCombineRunner;
import org.apache.beam.runners.flink.translation.functions.SortingFlinkCombineRunner;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.runners.flink.translation.wrappers.streaming.DoFnOperator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimap;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.util.Collector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class PartialReduceBundleOperator<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor AccumT>
extends DoFnOperator<KV<K, InputT>, KV<K, InputT>, KV<K, AccumT>> {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> combineFn;
    private @UnknownKeyFor @NonNull @Initialized Multimap<K, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> state;
    private transient @Nullable @UnknownKeyFor @Initialized ListState<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> checkpointedState;

    public PartialReduceBundleOperator(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> windowedInputCoder, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<K, AccumT>> mainOutputTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags, @UnknownKeyFor @NonNull @Initialized DoFnOperator.OutputManagerFactory<@UnknownKeyFor @NonNull @Initialized KV<K, AccumT>> outputManagerFactory, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputTagMapping, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        super(null, stepName, windowedInputCoder, Collections.emptyMap(), mainOutputTag, additionalOutputTags, outputManagerFactory, windowingStrategy, sideInputTagMapping, sideInputs, options, null, null, DoFnSchemaInformation.create(), Collections.emptyMap());
        this.combineFn = combineFn;
        this.state = ArrayListMultimap.create();
        this.checkpointedState = null;
    }

    @Override
    public void open() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.clearState();
        this.setBundleFinishedCallback(this::finishBundle);
        super.open();
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized boolean shoudBundleElements() {
        return true;
    }

    private void finishBundle() {
        try {
            AbstractFlinkCombineRunner reduceRunner = this.windowingStrategy.needsMerge() && this.windowingStrategy.getWindowFn() instanceof Sessions ? new SortingFlinkCombineRunner() : new HashingFlinkCombineRunner();
            for (Map.Entry e : this.state.asMap().entrySet()) {
                reduceRunner.combine(new AbstractFlinkCombineRunner.PartialFlinkCombiner(this.combineFn), this.windowingStrategy, this.sideInputReader, this.serializedOptions.get(), (Iterable)e.getValue(), new Collector<WindowedValue<KV<K, AccumT>>>(){

                    public void collect(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, AccumT>> record) {
                        PartialReduceBundleOperator.this.outputManager.output(PartialReduceBundleOperator.this.mainOutputTag, record);
                    }

                    public void close() {
                    }
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.clearState();
    }

    private void clearState() {
        this.state = ArrayListMultimap.create();
        if (this.checkpointedState != null) {
            this.checkpointedState.clear();
        }
    }

    @Override
    public void initializeState(@UnknownKeyFor @NonNull @Initialized StateInitializationContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        super.initializeState(context);
        ListStateDescriptor descriptor = new ListStateDescriptor("buffered-elements", new CoderTypeSerializer(this.windowedInputCoder, this.serializedOptions));
        this.checkpointedState = context.getOperatorStateStore().getListState(descriptor);
        if (context.isRestored() && this.checkpointedState != null) {
            for (WindowedValue wkv : (Iterable)this.checkpointedState.get()) {
                this.state.put(((KV)wkv.getValue()).getKey(), (Object)wkv);
            }
        }
    }

    @Override
    public void snapshotState(@UnknownKeyFor @NonNull @Initialized StateSnapshotContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        super.snapshotState(context);
        if (this.checkpointedState != null) {
            this.checkpointedState.update(new ArrayList(this.state.values()));
        }
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, @UnknownKeyFor @NonNull @Initialized KV<K, AccumT>> getDoFn() {
        return new DoFn<KV<K, InputT>, KV<K, AccumT>>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
                WindowedValue windowedValue = WindowedValues.of((Object)((KV)c.element()), (Instant)c.timestamp(), (BoundedWindow)window, (PaneInfo)c.pane());
                PartialReduceBundleOperator.this.state.put(Objects.requireNonNull((KV)c.element()).getKey(), (Object)windowedValue);
            }
        };
    }
}

