/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers;

import java.io.IOException;
import java.util.List;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.runners.flink.metrics.ReaderInvocationUtil;
import org.apache.beam.runners.flink.translation.wrappers.SourceInputSplit;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceInputFormat<@UnknownKeyFor T>
extends RichInputFormat<WindowedValue<T>, SourceInputSplit<T>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SourceInputFormat.class);
    private final @UnknownKeyFor @NonNull @Initialized String stepName;
    private final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> initialSource;
    private transient @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializedOptions;
    private transient // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> reader;
    private @UnknownKeyFor @NonNull @Initialized boolean inputAvailable = false;
    private transient @UnknownKeyFor @NonNull @Initialized ReaderInvocationUtil<T, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T>> readerInvoker;
    private transient @UnknownKeyFor @NonNull @Initialized FlinkMetricContainer metricContainer;

    public SourceInputFormat(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> initialSource, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.stepName = stepName;
        this.initialSource = initialSource;
        this.serializedOptions = new SerializablePipelineOptions(options);
    }

    public void configure(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
        this.options = this.serializedOptions.get();
    }

    public void open(@UnknownKeyFor @NonNull @Initialized SourceInputSplit<T> sourceInputSplit) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.metricContainer = new FlinkMetricContainer(this.getRuntimeContext());
        this.readerInvoker = new ReaderInvocationUtil(this.stepName, this.serializedOptions.get(), this.metricContainer);
        this.reader = ((BoundedSource)sourceInputSplit.getSource()).createReader(this.options);
        this.inputAvailable = this.readerInvoker.invokeStart(this.reader);
    }

    public @UnknownKeyFor @NonNull @Initialized BaseStatistics getStatistics(@UnknownKeyFor @NonNull @Initialized BaseStatistics baseStatistics) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            final long estimatedSize = this.initialSource.getEstimatedSizeBytes(this.options);
            return new BaseStatistics(){

                public @UnknownKeyFor @NonNull @Initialized long getTotalInputSize() {
                    return estimatedSize;
                }

                public @UnknownKeyFor @NonNull @Initialized long getNumberOfRecords() {
                    return -1L;
                }

                public @UnknownKeyFor @NonNull @Initialized float getAverageRecordWidth() {
                    return -1.0f;
                }
            };
        }
        catch (Exception e) {
            LOG.warn("Could not read Source statistics.", (Throwable)e);
            return null;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized long getDesiredSizeBytes(@UnknownKeyFor @NonNull @Initialized int numSplits) throws @UnknownKeyFor @NonNull @Initialized Exception {
        long totalSize = this.initialSource.getEstimatedSizeBytes(this.options);
        long defaultSplitSize = totalSize / (long)numSplits;
        long maxSplitSize = 0L;
        if (this.options != null) {
            maxSplitSize = ((FlinkPipelineOptions)this.options.as(FlinkPipelineOptions.class)).getFileInputSplitMaxSizeMB();
        }
        if (this.initialSource instanceof FileBasedSource && maxSplitSize > 0L) {
            return Math.min(defaultSplitSize, maxSplitSize * 1024L * 1024L);
        }
        return defaultSplitSize;
    }

    public @UnknownKeyFor @NonNull @Initialized SourceInputSplit<T> @UnknownKeyFor @NonNull @Initialized [] createInputSplits(@UnknownKeyFor @NonNull @Initialized int numSplits) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            long desiredSizeBytes = this.getDesiredSizeBytes(numSplits);
            List shards = this.initialSource.split(desiredSizeBytes, this.options);
            int numShards = shards.size();
            SourceInputSplit[] sourceInputSplits = new SourceInputSplit[numShards];
            for (int i = 0; i < numShards; ++i) {
                sourceInputSplits[i] = new SourceInputSplit((Source)shards.get(i), i);
            }
            return sourceInputSplits;
        }
        catch (Exception e) {
            throw new IOException("Could not create input splits from Source.", e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized InputSplitAssigner getInputSplitAssigner(@UnknownKeyFor @NonNull @Initialized SourceInputSplit @UnknownKeyFor @NonNull @Initialized [] sourceInputSplits) {
        return new DefaultInputSplitAssigner((InputSplit[])sourceInputSplits);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean reachedEnd() {
        return !this.inputAvailable;
    }

    public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> nextRecord(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> t) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.inputAvailable) {
            Object current = this.reader.getCurrent();
            Instant timestamp = this.reader.getCurrentTimestamp();
            this.inputAvailable = this.readerInvoker.invokeAdvance(this.reader);
            return WindowedValues.of((Object)current, (Instant)timestamp, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING);
        }
        return null;
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.metricContainer != null) {
            this.metricContainer.registerMetricsForPipelineResult();
        }
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

