/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.flink.translation.functions.AbstractFlinkCombineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.flink.util.Collector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class SortingFlinkCombineRunner<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
extends AbstractFlinkCombineRunner<K, InputT, AccumT, OutputT, W> {
    @Override
    public void combine(@UnknownKeyFor @NonNull @Initialized AbstractFlinkCombineRunner.FlinkCombiner<K, InputT, AccumT, OutputT> flinkCombiner, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Object, W> windowingStrategy, @UnknownKeyFor @NonNull @Initialized SideInputReader sideInputReader, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> elements, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>> out) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TimestampCombiner timestampCombiner = windowingStrategy.getTimestampCombiner();
        ArrayList sortedInput = Lists.newArrayList();
        for (WindowedValue<KV<K, InputT>> inputValue : elements) {
            for (WindowedValue exploded : inputValue.explodeWindows()) {
                sortedInput.add(exploded);
            }
        }
        sortedInput.sort(Comparator.comparing(o -> ((BoundedWindow)Iterables.getOnlyElement((Iterable)o.getWindows())).maxTimestamp()));
        if (windowingStrategy.needsMerge()) {
            this.mergeWindow(sortedInput);
        }
        Iterator iterator = sortedInput.iterator();
        WindowedValue currentValue = (WindowedValue)iterator.next();
        Object key = ((KV)currentValue.getValue()).getKey();
        BoundedWindow currentWindow = (BoundedWindow)Iterables.getOnlyElement((Iterable)currentValue.getWindows());
        Object firstValue = ((KV)currentValue.getValue()).getValue();
        AccumT accumulator = flinkCombiner.firstInput(key, firstValue, options, sideInputReader, currentValue.getWindows());
        Instant windowTimestamp = timestampCombiner.assign(currentWindow, currentValue.getTimestamp());
        while (iterator.hasNext()) {
            Object value;
            WindowedValue nextValue = (WindowedValue)iterator.next();
            BoundedWindow nextWindow = (BoundedWindow)Iterables.getOnlyElement((Iterable)nextValue.getWindows());
            if (currentWindow.equals(nextWindow)) {
                value = ((KV)nextValue.getValue()).getValue();
                accumulator = flinkCombiner.addInput(key, accumulator, value, options, sideInputReader, currentValue.getWindows());
                windowTimestamp = timestampCombiner.combine(new Instant[]{windowTimestamp, timestampCombiner.assign(currentWindow, nextValue.getTimestamp())});
                continue;
            }
            out.collect((Object)WindowedValues.of((Object)KV.of((Object)key, flinkCombiner.extractOutput(key, accumulator, options, sideInputReader, currentValue.getWindows())), (Instant)windowTimestamp, (BoundedWindow)currentWindow, (PaneInfo)PaneInfo.NO_FIRING));
            currentWindow = nextWindow;
            currentValue = nextValue;
            value = ((KV)nextValue.getValue()).getValue();
            accumulator = flinkCombiner.firstInput(key, value, options, sideInputReader, currentValue.getWindows());
            windowTimestamp = timestampCombiner.assign(currentWindow, nextValue.getTimestamp());
        }
        out.collect((Object)WindowedValues.of((Object)KV.of((Object)key, flinkCombiner.extractOutput(key, accumulator, options, sideInputReader, currentValue.getWindows())), (Instant)windowTimestamp, (BoundedWindow)currentWindow, (PaneInfo)PaneInfo.NO_FIRING));
    }

    private void mergeWindow(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> elements) {
        int currentStart = 0;
        IntervalWindow currentWindow = (IntervalWindow)Iterables.getOnlyElement((Iterable)elements.get(0).getWindows());
        for (int i = 1; i < elements.size(); ++i) {
            WindowedValue<KV<K, InputT>> nextValue = elements.get(i);
            IntervalWindow nextWindow = (IntervalWindow)Iterables.getOnlyElement((Iterable)nextValue.getWindows());
            if (currentWindow.intersects(nextWindow)) {
                currentWindow = currentWindow.span(nextWindow);
                continue;
            }
            for (int j = i - 1; j >= currentStart; --j) {
                WindowedValue<KV<K, InputT>> value = elements.get(j);
                elements.set(j, WindowedValues.of((Object)((KV)value.getValue()), (Instant)value.getTimestamp(), (BoundedWindow)currentWindow, (PaneInfo)value.getPaneInfo()));
            }
            currentStart = i;
            currentWindow = nextWindow;
        }
        if (currentStart < elements.size() - 1) {
            for (int j = elements.size() - 1; j >= currentStart; --j) {
                WindowedValue<KV<K, InputT>> value = elements.get(j);
                elements.set(j, WindowedValues.of((Object)((KV)value.getValue()), (Instant)value.getTimestamp(), (BoundedWindow)currentWindow, (PaneInfo)value.getPaneInfo()));
            }
        }
    }
}

