/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.groupby;

import java.util.Objects;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class Aggregation
implements Cloneable {
    private static final Class<?> PKG = Aggregation.class;
    public static final int TYPE_GROUP_NONE = 0;
    public static final int TYPE_GROUP_SUM = 1;
    public static final int TYPE_GROUP_AVERAGE = 2;
    public static final int TYPE_GROUP_MEDIAN = 3;
    public static final int TYPE_GROUP_PERCENTILE = 4;
    public static final int TYPE_GROUP_MIN = 5;
    public static final int TYPE_GROUP_MAX = 6;
    public static final int TYPE_GROUP_COUNT_ALL = 7;
    public static final int TYPE_GROUP_CONCAT_COMMA = 8;
    public static final int TYPE_GROUP_FIRST = 9;
    public static final int TYPE_GROUP_LAST = 10;
    public static final int TYPE_GROUP_FIRST_INCL_NULL = 11;
    public static final int TYPE_GROUP_LAST_INCL_NULL = 12;
    public static final int TYPE_GROUP_CUMULATIVE_SUM = 13;
    public static final int TYPE_GROUP_CUMULATIVE_AVERAGE = 14;
    public static final int TYPE_GROUP_STANDARD_DEVIATION = 15;
    public static final int TYPE_GROUP_CONCAT_STRING = 16;
    public static final int TYPE_GROUP_COUNT_DISTINCT = 17;
    public static final int TYPE_GROUP_COUNT_ANY = 18;
    public static final int TYPE_GROUP_STANDARD_DEVIATION_SAMPLE = 19;
    public static final int TYPE_GROUP_PERCENTILE_NEAREST_RANK = 20;
    public static final int TYPE_GROUP_CONCAT_STRING_CRLF = 21;
    public static final int TYPE_GROUP_CONCAT_DISTINCT = 22;
    public static final String[] typeGroupLabel = new String[]{"-", "SUM", "AVERAGE", "MEDIAN", "PERCENTILE", "MIN", "MAX", "COUNT_ALL", "CONCAT_COMMA", "FIRST", "LAST", "FIRST_INCL_NULL", "LAST_INCL_NULL", "CUM_SUM", "CUM_AVG", "STD_DEV", "CONCAT_STRING", "COUNT_DISTINCT", "COUNT_ANY", "STD_DEV_SAMPLE", "PERCENTILE_NEAREST_RANK", "CONCAT_STRING_CRLF", "CONCAT_DISTINCT"};
    public static final String[] typeGroupLongDesc = new String[]{"-", BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.SUM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.AVERAGE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.MEDIAN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.PERCENTILE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.MIN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.MAX", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_ALL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_COMMA", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.FIRST", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.LAST", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.FIRST_INCL_NULL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.LAST_INCL_NULL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CUMULATIVE_SUM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CUMULATIVE_AVERAGE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.STANDARD_DEVIATION", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_STRING", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.COUNT_DISTINCT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.COUNT_ANY", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.STANDARD_DEVIATION_SAMPLE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.PERCENTILE_NEAREST_RANK", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_STRING_CRLF", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_DISTINCT", (String[])new String[0])};
    @HopMetadataProperty(key="aggregate", injectionKey="AGG_FIELD", injectionKeyDescription="GroupByMeta.Injection.AGG_FIELD")
    private String field;
    @HopMetadataProperty(injectionKey="AGG_SUBJECT", injectionKeyDescription="GroupByMeta.Injection.AGG_SUBJECT")
    private String subject;
    @HopMetadataProperty(key="type", injectionKey="AGG_TYPE", injectionKeyDescription="GroupByMeta.Injection.AGG_TYPE")
    private String typeLabel;
    private int type;
    @HopMetadataProperty(key="valuefield", injectionKey="AGG_VALUE", injectionKeyDescription="GroupByMeta.Injection.AGG_VALUE")
    private String value;

    public Aggregation() {
    }

    public Aggregation(String field, String subject, String typeDesc, String value) {
        this.field = field;
        this.subject = subject;
        this.type = Aggregation.getTypeCodeFromLongDesc(typeDesc);
        this.typeLabel = Aggregation.getTypeLabelFromCode(this.type);
        this.value = value;
    }

    public Aggregation clone() {
        return new Aggregation(this.field, this.subject, Aggregation.getTypeDescLongFromCode(Aggregation.getTypeCodeFromLabel(this.typeLabel)), this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Aggregation that = (Aggregation)o;
        return this.type == that.type && Objects.equals(this.field, that.field) && Objects.equals(this.subject, that.subject) && Objects.equals(this.typeLabel, that.typeLabel) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.subject, this.typeLabel, this.type, this.value);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public void setTypeLabel(String typeCode) {
        this.typeLabel = typeCode;
        this.type = Aggregation.getTypeCodeFromLabel(typeCode);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static final int getTypeCodeFromLongDesc(String desc) {
        for (int i = 0; i < typeGroupLongDesc.length; ++i) {
            if (!typeGroupLongDesc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTypeCodeFromLabel(String label) {
        for (int i = 0; i < typeGroupLabel.length; ++i) {
            if (!typeGroupLabel[i].equalsIgnoreCase(label)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeLabelFromLongDesc(String desc) {
        int descPos = 0;
        for (int i = 0; i < typeGroupLongDesc.length; ++i) {
            if (!typeGroupLongDesc[i].equalsIgnoreCase(desc)) continue;
            descPos = i;
        }
        return typeGroupLabel[descPos];
    }

    public static final String getTypeLabelFromCode(int i) {
        if (i < 0 || i >= typeGroupLabel.length) {
            return null;
        }
        return typeGroupLabel[i];
    }

    public static final String getTypeDescLongFromCode(int i) {
        if (i < 0 || i >= typeGroupLongDesc.length) {
            return null;
        }
        return typeGroupLongDesc[i];
    }
}

