/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class TypeSerializerSnapshotSerializationUtil {
    public static <T> void writeSerializerSnapshot(DataOutputView out, TypeSerializerSnapshot<T> serializerSnapshot) throws IOException {
        new TypeSerializerSnapshotSerializationProxy<T>(serializerSnapshot).write(out);
    }

    public static <T> TypeSerializerSnapshot<T> readSerializerSnapshot(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        TypeSerializerSnapshotSerializationProxy proxy = new TypeSerializerSnapshotSerializationProxy(userCodeClassLoader);
        proxy.read(in);
        return proxy.getSerializerSnapshot();
    }

    public static <T> TypeSerializerSnapshot<T> readAndInstantiateSnapshotClass(DataInputView in, ClassLoader cl) throws IOException {
        Class<TypeSerializerSnapshot> clazz = InstantiationUtil.resolveClassByName(in, cl, TypeSerializerSnapshot.class);
        return InstantiationUtil.instantiate(clazz);
    }

    static final class TypeSerializerSnapshotSerializationProxy<T>
    extends VersionedIOReadableWritable {
        private static final int VERSION = 2;
        private ClassLoader userCodeClassLoader;
        private TypeSerializerSnapshot<T> serializerSnapshot;

        TypeSerializerSnapshotSerializationProxy(ClassLoader userCodeClassLoader) {
            this.userCodeClassLoader = Preconditions.checkNotNull(userCodeClassLoader);
        }

        TypeSerializerSnapshotSerializationProxy(TypeSerializerSnapshot<T> serializerConfigSnapshot) {
            this.serializerSnapshot = Preconditions.checkNotNull(serializerConfigSnapshot);
        }

        @Override
        public void write(DataOutputView out) throws IOException {
            super.write(out);
            TypeSerializerSnapshot.writeVersionedSnapshot(out, this.serializerSnapshot);
        }

        @Override
        public void read(DataInputView in) throws IOException {
            super.read(in);
            int version = this.getReadVersion();
            switch (version) {
                case 2: {
                    this.serializerSnapshot = TypeSerializerSnapshotSerializationProxy.deserializeV2(in, this.userCodeClassLoader);
                    break;
                }
                default: {
                    throw new IOException("Unrecognized version for TypeSerializerSnapshot format: " + version);
                }
            }
        }

        @Override
        public int getVersion() {
            return 2;
        }

        @Override
        public int[] getCompatibleVersions() {
            return new int[]{2};
        }

        @Override
        public Optional<String> getAdditionalDetailsForIncompatibleVersion(int readVersion) {
            if (readVersion == 1) {
                return Optional.of("As of Flink 1.17 TypeSerializerConfigSnapshot is no longer supported. In order to upgrade Flink to 1.17+ you need to first migrate your serializers to use TypeSerializerSnapshot instead. Please first take a savepoint in Flink 1.16 without using TypeSerializerConfigSnapshot. After that you can use this savepoint to upgrade to Flink 1.17.");
            }
            return Optional.empty();
        }

        TypeSerializerSnapshot<T> getSerializerSnapshot() {
            return this.serializerSnapshot;
        }

        @VisibleForTesting
        static <T> TypeSerializerSnapshot<T> deserializeV2(DataInputView in, ClassLoader cl) throws IOException {
            return TypeSerializerSnapshot.readVersionedSnapshot(in, cl);
        }
    }
}

