/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.control.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IntelligenceConfigName
implements ResourceName {
    private static final PathTemplate FOLDER_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/intelligenceConfig");
    private static final PathTemplate ORG_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{org}/locations/{location}/intelligenceConfig");
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/intelligenceConfig");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String folder;
    private final String location;
    private final String org;
    private final String project;

    @Deprecated
    protected IntelligenceConfigName() {
        this.folder = null;
        this.location = null;
        this.org = null;
        this.project = null;
    }

    private IntelligenceConfigName(Builder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.org = null;
        this.project = null;
        this.pathTemplate = FOLDER_LOCATION;
    }

    private IntelligenceConfigName(OrgLocationBuilder builder) {
        this.org = (String)Preconditions.checkNotNull((Object)builder.getOrg());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORG_LOCATION;
    }

    private IntelligenceConfigName(ProjectLocationBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.folder = null;
        this.org = null;
        this.pathTemplate = PROJECT_LOCATION;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrg() {
        return this.org;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newFolderLocationBuilder() {
        return new Builder();
    }

    public static OrgLocationBuilder newOrgLocationBuilder() {
        return new OrgLocationBuilder();
    }

    public static ProjectLocationBuilder newProjectLocationBuilder() {
        return new ProjectLocationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IntelligenceConfigName of(String folder, String location) {
        return IntelligenceConfigName.newBuilder().setFolder(folder).setLocation(location).build();
    }

    public static IntelligenceConfigName ofFolderLocationName(String folder, String location) {
        return IntelligenceConfigName.newBuilder().setFolder(folder).setLocation(location).build();
    }

    public static IntelligenceConfigName ofOrgLocationName(String org, String location) {
        return IntelligenceConfigName.newOrgLocationBuilder().setOrg(org).setLocation(location).build();
    }

    public static IntelligenceConfigName ofProjectLocationName(String project, String location) {
        return IntelligenceConfigName.newProjectLocationBuilder().setProject(project).setLocation(location).build();
    }

    public static String format(String folder, String location) {
        return IntelligenceConfigName.newBuilder().setFolder(folder).setLocation(location).build().toString();
    }

    public static String formatFolderLocationName(String folder, String location) {
        return IntelligenceConfigName.newBuilder().setFolder(folder).setLocation(location).build().toString();
    }

    public static String formatOrgLocationName(String org, String location) {
        return IntelligenceConfigName.newOrgLocationBuilder().setOrg(org).setLocation(location).build().toString();
    }

    public static String formatProjectLocationName(String project, String location) {
        return IntelligenceConfigName.newProjectLocationBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static IntelligenceConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (FOLDER_LOCATION.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION.match(formattedString);
            return IntelligenceConfigName.ofFolderLocationName((String)matchMap.get("folder"), (String)matchMap.get("location"));
        }
        if (ORG_LOCATION.matches(formattedString)) {
            Map matchMap = ORG_LOCATION.match(formattedString);
            return IntelligenceConfigName.ofOrgLocationName((String)matchMap.get("org"), (String)matchMap.get("location"));
        }
        if (PROJECT_LOCATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION.match(formattedString);
            return IntelligenceConfigName.ofProjectLocationName((String)matchMap.get("project"), (String)matchMap.get("location"));
        }
        throw new ValidationException("IntelligenceConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<IntelligenceConfigName> parseList(List<String> formattedStrings) {
        ArrayList<IntelligenceConfigName> list = new ArrayList<IntelligenceConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IntelligenceConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IntelligenceConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IntelligenceConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return FOLDER_LOCATION.matches(formattedString) || ORG_LOCATION.matches(formattedString) || PROJECT_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IntelligenceConfigName intelligenceConfigName = this;
            synchronized (intelligenceConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.org != null) {
                        fieldMapBuilder.put((Object)"org", (Object)this.org);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            IntelligenceConfigName that = (IntelligenceConfigName)o;
            return Objects.equals(this.folder, that.folder) && Objects.equals(this.location, that.location) && Objects.equals(this.org, that.org) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.org);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectLocationBuilder {
        private String project;
        private String location;

        protected ProjectLocationBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public ProjectLocationBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public IntelligenceConfigName build() {
            return new IntelligenceConfigName(this);
        }
    }

    public static class OrgLocationBuilder {
        private String org;
        private String location;

        protected OrgLocationBuilder() {
        }

        public String getOrg() {
            return this.org;
        }

        public String getLocation() {
            return this.location;
        }

        public OrgLocationBuilder setOrg(String org) {
            this.org = org;
            return this;
        }

        public OrgLocationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public IntelligenceConfigName build() {
            return new IntelligenceConfigName(this);
        }
    }

    public static class Builder {
        private String folder;
        private String location;

        protected Builder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(IntelligenceConfigName intelligenceConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(intelligenceConfigName.pathTemplate, FOLDER_LOCATION), (Object)"toBuilder is only supported when IntelligenceConfigName has the pattern of folders/{folder}/locations/{location}/intelligenceConfig");
            this.folder = intelligenceConfigName.folder;
            this.location = intelligenceConfigName.location;
        }

        public IntelligenceConfigName build() {
            return new IntelligenceConfigName(this);
        }
    }
}

