/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.collections;

import java.util.Map;
import org.multiverse.api.Stm;
import org.multiverse.api.Txn;
import org.multiverse.api.collections.TxnCollection;
import org.multiverse.api.collections.TxnSet;
import org.multiverse.api.exceptions.TodoException;
import org.multiverse.api.references.TxnInteger;
import org.multiverse.api.references.TxnRef;
import org.multiverse.collections.AbstractTxnMap;

public final class NaiveTxnHashMap<K, V>
extends AbstractTxnMap<K, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    private final TxnInteger size;
    private final TxnRef<TxnRef<NaiveEntry>[]> table;
    private final TxnInteger threshold;
    final float loadFactor;

    public NaiveTxnHashMap(Stm stm) {
        super(stm);
        this.size = this.defaultRefFactory.newTxnInteger(0);
        this.threshold = this.defaultRefFactory.newTxnInteger(12);
        this.loadFactor = 0.75f;
        TxnRef[] entries = new TxnRef[16];
        for (int k = 0; k < entries.length; ++k) {
            entries[k] = this.defaultRefFactory.newTxnRef(null);
        }
        this.table = this.defaultRefFactory.newTxnRef(entries);
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    @Override
    public void clear(Txn tx) {
        if (this.size.get(tx) == 0) {
            return;
        }
        TxnRef<NaiveEntry>[] tab = this.table.get();
        for (int i = 0; i < tab.length; ++i) {
            tab[i].set(null);
        }
        this.size.set(0);
    }

    @Override
    public int size(Txn tx) {
        return this.size.get(tx);
    }

    @Override
    public V get(Txn tx, Object key) {
        NaiveEntry<K, V> entry = this.getEntry(tx, key);
        return entry == null ? null : (V)entry.value.get(tx);
    }

    private NaiveEntry<K, V> getEntry(Txn tx, Object key) {
        if (key == null) {
            return null;
        }
        if (this.size.get(tx) == 0) {
            return null;
        }
        int hash = key.hashCode();
        NaiveEntry entry = this.table.get(tx)[NaiveTxnHashMap.indexFor(hash, this.table.get(tx).length)].get(tx);
        while (entry != null) {
            Object k;
            if (entry.hash == hash && ((k = entry.key) == key || key.equals(k))) {
                return entry;
            }
            entry = entry.next.get(tx);
        }
        return null;
    }

    @Override
    public V put(Txn tx, K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        int hash = key.hashCode();
        int i = NaiveTxnHashMap.indexFor(hash, this.table.get(tx).length);
        NaiveEntry entry = this.table.get(tx)[i].get(tx);
        while (entry != null) {
            Object foundKey;
            if (entry.hash == hash && ((foundKey = entry.key) == key || key.equals(foundKey))) {
                Object oldValue = entry.value.get(tx);
                entry.value.set(tx, value);
                return oldValue;
            }
            entry = entry.next.get();
        }
        this.addEntry(tx, hash, key, value, i);
        return null;
    }

    void addEntry(Txn tx, int hash, K key, V value, int bucketIndex) {
        NaiveEntry e = this.table.get(tx)[bucketIndex].get(tx);
        this.table.get(tx)[bucketIndex].set(new NaiveEntry<K, V>(hash, key, value, e));
        this.size.increment(tx);
        if (this.size.get(tx) >= this.threshold.get(tx)) {
            this.resize(tx, 2 * this.table.get(tx).length);
        }
    }

    void resize(Txn tx, int newCapacity) {
        TxnRef<NaiveEntry>[] oldTable = this.table.get(tx);
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold.set(Integer.MAX_VALUE);
            return;
        }
        TxnRef[] newTable = new TxnRef[newCapacity];
        for (int k = 0; k < newTable.length; ++k) {
            newTable[k] = this.defaultRefFactory.newTxnRef(null);
        }
        this.transfer(tx, newTable);
        this.table.set(tx, newTable);
        this.threshold.set(tx, (int)((float)newCapacity * this.loadFactor));
    }

    void transfer(Txn tx, TxnRef<NaiveEntry>[] newTable) {
        TxnRef<NaiveEntry>[] src = this.table.get(tx);
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            NaiveEntry next;
            NaiveEntry e = src[j].get(tx);
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next.get(tx);
                int i = NaiveTxnHashMap.indexFor(e.hash, newCapacity);
                e.next.set(tx, newTable[i].get(tx));
                newTable[i].set(tx, e);
            } while ((e = next) != null);
        }
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public V remove(Txn tx, Object key) {
        throw new TodoException();
    }

    @Override
    public String toString(Txn tx) {
        int s = this.size.get(tx);
        if (s == 0) {
            return "[]";
        }
        throw new TodoException();
    }

    @Override
    public TxnSet<Map.Entry<K, V>> entrySet(Txn tx) {
        throw new TodoException();
    }

    @Override
    public TxnSet<K> keySet(Txn tx) {
        throw new TodoException();
    }

    @Override
    public boolean containsKey(Txn tx, Object key) {
        return this.getEntry(tx, key) != null;
    }

    @Override
    public boolean containsValue(Txn tx, Object value) {
        throw new TodoException();
    }

    @Override
    public TxnCollection<V> values(Txn tx) {
        throw new TodoException();
    }

    private class NaiveEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        final int hash;
        final TxnRef<V> value;
        final TxnRef<NaiveEntry<K, V>> next;

        NaiveEntry(int hash, K key, V value, NaiveEntry<K, V> next) {
            this.value = NaiveTxnHashMap.this.defaultRefFactory.newTxnRef(value);
            this.next = NaiveTxnHashMap.this.defaultRefFactory.newTxnRef(next);
            this.key = key;
            this.hash = hash;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value.get();
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value.get();
            this.value.set(newValue);
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            V v = this.value.get();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

