/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.grpc;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import io.micrometer.core.instrument.binder.grpc.GrpcServerObservationContext;
import io.micrometer.core.instrument.binder.grpc.GrpcServerObservationConvention;

public class DefaultGrpcServerObservationConvention
implements GrpcServerObservationConvention {
    private static final KeyValue STATUS_CODE_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.STATUS_CODE.withValue("UNKNOWN");
    private static final KeyValue PEER_NAME_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_NAME.withValue("UNKNOWN");
    private static final KeyValue PEER_PORT_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_PORT.withValue("UNKNOWN");
    private static final KeyValue METHOD_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.METHOD.withValue("UNKNOWN");
    private static final KeyValue SERVICE_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.SERVICE.withValue("UNKNOWN");

    public String getName() {
        return "grpc.server";
    }

    public String getContextualName(GrpcServerObservationContext context) {
        return context.getFullMethodName();
    }

    public KeyValues getLowCardinalityKeyValues(GrpcServerObservationContext context) {
        KeyValue statusCodeKeyValue = context.getStatusCode() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.STATUS_CODE.withValue(context.getStatusCode().name()) : STATUS_CODE_UNKNOWN;
        KeyValue peerNameKeyValue = context.getPeerName() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_NAME.withValue(context.getPeerName()) : PEER_NAME_UNKNOWN;
        KeyValue peerPortKeyValue = context.getPeerPort() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_PORT.withValue(context.getPeerPort().toString()) : PEER_PORT_UNKNOWN;
        KeyValue method = context.getMethodName() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.METHOD.withValue(context.getMethodName()) : METHOD_UNKNOWN;
        KeyValue service = context.getServiceName() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.SERVICE.withValue(context.getServiceName()) : SERVICE_UNKNOWN;
        return KeyValues.of((KeyValue[])new KeyValue[]{statusCodeKeyValue, peerNameKeyValue, peerPortKeyValue, method, service, GrpcObservationDocumentation.LowCardinalityKeyNames.METHOD_TYPE.withValue(context.getMethodType().name())});
    }
}

