/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class GraphStepPlaceholder<S, E extends Element>
extends AbstractStep<S, E>
implements GValueHolder<S, E>,
GraphStepContract<S, E> {
    protected final Class<E> returnClass;
    protected GValue<?>[] ids;
    private final boolean isStart;
    private boolean onGraphComputer = false;

    public GraphStepPlaceholder(Traversal.Admin traversal, Class<E> returnClass, boolean isStart, GValue<?> ... ids) {
        super(traversal);
        this.returnClass = returnClass;
        this.ids = ids;
        this.isStart = isStart;
        for (GValue<?> id : ids) {
            traversal.getGValueManager().register(id);
        }
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids));
    }

    @Override
    public void close() {
    }

    @Override
    public Class<E> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public boolean isStartStep() {
        return this.isStart;
    }

    @Override
    public boolean returnsVertex() {
        return this.returnClass.equals(Vertex.class);
    }

    @Override
    public boolean returnsEdge() {
        return this.returnClass.equals(Edge.class);
    }

    @Override
    public Object[] getIds() {
        for (GValue<?> id : this.ids) {
            if (!id.isVariable()) continue;
            this.traversal.getGValueManager().pinVariable(id.getName());
        }
        return GValue.resolveToValues(this.ids);
    }

    @Override
    public GValue<?>[] getIdsAsGValues() {
        return (GValue[])this.ids.clone();
    }

    @Override
    public void clearIds() {
        this.ids = new GValue[0];
    }

    @Override
    public void onGraphComputer() {
        this.onGraphComputer = true;
    }

    @Override
    protected Traverser.Admin<E> processNextStart() {
        throw new IllegalStateException("GraphStepGValueContract is not executable");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GraphStepPlaceholder that = (GraphStepPlaceholder)o;
        return this.isStart == that.isStart && this.onGraphComputer == that.onGraphComputer && Objects.equals(this.returnClass, that.returnClass) && Objects.deepEquals(this.ids, that.ids);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.returnClass, Arrays.hashCode(this.ids), this.isStart, this.onGraphComputer);
    }

    @Override
    public GraphStep<S, E> asConcreteStep() {
        GraphStep step = new GraphStep(this.traversal, this.returnClass, this.isStart, GValue.resolveToValues(this.ids));
        if (this.onGraphComputer) {
            step.onGraphComputer();
        }
        TraversalHelper.copyLabels(this, step, false);
        return step;
    }

    @Override
    public boolean isParameterized() {
        for (GValue<?> id : this.ids) {
            if (!id.isVariable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateVariable(String name, Object value) {
        for (int i = 0; i < this.ids.length; ++i) {
            if (!name.equals(this.ids[i].getName())) continue;
            this.ids[i] = GValue.of(name, value);
        }
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        HashSet gValues = new HashSet();
        for (GValue<?> id : this.ids) {
            if (!id.isVariable()) continue;
            gValues.add(id);
        }
        return gValues;
    }

    @Override
    public GraphStepPlaceholder<S, E> clone() {
        GraphStepPlaceholder clone = (GraphStepPlaceholder)super.clone();
        clone.onGraphComputer = this.onGraphComputer;
        clone.ids = new GValue[this.ids.length];
        for (int i = 0; i < this.ids.length; ++i) {
            clone.ids[i] = this.ids[i].clone();
        }
        return clone;
    }
}

