/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.multitenancy;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantsManager;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.io.WatcherService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;

public class DefaultTenantsManager
implements TenantsManager,
DisposableBean {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private final Resource jsonResource;
    private WatcherService watcherService;
    private final List<TenantDefinition> tenantDefinitionList = new ArrayList<TenantDefinition>();

    public DefaultTenantsManager() {
        this(null);
    }

    public DefaultTenantsManager(Resource resource) {
        this.jsonResource = resource;
        this.tenantDefinitionList.addAll(this.readFromJsonResource());
        this.initializeWatchService();
    }

    private void initializeWatchService() {
        FunctionUtils.doAndHandle(__ -> {
            if (ResourceUtils.isFile((Resource)this.jsonResource)) {
                this.watcherService = new FileWatcherService(this.jsonResource.getFile(), file -> {
                    List<TenantDefinition> resources = this.readFromJsonResource();
                    if (!resources.isEmpty()) {
                        this.tenantDefinitionList.clear();
                        this.tenantDefinitionList.addAll(resources);
                    }
                });
                this.watcherService.start(this.getClass().getSimpleName());
            }
        });
    }

    public void destroy() {
        FunctionUtils.doIfNotNull((Object)this.watcherService, WatcherService::close);
    }

    public Optional<TenantDefinition> findTenant(String tenantId) {
        return this.tenantDefinitionList.stream().filter(t -> t.getId().equalsIgnoreCase(tenantId)).findFirst();
    }

    public List<TenantDefinition> findTenants() {
        return List.copyOf(this.tenantDefinitionList);
    }

    private List<TenantDefinition> readFromJsonResource() {
        return (List)FunctionUtils.doAndHandle(() -> {
            if (ResourceUtils.doesResourceExist((Resource)this.jsonResource)) {
                try (InputStreamReader reader = new InputStreamReader(this.jsonResource.getInputStream(), StandardCharsets.UTF_8);){
                    TypeReference<List<TenantDefinition>> tenantsList = new TypeReference<List<TenantDefinition>>(this){};
                    List list = (List)MAPPER.readValue(JsonValue.readHjson((Reader)reader).toString(), (TypeReference)tenantsList);
                    return list;
                }
            }
            return new ArrayList();
        }, throwable -> new ArrayList()).get();
    }
}

