/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.controller.ZkPartitionStateMachine;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\re\u0001B\u001b7\u0001mBQA\u0011\u0001\u0005\u0002\rC\u0011B\u0012\u0001A\u0002\u0003\u0007I\u0011B$\t\u0013-\u0003\u0001\u0019!a\u0001\n\u0013a\u0005\"\u0003*\u0001\u0001\u0004\u0005\t\u0015)\u0003I\u0011%\u0019\u0006\u00011AA\u0002\u0013%A\u000bC\u0005\\\u0001\u0001\u0007\t\u0019!C\u00059\"Ia\f\u0001a\u0001\u0002\u0003\u0006K!\u0016\u0005\n?\u0002\u0001\r\u00111A\u0005\n\u0001D\u0011\u0002\u001a\u0001A\u0002\u0003\u0007I\u0011B3\t\u0013\u001d\u0004\u0001\u0019!A!B\u0013\t\u0007\"\u00035\u0001\u0001\u0004\u0005\r\u0011\"\u0003j\u0011%i\u0007\u00011AA\u0002\u0013%a\u000eC\u0005q\u0001\u0001\u0007\t\u0011)Q\u0005U\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002<\u0001A\u0003%1\u000fC\u0004x\u0001\t\u0007I\u0011\u0002=\t\r}\u0004\u0001\u0015!\u0003z\u0011!\t\t\u0001\u0001b\u0001\n\u0013\u0011\bbBA\u0002\u0001\u0001\u0006Ia\u001d\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"a\b\u0001A\u0003%\u0011\u0011\u0002\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003GA\u0001\"!\u000e\u0001A\u0003%\u0011Q\u0005\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!!\u0018\u0001\t\u0003\tI\u0004C\u0004\u0002h\u0001!\t!!\u000f\t\u000f\u0005-\u0004\u0001\"\u0001\u0002:!9\u0011q\u000e\u0001\u0005\u0002\u0005e\u0002bBA:\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003o\u0002A\u0011AA\u001d\u0011\u001d\tY\b\u0001C\u0001\u0003sAq!a \u0001\t\u0003\tI\u0004C\u0004\u0002\u0004\u0002!\t!!\u000f\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002:!9\u00111\u0012\u0001\u0005\u0002\u0005e\u0002bBAH\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003'\u0003A\u0011AA\u001d\u0011\u001d\t9\n\u0001C\u0001\u0003sAq!a'\u0001\t\u0003\ti\nC\u0004\u0002N\u0002!\t!!\u000f\t\u000f\u0005E\u0007\u0001\"\u0001\u0002:!9\u0011Q\u001b\u0001\u0005\u0002\u0005e\u0002bBAm\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\tI\u0010\u0001C\u0001\u0003sAq!!@\u0001\t\u0003\tI\u0004C\u0004\u0003\u0002\u0001!\t!!\u000f\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!9!Q\u0003\u0001\u0005\n\t]\u0001\"\u0003B3\u0001E\u0005I\u0011\u0002B4\u0011%\u0011i\bAI\u0001\n\u0013\u0011yHA\rQCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3UKN$(BA\u001c9\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002s\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001=!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0012\t\u0003\u000b\u0002i\u0011AN\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001%\u0011\u0005\u0015K\u0015B\u0001&7\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\u0016G>tGO]8mY\u0016\u00148i\u001c8uKb$x\fJ3r)\ti\u0005\u000b\u0005\u0002>\u001d&\u0011qJ\u0010\u0002\u0005+:LG\u000fC\u0004R\u0007\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0013'\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0013\u0001D7pG.T6n\u00117jK:$X#A+\u0011\u0005YKV\"A,\u000b\u0005aC\u0014A\u0001>l\u0013\tQvKA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0011[>\u001c7NW6DY&,g\u000e^0%KF$\"!T/\t\u000fE3\u0011\u0011!a\u0001+\u0006iQn\\2l5.\u001cE.[3oi\u0002\n\u0001%\\8dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQV\t\u0011\r\u0005\u0002FE&\u00111M\u000e\u0002\u001d\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i\u0003\u0011jwnY6D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195`I\u0015\fHCA'g\u0011\u001d\t\u0016\"!AA\u0002\u0005\f\u0011%\\8dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0002\nQ\u0003]1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW-F\u0001k!\t)5.\u0003\u0002mm\t)\u0002+\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0017!\u00079beRLG/[8o'R\fG/Z'bG\"Lg.Z0%KF$\"!T8\t\u000fEc\u0011\u0011!a\u0001U\u00061\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0007%\u0001\u0005ce>\\WM]%e+\u0005\u0019\bCA\u001fu\u0013\t)hHA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\r\r|gNZ5h+\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?9\u0003\u0019\u0019XM\u001d<fe&\u0011ap\u001f\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"\f\u0001cY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0011\u0002\u0013A\f'\u000f^5uS>tWCAA\u0005!\u0011\tY!a\u0007\u000e\u0005\u00055!\u0002BA\b\u0003#\taaY8n[>t'bA\u001d\u0002\u0014)!\u0011QCA\f\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011D\u0001\u0004_J<\u0017\u0002BA\u000f\u0003\u001b\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\n!\u0002]1si&$\u0018n\u001c8t+\t\t)\u0003\u0005\u0004\u0002(\u0005E\u0012\u0011B\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003_q\u0014AC2pY2,7\r^5p]&!\u00111GA\u0015\u0005\r\u0019V-]\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b%A\u0003tKR,\u0006\u000fF\u0001NQ\rA\u0012Q\b\t\u0005\u0003\u007f\ti%\u0004\u0002\u0002B)!\u00111IA#\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u000f\nI%A\u0004kkBLG/\u001a:\u000b\t\u0005-\u0013qC\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u001f\n\tE\u0001\u0006CK\u001a|'/Z#bG\"\fa\u0002]1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003\u0002V\u0005m\u0003cA#\u0002X%\u0019\u0011\u0011\f\u001c\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK\"9\u0011QA\rA\u0002\u0005%\u0011\u0001\r;fgRtuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R{g*Z<QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002\u001b\u0003C\u0002B!a\u0010\u0002d%!\u0011QMA!\u0005\u0011!Vm\u001d;\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t\u0007fA\u000e\u0002b\u0005YD/Z:u\u0013:4\u0018\r\\5e\u001d>tW\r_5ti\u0016tG\u000fU1si&$\u0018n\u001c8U_>3g\r\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007q\t\t'A\u0016uKN$h*Z<QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\ri\u0012\u0011M\u0001Ti\u0016\u001cHOT3x!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]j{wnS3fa\u0016\u00148\t\\5f]R,\u0005pY3qi&|gN\u0012:p[\u000e\u0013X-\u0019;f'R\fG/Z:)\u0007y\t\t'\u0001#uKN$h*Z<QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8o\u000bJ\u0014xN]\"pI\u00164%o\\7De\u0016\fG/Z*uCR,7\u000fK\u0002 \u0003C\nA\u0006^3ti:+w\u000fU1si&$\u0018n\u001c8U_>3g\r\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007\u0001\n\t'A\u001cuKN$\u0018J\u001c<bY&$g*Z<QCJ$\u0018\u000e^5p]R{gj\u001c8fq&\u001cH/\u001a8u!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004C\u0005\u0005\u0014!\n;fgR|e\u000e\\5oKB\u000b'\u000f^5uS>tGk\\(oY&tW\r\u0016:b]NLG/[8oQ\r\u0011\u0013\u0011M\u0001;i\u0016\u001cHo\u00148mS:,\u0007+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3Ue\u0006t7/\u001b;j_:4uN]\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:D3aIA1\u0003\u0019\"Xm\u001d;P]2Lg.\u001a)beRLG/[8o)>|eM\u001a7j]\u0016$&/\u00198tSRLwN\u001c\u0015\u0004I\u0005\u0005\u0014A\u000f;fgRLeN^1mS\u0012|e\u000e\\5oKB\u000b'\u000f^5uS>tGk\u001c(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\r)\u0013\u0011M\u00013i\u0016\u001cH/\u00138wC2LGm\u00148mS:,\u0007+\u0019:uSRLwN\u001c+p\u001d\u0016<\b+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aa%!\u0019\u0002_Q,7\u000f^(gM2Lg.\u001a)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007\u001d\n\t'\u0001\u001cuKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c+p+:\u001cG.Z1o\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eF\u0002N\u0003?Cq!!))\u0001\u0004\t\u0019+A\rjg2+\u0017\rZ3s%\u0016\u001cwN^3ssN+\b\u000f]8si\u0016$\u0007cA\u001f\u0002&&\u0019\u0011q\u0015 \u0003\u000f\t{w\u000e\\3b]\"\u001a\u0001&a+\u0011\t\u00055\u00161W\u0007\u0003\u0003_SA!!-\u0002F\u00051\u0001/\u0019:b[NLA!!.\u00020\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\u000f!\nI,!2\u0002HB!\u00111XAa\u001b\t\tiL\u0003\u0003\u0002@\u0006=\u0016\u0001\u00039s_ZLG-\u001a:\n\t\u0005\r\u0017Q\u0018\u0002\f-\u0006dW/Z*pkJ\u001cW-\u0001\u0005c_>dW-\u00198tY\u0011\tI-a3\u001a\u0003\u0005I\u0012\u0001A\u0001Wi\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c.p_.+W\r]3s\u00072LWM\u001c;Fq\u000e,\u0007\u000f^5p]\u001a\u0013x.\\*uCR,Gj\\8lkBD3!KA1\u0003\u001d#Xm\u001d;PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8o\u000bJ\u0014xN]\"pI\u00164%o\\7Ti\u0006$X\rT8pWV\u0004\bf\u0001\u0016\u0002b\u0005!D/Z:u\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$vNT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007-\n\t'A\u001auKN$\u0018J\u001c<bY&$wJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c+p\u001d\u0016<\b+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aA&!\u0019\u0002KA\u0014X\r]1sK6{7m\u001b+p\u000b2,7\r\u001e'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:\u001cHcA'\u0002b\"9\u0011\u0011E\u0017A\u0002\u0005\r\bCBAs\u0003k\fIA\u0004\u0003\u0002h\u0006Eh\u0002BAu\u0003_l!!a;\u000b\u0007\u00055((\u0001\u0004=e>|GOP\u0005\u0002\u007f%\u0019\u00111\u001f \u0002\u000fA\f7m[1hK&!\u00111GA|\u0015\r\t\u0019PP\u0001#i\u0016\u001cH/\u00169eCRLgnZ(gM2Lg.\u001a)beRLG/[8og\u000e{WO\u001c;)\u00079\n\t'\u0001\u001auKN$hj\\(gM2Lg.\u001a)beRLG/[8og\u000eC\u0017M\\4f\r>\u0014Hk\u001c9jGN\u0014U-\u001b8h\t\u0016dW\r^3eQ\ry\u0013\u0011M\u00016i\u0016\u001cH/\u00169eCRLgnZ(gM2Lg.\u001a)beRLG/[8og\u000e{WO\u001c;EkJLgn\u001a+pa&\u001cG)\u001a7fi&|g\u000eK\u00021\u0003C\n\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u0011\u0011IAa\u0004\u0011\u0007\u0015\u0013Y!C\u0002\u0003\u000eY\u0012\u0011CU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u001d\u0011\t\"\ra\u0001\u0005'\t\u0001B]3qY&\u001c\u0017m\u001d\t\u0006\u0003K\f)p]\u0001\u0015GJ,\u0017\r^3Ce>\\WM]!oI\u0016\u0003xn\u00195\u0015\u0019\te!\u0011\u0007B\u001b\u0005\u0013\u0012iE!\u0019\u0011\u000fu\u0012YBa\b\u0003,%\u0019!Q\u0004 \u0003\rQ+\b\u000f\\33!\u0011\u0011\tCa\n\u000e\u0005\t\r\"b\u0001B\u0013q\u000591\r\\;ti\u0016\u0014\u0018\u0002\u0002B\u0015\u0005G\u0011aA\u0011:pW\u0016\u0014\bcA\u001f\u0003.%\u0019!q\u0006 \u0003\t1{gn\u001a\u0005\u0007\u0005g\u0011\u0004\u0019A:\u0002\u0005%$\u0007b\u0002B\u001ce\u0001\u0007!\u0011H\u0001\u0005Q>\u001cH\u000f\u0005\u0003\u0003<\t\rc\u0002\u0002B\u001f\u0005\u007f\u00012!!;?\u0013\r\u0011\tEP\u0001\u0007!J,G-\u001a4\n\t\t\u0015#q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t\u0005c\b\u0003\u0004\u0003LI\u0002\ra]\u0001\u0005a>\u0014H\u000fC\u0005\u0003PI\u0002\n\u00111\u0001\u0003R\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0005\u0005'\u0012i&\u0004\u0002\u0003V)!!q\u000bB-\u0003\u0011\tW\u000f\u001e5\u000b\t\tm\u0013QB\u0001\tg\u0016\u001cWO]5us&!!q\fB+\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G\u000eC\u0005\u0003dI\u0002\n\u00111\u0001\u0003,\u0005)Q\r]8dQ\u0006q2M]3bi\u0016\u0014%o\\6fe\u0006sG-\u00129pG\"$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005SRCA!\u0015\u0003l-\u0012!Q\u000e\t\u0005\u0005_\u0012I(\u0004\u0002\u0003r)!!1\u000fB;\u0003%)hn\u00195fG.,GMC\u0002\u0003xy\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YH!\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0010de\u0016\fG/\u001a\"s_.,'/\u00118e\u000bB|7\r\u001b\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!\u0011\u0011\u0016\u0005\u0005W\u0011Y\u0007")
public class PartitionStateMachineTest {
    private ControllerContext controllerContext;
    private KafkaZkClient mockZkClient;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch;
    private PartitionStateMachine partitionStateMachine;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final scala.collection.immutable.Seq<TopicPartition> partitions = new .colon.colon((Object)this.partition(), (List)Nil$.MODULE$);

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    private void partitionStateMachine_$eq(PartitionStateMachine x$1) {
        this.partitionStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private scala.collection.immutable.Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    @BeforeEach
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)Mockito.mock(ControllerBrokerRequestBatch.class));
        this.partitionStateMachine_$eq((PartitionStateMachine)new ZkPartitionStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext().partitionState(partition);
    }

    @Test
    public void testNonexistentPartitionToNewPartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOnlinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOfflinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransition() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L)})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), true);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromCreateStates() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L)})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenThrow(new Throwable[]{new ZooKeeperClientException("test")});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionErrorCodeFromCreateStates() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L)})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.NODEEXISTS, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOfflinePartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNewPartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransition() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L)})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)new Right((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionForControlledShutdown() {
        int otherBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L), this.createBrokerAndEpoch(otherBrokerId, "host", 0, SecurityProtocol.PLAINTEXT, 0L)})));
        this.controllerContext().shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)this.brokerId()));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(otherBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)new Right((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOfflineTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransition() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L)})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        Mockito.when((Object)this.mockZkClient().getLogConfigs(Predef$.MODULE$.Set().empty(), this.config().originals())).thenReturn((Object)new Tuple2(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition().topic()), (Object)new LogConfig((java.util.Map)new Properties()))})), (Object)Predef$.MODULE$.Map().empty()));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)new Right((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getLogConfigs((scala.collection.immutable.Set)ArgumentMatchers.any(), (java.util.Map)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOfflinePartitionToUncleanOnlinePartitionTransition(boolean isLeaderRecoverySupported) {
        MetadataVersion apiVersion = isLeaderRecoverySupported ? MetadataVersion.IBP_3_2_IV0 : MetadataVersion.IBP_3_1_IV0;
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        properties.setProperty("inter.broker.protocol.version", apiVersion.toString());
        ZkPartitionStateMachine partitionStateMachine = new ZkPartitionStateMachine(KafkaConfig$.MODULE$.fromProps(properties), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch());
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L)})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = isLeaderRecoverySupported ? leaderAndIsr.newRecoveringLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))) : leaderAndIsr.newLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)new Right((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        partitionStateMachine.handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromStateLookup() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L)})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenThrow(new Throwable[]{new ZooKeeperClientException("")});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionErrorCodeFromStateLookup() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L)})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.NONODE, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOfflinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    private void prepareMockToElectLeaderForPartitions(scala.collection.immutable.Seq<TopicPartition> partitions) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.prepareMockToGetTopicPartitionsStatesRaw$1(leaderAndIsr, partitions);
        this.prepareMockToGetLogConfigs$1();
        this.prepareMockToUpdateLeaderAndIsr$1(partitions, leaderAndIsr);
    }

    @Test
    public void testUpdatingOfflinePartitionsCount() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L)})));
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$5 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$1(topic, BoxesRunTime.unboxToInt((Object)x$5)));
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$2(this, partition);
            return BoxedUnit.UNIT;
        });
        this.prepareMockToElectLeaderForPartitions((scala.collection.immutable.Seq<TopicPartition>)partitions);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testNoOfflinePartitionsChangeForTopicsBeingDeleted() {
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$6 -> PartitionStateMachineTest.$anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(topic, BoxesRunTime.unboxToInt((Object)x$6)));
        this.controllerContext().topicsToBeDeleted().add((Object)topic);
        this.controllerContext().topicsWithDeletionStarted().add((Object)topic);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testUpdatingOfflinePartitionsCountDuringTopicDeletion() {
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$7 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(BoxesRunTime.unboxToInt((Object)x$7)));
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(this, partition);
            return BoxedUnit.UNIT;
        });
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(this.controllerContext(), false, true);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(this.controllerContext());
        DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);
        TopicDeletionManager topicDeletionManager = new TopicDeletionManager(this.config(), this.controllerContext(), (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, deletionClient);
        partitionStateMachine.handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        partitionStateMachine.handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(this, partition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        topicDeletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    private ReplicaAssignment replicaAssignment(scala.collection.immutable.Seq<Object> replicas) {
        Nil$ apply_removingReplicas = Nil$.MODULE$;
        Nil$ apply_addingReplicas = Nil$.MODULE$;
        return new ReplicaAssignment(replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
    }

    private Tuple2<Broker, Object> createBrokerAndEpoch(int id, String host, int port, SecurityProtocol securityProtocol, long epoch) {
        return new Tuple2((Object)new Broker(id, host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol), (Object)BoxesRunTime.boxToLong((long)epoch));
    }

    private SecurityProtocol createBrokerAndEpoch$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    private long createBrokerAndEpoch$default$5() {
        return 0L;
    }

    private final void prepareMockToGetTopicPartitionsStatesRaw$1(LeaderAndIsr leaderAndIsr$1, scala.collection.immutable.Seq partitions$1) {
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr$1, this.controllerEpoch());
        scala.collection.immutable.Seq getDataResponses = (scala.collection.immutable.Seq)partitions$1.map((Function1 & Serializable)p -> new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some(p), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)));
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw((Seq)partitions$1)).thenReturn((Object)getDataResponses);
    }

    private final void prepareMockToGetLogConfigs$1() {
        Mockito.when((Object)this.mockZkClient().getLogConfigs(Predef$.MODULE$.Set().empty(), this.config().originals())).thenReturn((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Map().empty()));
    }

    private final void prepareMockToUpdateLeaderAndIsr$1(scala.collection.immutable.Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        scala.collection.immutable.Map updatedLeaderAndIsr = ((IterableOnceOps)partitions$1.map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)leaderAndIsr$1.newLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)updatedLeaderAndIsr, this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)updatedLeaderAndIsr.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                LeaderAndIsr v = (LeaderAndIsr)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)new Right((Object)v));
            }
            throw new MatchError(null);
        }), (Seq)package$.MODULE$.Seq().empty()));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCount$1(String topic$1, int x$5) {
        return new TopicPartition(topic$1, x$5);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCount$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.brokerId()}))));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(String topic$2, int x$6) {
        return new TopicPartition(topic$2, x$6);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(int x$7) {
        return new TopicPartition("test", x$7);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.brokerId()}))));
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(PartitionStateMachineTest $this, TopicPartition partition) {
        PartitionAndReplica replica = new PartitionAndReplica(partition, $this.brokerId());
        $this.controllerContext().putReplicaState(replica, (ReplicaState)OfflineReplica$.MODULE$);
    }

    public PartitionStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

