/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import org.springframework.util.ObjectUtils;
import org.springframework.webflow.engine.model.AbstractMappingModel;
import org.springframework.webflow.engine.model.Model;

public class InputModel
extends AbstractMappingModel {
    public InputModel(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    @Override
    public boolean isMergeableWith(Model model) {
        if (!(model instanceof InputModel)) {
            return false;
        }
        InputModel input = (InputModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getName(), (Object)input.getName());
    }

    @Override
    public void merge(Model model) {
        InputModel input = (InputModel)model;
        this.setValue(this.merge(this.getValue(), input.getValue()));
        this.setType(this.merge(this.getType(), input.getType()));
        this.setRequired(this.merge(this.getRequired(), input.getRequired()));
    }

    @Override
    public Model createCopy() {
        InputModel copy = new InputModel(this.getName(), this.getValue());
        super.fillCopy(copy);
        return copy;
    }
}

