/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.http.common.api.HttpHeaders;
import org.flowable.http.common.api.MultiValuePart;

public class HttpRequest {
    protected String method;
    protected String url;
    protected HttpHeaders httpHeaders;
    protected HttpHeaders secureHttpHeaders;
    protected String body;
    protected String bodyEncoding;
    protected Collection<MultiValuePart> multiValueParts;
    protected Map<String, List<String>> formParameters;
    protected int timeout;
    protected boolean noRedirects;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getHttpHeadersAsString() {
        return this.httpHeaders != null ? this.httpHeaders.formatAsString() : null;
    }

    public void setHttpHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public HttpHeaders getSecureHttpHeaders() {
        return this.secureHttpHeaders;
    }

    public String getSecureHttpHeadersAsString() {
        return this.secureHttpHeaders != null ? this.secureHttpHeaders.formatAsString(true) : null;
    }

    public void setSecureHttpHeaders(HttpHeaders secureHttpHeaders) {
        this.secureHttpHeaders = secureHttpHeaders;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        if (this.multiValueParts != null && !this.multiValueParts.isEmpty()) {
            throw new FlowableIllegalStateException("Cannot set both body and multi value parts");
        }
        if (this.formParameters != null && !this.formParameters.isEmpty()) {
            throw new FlowableIllegalStateException("Cannot set both body and form parameters");
        }
        this.body = body;
    }

    public String getBodyEncoding() {
        return this.bodyEncoding;
    }

    public void setBodyEncoding(String bodyEncoding) {
        this.bodyEncoding = bodyEncoding;
    }

    public Collection<MultiValuePart> getMultiValueParts() {
        return this.multiValueParts;
    }

    public void addMultiValuePart(MultiValuePart part) {
        if (this.body != null) {
            throw new FlowableIllegalStateException("Cannot set both body and multi value parts");
        }
        if (this.formParameters != null && !this.formParameters.isEmpty()) {
            throw new FlowableIllegalStateException("Cannot set both form parameters and multi value parts");
        }
        if (this.multiValueParts == null) {
            this.multiValueParts = new ArrayList<MultiValuePart>();
        }
        this.multiValueParts.add(part);
    }

    public Map<String, List<String>> getFormParameters() {
        return this.formParameters;
    }

    public void addFormParameter(String key, String value) {
        if (this.body != null) {
            throw new FlowableIllegalStateException("Cannot set both body and form parameters");
        }
        if (this.multiValueParts != null && !this.multiValueParts.isEmpty()) {
            throw new FlowableIllegalStateException("Cannot set both multi value parts and form parameters");
        }
        if (this.formParameters == null) {
            this.formParameters = new LinkedHashMap<String, List<String>>();
        }
        this.formParameters.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isNoRedirects() {
        return this.noRedirects;
    }

    public void setNoRedirects(boolean noRedirects) {
        this.noRedirects = noRedirects;
    }
}

