/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.wssecurity.messaging.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazyList;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.wssecurity.SAML20AssertionToken;
import org.opensaml.saml.saml2.wssecurity.messaging.impl.DefaultSAML20AssertionValidationContextBuilder;
import org.opensaml.saml.saml2.wssecurity.messaging.impl.SAML20AssertionTokenValidationInput;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.soap.wssecurity.WSSecurityConstants;
import org.opensaml.soap.wssecurity.messaging.Token;
import org.opensaml.soap.wssecurity.messaging.WSSecurityContext;
import org.slf4j.Logger;

public class WSSecuritySAML20AssertionTokenSecurityHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(WSSecuritySAML20AssertionTokenSecurityHandler.class);
    @Nullable
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;
    private boolean invalidFatal;
    @Nonnull
    private Function<Pair<MessageContext, Assertion>, SAML20AssertionValidator> assertionValidatorLookup;
    @NonnullAfterInit
    private Function<SAML20AssertionTokenValidationInput, ValidationContext> validationContextBuilder;

    public WSSecuritySAML20AssertionTokenSecurityHandler() {
        this.setInvalidFatal(true);
        this.setValidationContextBuilder(new DefaultSAML20AssertionValidationContextBuilder());
        this.assertionValidatorLookup = FunctionSupport.constant(null);
    }

    @NonnullAfterInit
    public Function<SAML20AssertionTokenValidationInput, ValidationContext> getValidationContextBuilder() {
        return this.validationContextBuilder;
    }

    public void setValidationContextBuilder(@Nonnull Function<SAML20AssertionTokenValidationInput, ValidationContext> builder) {
        this.checkSetterPreconditions();
        this.validationContextBuilder = (Function)Constraint.isNotNull(builder, (String)"Validation context builder may not be null");
    }

    @Nullable
    public HttpServletRequest getHttpServletRequest() {
        if (this.httpServletRequestSupplier != null) {
            return (HttpServletRequest)this.httpServletRequestSupplier.get();
        }
        return null;
    }

    @Nullable
    public NonnullSupplier<HttpServletRequest> getHttpServletRequestSupplier() {
        return this.httpServletRequestSupplier;
    }

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> requestSupplier) {
        this.checkSetterPreconditions();
        this.httpServletRequestSupplier = requestSupplier;
    }

    public boolean isInvalidFatal() {
        return this.invalidFatal;
    }

    public void setInvalidFatal(boolean flag) {
        this.checkSetterPreconditions();
        this.invalidFatal = flag;
    }

    @Nullable
    public SAML20AssertionValidator getAssertionValidator(@Nullable MessageContext messageContext, @Nullable Assertion assertion) {
        return this.assertionValidatorLookup.apply((Pair<MessageContext, Assertion>)new Pair((Object)messageContext, (Object)assertion));
    }

    public void setAssertionValidator(@Nullable SAML20AssertionValidator validator) {
        this.checkSetterPreconditions();
        this.assertionValidatorLookup = FunctionSupport.constant((Object)validator);
    }

    @Nullable
    public Function<Pair<MessageContext, Assertion>, SAML20AssertionValidator> getAssertionValidatorLookup() {
        return this.assertionValidatorLookup;
    }

    public void setAssertionValidatorLookup(@Nonnull Function<Pair<MessageContext, Assertion>, SAML20AssertionValidator> function) {
        this.checkSetterPreconditions();
        this.assertionValidatorLookup = (Function)Constraint.isNotNull(function, (String)"Assertion validator lookup function cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getValidationContextBuilder() == null) {
            throw new ComponentInitializationException("ValidationContext builder cannot be null");
        }
        if (this.getHttpServletRequest() == null) {
            throw new ComponentInitializationException("HttpServletRequest cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!SOAPMessagingSupport.isSOAPMessage((MessageContext)messageContext)) {
            this.log.info("Message context does not contain a SOAP envelope. Skipping rule...");
            return;
        }
        List<Assertion> assertions = this.resolveAssertions(messageContext);
        if (assertions == null || assertions.isEmpty()) {
            this.log.info("Inbound SOAP envelope contained no Assertion tokens. Skipping further processing");
            return;
        }
        WSSecurityContext wsContext = (WSSecurityContext)messageContext.ensureSubcontext(WSSecurityContext.class);
        for (Assertion assertion : assertions) {
            assert (assertion != null);
            SAML20AssertionValidator validator = this.getAssertionValidator(messageContext, assertion);
            if (validator == null) {
                this.log.warn("No SAML20AssertionValidator was available, terminating");
                SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (QName)FaultCode.SERVER, (String)"Internal processing error", null, null, null);
                throw new MessageHandlerException("No SAML20AssertionValidator was available");
            }
            ValidationContext validationContext = this.buildValidationContext(messageContext, assertion);
            try {
                ValidationResult validationResult = validator.validate(assertion, validationContext);
                SAML20AssertionToken token = new SAML20AssertionToken(assertion);
                this.processResult(validationContext, validationResult, token, messageContext);
                wsContext.getTokens().add(token);
            }
            catch (AssertionValidationException e) {
                this.log.warn("There was a problem determining Assertion validity: {}", (Object)e.getMessage());
                SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (QName)FaultCode.SERVER, (String)"Internal security token processing error", null, null, null);
                throw new MessageHandlerException("Error determining SAML 2.0 Assertion validity", (Exception)((Object)e));
            }
        }
    }

    protected void processResult(@Nonnull ValidationContext validationContext, @Nonnull ValidationResult validationResult, @Nonnull SAML20AssertionToken token, @Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.log.debug("Assertion token validation result was: {}", (Object)validationResult);
        switch (validationResult) {
            case VALID: {
                token.setValidationStatus(Token.ValidationStatus.VALID);
                token.setSubjectConfirmation((SubjectConfirmation)validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"));
                break;
            }
            case INVALID: {
                this.log.warn("Assertion token validation was INVALID. Reason(s): {}", (Object)validationContext.getValidationFailureMessages());
                if (this.isInvalidFatal()) {
                    SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (QName)WSSecurityConstants.SOAP_FAULT_INVALID_SECURITY_TOKEN, (String)"The SAML 2.0 Assertion token was invalid", null, null, null);
                    throw new MessageHandlerException("Assertion token validation result was INVALID");
                }
                token.setValidationStatus(Token.ValidationStatus.INVALID);
                token.setSubjectConfirmation((SubjectConfirmation)validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"));
                break;
            }
            case INDETERMINATE: {
                this.log.warn("Assertion token validation was INDETERMINATE. Reason(s): {}", (Object)validationContext.getValidationFailureMessages());
                if (this.isInvalidFatal()) {
                    SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (QName)WSSecurityConstants.SOAP_FAULT_INVALID_SECURITY_TOKEN, (String)"The SAML 2.0 Assertion token's validity could not be determined", null, null, null);
                    throw new MessageHandlerException("Assertion token validation result was INDETERMINATE");
                }
                token.setValidationStatus(Token.ValidationStatus.INDETERMINATE);
                token.setSubjectConfirmation((SubjectConfirmation)validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"));
                break;
            }
            default: {
                this.log.warn("Assertion validation result indicated an unknown value: {}", (Object)validationResult);
                SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (QName)FaultCode.SERVER, (String)"Internal processing error", null, null, null);
                throw new IllegalArgumentException("Assertion validation result indicated an unknown value: " + String.valueOf(validationResult));
            }
        }
    }

    @Nonnull
    protected ValidationContext buildValidationContext(@Nonnull MessageContext messageContext, @Nonnull Assertion assertion) throws MessageHandlerException {
        HttpServletRequest servletRequest = this.getHttpServletRequest();
        if (servletRequest == null) {
            this.log.warn("HttpServletRequest was null");
            SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (QName)FaultCode.SERVER, (String)"Internal processing error", null, null, null);
            throw new MessageHandlerException("HttpServletRequest was null");
        }
        ValidationContext validationContext = this.getValidationContextBuilder().apply(new SAML20AssertionTokenValidationInput(messageContext, servletRequest, assertion));
        if (validationContext == null) {
            this.log.warn("ValidationContext produced was null");
            SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (QName)FaultCode.SERVER, (String)"Internal processing error", null, null, null);
            throw new MessageHandlerException("No ValidationContext was produced");
        }
        return validationContext;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<Assertion> resolveAssertions(@Nonnull MessageContext messageContext) {
        List securityHeaders = SOAPMessagingSupport.getInboundHeaderBlock((MessageContext)messageContext, (QName)Security.ELEMENT_NAME);
        if (securityHeaders == null || securityHeaders.isEmpty()) {
            this.log.debug("No WS-Security Security header found in inbound SOAP message. Skipping further processing.");
            return CollectionSupport.emptyList();
        }
        LazyList assertions = new LazyList();
        for (XMLObject header : securityHeaders) {
            Security securityHeader = (Security)header;
            List xmlObjects = securityHeader.getUnknownXMLObjects(Assertion.DEFAULT_ELEMENT_NAME);
            if (xmlObjects.isEmpty()) continue;
            for (XMLObject xmlObject : xmlObjects) {
                assertions.add((Object)((Assertion)xmlObject));
            }
        }
        return assertions;
    }
}

