/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.spring.boot;

import java.util.Formatter;
import java.util.List;
import java.util.ServiceLoader;
import org.apereo.cas.util.spring.boot.DefaultCasBanner;
import org.springframework.boot.Banner;
import org.springframework.core.env.Environment;

public interface CasBanner
extends Banner {
    public String getTitle();

    default public void injectEnvironmentInfo(Formatter formatter, Environment environment, Class<?> sourceClass) {
        if (environment.getActiveProfiles().length > 0) {
            formatter.format("Active Profiles: %s%n", String.join((CharSequence)",", environment.getActiveProfiles()));
        }
    }

    public static CasBanner getInstance() {
        List<CasBanner> subTypes = ServiceLoader.load(CasBanner.class).stream().map(ServiceLoader.Provider::get).toList();
        return subTypes.isEmpty() ? new DefaultCasBanner() : subTypes.getFirst();
    }
}

