/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.Collections;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.Utils;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipProvider;
import org.jetbrains.annotations.NotNull;

class EveryoneMembershipProvider
implements DynamicMembershipProvider {
    private final UserManager userManager;
    private final String repPrincipalName;

    EveryoneMembershipProvider(@NotNull UserManager userManager, @NotNull NamePathMapper namePathMapper) {
        this.userManager = userManager;
        this.repPrincipalName = namePathMapper.getJcrName("rep:principalName");
    }

    @Override
    public boolean coversAllMembers(@NotNull Group group) {
        return Utils.isEveryone(group);
    }

    @Override
    @NotNull
    public Iterator<Authorizable> getMembers(@NotNull Group group, boolean includeInherited) throws RepositoryException {
        if (Utils.isEveryone(group)) {
            Iterator<Authorizable> result = IteratorUtils.filter(this.userManager.findAuthorizables(this.repPrincipalName, null, 3), x -> x != null);
            return IteratorUtils.filter(result, authorizable -> !Utils.isEveryone(authorizable));
        }
        return RangeIteratorAdapter.EMPTY;
    }

    @Override
    public boolean isMember(@NotNull Group group, @NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        return Utils.isEveryone(group);
    }

    @Override
    @NotNull
    public Iterator<Group> getMembership(@NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        Authorizable everyoneGroup = this.userManager.getAuthorizable(EveryonePrincipal.getInstance());
        if (everyoneGroup instanceof Group) {
            return new RangeIteratorAdapter(Collections.singleton((Group)everyoneGroup));
        }
        return RangeIteratorAdapter.EMPTY;
    }
}

