/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Operator;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.TextQueryType;
import org.opensearch.client.opensearch._types.query_dsl.ZeroTermsQuery;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class MultiMatchQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean autoGenerateSynonymsPhraseQuery;
    @Nullable
    private final Double cutoffFrequency;
    private final List<String> fields;
    @Nullable
    private final String fuzziness;
    @Nullable
    private final String fuzzyRewrite;
    @Nullable
    private final Boolean fuzzyTranspositions;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Integer maxExpansions;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final Operator operator;
    @Nullable
    private final Integer prefixLength;
    private final String query;
    @Nullable
    private final Integer slop;
    @Nullable
    private final Double tieBreaker;
    @Nullable
    private final TextQueryType type;
    @Nullable
    private final ZeroTermsQuery zeroTermsQuery;
    public static final JsonpDeserializer<MultiMatchQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiMatchQuery::setupMultiMatchQueryDeserializer);

    private MultiMatchQuery(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.autoGenerateSynonymsPhraseQuery = builder.autoGenerateSynonymsPhraseQuery;
        this.cutoffFrequency = builder.cutoffFrequency;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.fuzziness = builder.fuzziness;
        this.fuzzyRewrite = builder.fuzzyRewrite;
        this.fuzzyTranspositions = builder.fuzzyTranspositions;
        this.lenient = builder.lenient;
        this.maxExpansions = builder.maxExpansions;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.operator = builder.operator;
        this.prefixLength = builder.prefixLength;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.slop = builder.slop;
        this.tieBreaker = builder.tieBreaker;
        this.type = builder.type;
        this.zeroTermsQuery = builder.zeroTermsQuery;
    }

    public static MultiMatchQuery of(Function<Builder, ObjectBuilder<MultiMatchQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.MultiMatch;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Deprecated
    @Nullable
    public final Double cutoffFrequency() {
        return this.cutoffFrequency;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final String fuzziness() {
        return this.fuzziness;
    }

    @Nullable
    public final String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    @Nullable
    public final Boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    @Nullable
    public final Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public final Integer maxExpansions() {
        return this.maxExpansions;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public final Operator operator() {
        return this.operator;
    }

    @Nullable
    public final Integer prefixLength() {
        return this.prefixLength;
    }

    public final String query() {
        return this.query;
    }

    @Nullable
    public final Integer slop() {
        return this.slop;
    }

    @Nullable
    public final Double tieBreaker() {
        return this.tieBreaker;
    }

    @Nullable
    public final TextQueryType type() {
        return this.type;
    }

    @Nullable
    public final ZeroTermsQuery zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.autoGenerateSynonymsPhraseQuery != null) {
            generator.writeKey("auto_generate_synonyms_phrase_query");
            generator.write(this.autoGenerateSynonymsPhraseQuery.booleanValue());
        }
        if (this.cutoffFrequency != null) {
            generator.writeKey("cutoff_frequency");
            generator.write(this.cutoffFrequency.doubleValue());
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        if (this.fuzzyRewrite != null) {
            generator.writeKey("fuzzy_rewrite");
            generator.write(this.fuzzyRewrite);
        }
        if (this.fuzzyTranspositions != null) {
            generator.writeKey("fuzzy_transpositions");
            generator.write(this.fuzzyTranspositions.booleanValue());
        }
        if (this.lenient != null) {
            generator.writeKey("lenient");
            generator.write(this.lenient.booleanValue());
        }
        if (this.maxExpansions != null) {
            generator.writeKey("max_expansions");
            generator.write(this.maxExpansions.intValue());
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.operator != null) {
            generator.writeKey("operator");
            this.operator.serialize(generator, mapper);
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.slop != null) {
            generator.writeKey("slop");
            generator.write(this.slop.intValue());
        }
        if (this.tieBreaker != null) {
            generator.writeKey("tie_breaker");
            generator.write(this.tieBreaker.doubleValue());
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
        if (this.zeroTermsQuery != null) {
            generator.writeKey("zero_terms_query");
            this.zeroTermsQuery.serialize(generator, mapper);
        }
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).analyzer(this.analyzer).autoGenerateSynonymsPhraseQuery(this.autoGenerateSynonymsPhraseQuery).cutoffFrequency(this.cutoffFrequency).fields(this.fields).fuzziness(this.fuzziness).fuzzyRewrite(this.fuzzyRewrite).fuzzyTranspositions(this.fuzzyTranspositions).lenient(this.lenient).maxExpansions(this.maxExpansions).minimumShouldMatch(this.minimumShouldMatch).operator(this.operator).prefixLength(this.prefixLength).query(this.query).slop(this.slop).tieBreaker(this.tieBreaker).type(this.type).zeroTermsQuery(this.zeroTermsQuery);
    }

    protected static void setupMultiMatchQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::autoGenerateSynonymsPhraseQuery, JsonpDeserializer.booleanDeserializer(), "auto_generate_synonyms_phrase_query");
        op.add(Builder::cutoffFrequency, JsonpDeserializer.doubleDeserializer(), "cutoff_frequency");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness");
        op.add(Builder::fuzzyRewrite, JsonpDeserializer.stringDeserializer(), "fuzzy_rewrite");
        op.add(Builder::fuzzyTranspositions, JsonpDeserializer.booleanDeserializer(), "fuzzy_transpositions");
        op.add(Builder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient");
        op.add(Builder::maxExpansions, JsonpDeserializer.integerDeserializer(), "max_expansions");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::operator, Operator._DESERIALIZER, "operator");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::slop, JsonpDeserializer.integerDeserializer(), "slop");
        op.add(Builder::tieBreaker, JsonpDeserializer.doubleDeserializer(), "tie_breaker");
        op.add(Builder::type, TextQueryType._DESERIALIZER, "type");
        op.add(Builder::zeroTermsQuery, ZeroTermsQuery._DESERIALIZER, "zero_terms_query");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MultiMatchQuery> {
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean autoGenerateSynonymsPhraseQuery;
        @Nullable
        private Double cutoffFrequency;
        @Nullable
        private List<String> fields;
        @Nullable
        private String fuzziness;
        @Nullable
        private String fuzzyRewrite;
        @Nullable
        private Boolean fuzzyTranspositions;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Integer maxExpansions;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private Operator operator;
        @Nullable
        private Integer prefixLength;
        private String query;
        @Nullable
        private Integer slop;
        @Nullable
        private Double tieBreaker;
        @Nullable
        private TextQueryType type;
        @Nullable
        private ZeroTermsQuery zeroTermsQuery;

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder autoGenerateSynonymsPhraseQuery(@Nullable Boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
            return this;
        }

        @Deprecated
        public final Builder cutoffFrequency(@Nullable Double value) {
            this.cutoffFrequency = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        public final Builder fuzzyRewrite(@Nullable String value) {
            this.fuzzyRewrite = value;
            return this;
        }

        public final Builder fuzzyTranspositions(@Nullable Boolean value) {
            this.fuzzyTranspositions = value;
            return this;
        }

        public final Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public final Builder maxExpansions(@Nullable Integer value) {
            this.maxExpansions = value;
            return this;
        }

        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public final Builder operator(@Nullable Operator value) {
            this.operator = value;
            return this;
        }

        public final Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        public final Builder slop(@Nullable Integer value) {
            this.slop = value;
            return this;
        }

        public final Builder tieBreaker(@Nullable Double value) {
            this.tieBreaker = value;
            return this;
        }

        public final Builder type(@Nullable TextQueryType value) {
            this.type = value;
            return this;
        }

        public final Builder zeroTermsQuery(@Nullable ZeroTermsQuery value) {
            this.zeroTermsQuery = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiMatchQuery build() {
            this._checkSingleUse();
            return new MultiMatchQuery(this);
        }
    }
}

